/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.approval;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public final class ApprovalRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @UriParam
    @Metadata(required=true)
    private Action actionType;
    @UriParam
    @Metadata(required=true)
    private String contextActorId;
    @UriParam
    @Metadata(required=true)
    private String contextId;
    @UriParam
    private String comments;
    @UriParam
    @Metadata(required=true)
    private List<String> nextApproverIds;
    @UriParam
    @Metadata(required=true)
    private String processDefinitionNameOrId;
    @UriParam
    private boolean skipEntryCriteria;

    public void addNextApproverId(String nextApproverId) {
        this.nextApproverIds = Optional.ofNullable(this.nextApproverIds).orElse(new ArrayList());
        this.nextApproverIds.add(nextApproverId);
    }

    public ApprovalRequest applyTemplate(ApprovalRequest template) {
        if (template == null) {
            return this;
        }
        ApprovalRequest withTemplateValues = new ApprovalRequest();
        for (Field field : FieldHolder.INSTANCE.fields) {
            try {
                Object currentValue = field.get(this);
                if (currentValue == null) {
                    Object templateValue = field.get(template);
                    if (templateValue == null) continue;
                    field.set(withTemplateValues, templateValue);
                    continue;
                }
                field.set(withTemplateValues, currentValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalStateException("Unable to apply values from template", e);
            }
        }
        return withTemplateValues;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApprovalRequest)) {
            return false;
        }
        ApprovalRequest other = (ApprovalRequest)obj;
        return Objects.equals((Object)this.actionType, (Object)other.actionType) && Objects.equals(this.contextActorId, other.contextActorId) && Objects.equals(this.contextId, other.contextId) && Objects.equals(this.comments, other.comments) && Objects.equals(this.nextApproverIds, other.nextApproverIds) && Objects.equals(this.processDefinitionNameOrId, other.processDefinitionNameOrId) && Objects.equals(this.skipEntryCriteria, other.skipEntryCriteria);
    }

    public Action getActionType() {
        return this.actionType;
    }

    public String getComments() {
        return this.comments;
    }

    public String getContextActorId() {
        return this.contextActorId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public List<String> getNextApproverIds() {
        return this.listFromNullable(this.nextApproverIds);
    }

    public String getProcessDefinitionNameOrId() {
        return this.processDefinitionNameOrId;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.actionType, this.contextActorId, this.contextId, this.comments, this.nextApproverIds, this.processDefinitionNameOrId, this.skipEntryCriteria});
    }

    public boolean isSkipEntryCriteria() {
        return this.skipEntryCriteria;
    }

    public void setActionType(Action actionType) {
        this.actionType = actionType;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setContextActorId(String contextActorId) {
        this.contextActorId = contextActorId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void setNextApproverIds(List<String> nextApproverIds) {
        this.nextApproverIds = new ArrayList<String>(this.listFromNullable(nextApproverIds));
    }

    public void setNextApproverIds(String nextApproverId) {
        this.nextApproverIds = Collections.singletonList(nextApproverId);
    }

    public void setProcessDefinitionNameOrId(String processDefinitionNameOrId) {
        this.processDefinitionNameOrId = processDefinitionNameOrId;
    }

    public void setSkipEntryCriteria(boolean skipEntryCriteria) {
        this.skipEntryCriteria = skipEntryCriteria;
    }

    public String toString() {
        StringBuilder buildy = new StringBuilder("ApprovalRequest: ");
        buildy.append("actionType: ").append((Object)this.actionType);
        buildy.append(", contextActorId: ").append(this.contextActorId);
        buildy.append(", contextId: ").append(this.contextId);
        buildy.append(", comments: ").append(this.comments);
        buildy.append(", nextApproverIds: ").append(this.nextApproverIds);
        buildy.append(", processDefinitionNameOrId: ").append(this.processDefinitionNameOrId);
        buildy.append(", skipEntryCriteria: ").append(this.skipEntryCriteria);
        return buildy.toString();
    }

    private List<String> listFromNullable(List<String> nullable) {
        return Optional.ofNullable(nullable).orElse(Collections.emptyList());
    }

    private static final class FieldHolder {
        public static final FieldHolder INSTANCE = new FieldHolder();
        public final List<Field> fields = Arrays.stream(ApprovalRequest.class.getDeclaredFields()).filter(f -> !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());

        private FieldHolder() {
        }
    }

    public static enum Action {
        Submit,
        Approve,
        Reject;

    }
}

