/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.PlatformEvent;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.streaming.PushTopicHelper;
import org.apache.camel.component.salesforce.internal.streaming.SubscriptionHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.common.HashMapMessage;
import org.cometd.common.JacksonJSONContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingApiConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingApiConsumer.class);
    private static final String CREATED_DATE_PROPERTY = "createdDate";
    private static final String EVENT_PROPERTY = "event";
    private static final double MINIMUM_VERSION = 24.0;
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();
    private static final String PAYLOAD_PROPERTY = "payload";
    private static final String REPLAY_ID_PROPERTY = "replayId";
    private static final String SCHEMA_PROPERTY = "schema";
    private static final String SOBJECT_PROPERTY = "sobject";
    private static final String TYPE_PROPERTY = "type";
    private final SalesforceEndpoint endpoint;
    private final MessageKind messageKind;
    private final ObjectMapper objectMapper;
    private final boolean rawPayload;
    private Class<?> sObjectClass;
    private boolean subscribed;
    private final SubscriptionHelper subscriptionHelper;
    private final String topicName;

    public StreamingApiConsumer(SalesforceEndpoint endpoint, Processor processor, SubscriptionHelper helper) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        ObjectMapper configuredObjectMapper = endpoint.getConfiguration().getObjectMapper();
        this.objectMapper = configuredObjectMapper != null ? configuredObjectMapper : OBJECT_MAPPER;
        if (Double.parseDouble(endpoint.getConfiguration().getApiVersion()) < 24.0) {
            throw new IllegalArgumentException("Minimum supported API version for consumer endpoints is 24.0");
        }
        this.topicName = endpoint.getTopicName();
        this.subscriptionHelper = helper;
        this.messageKind = MessageKind.fromTopicName(this.topicName);
        this.rawPayload = endpoint.getConfiguration().isRawPayload();
    }

    public String getTopicName() {
        return this.topicName;
    }

    public SubscriptionHelper getSubscriptionHelper() {
        return this.subscriptionHelper;
    }

    public void handleException(String message, Throwable t) {
        super.handleException(message, t);
    }

    public void processMessage(ClientSessionChannel channel, org.cometd.bayeux.Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received event {} on channel {}", (Object)channel.getId(), (Object)channel.getChannelId());
        }
        Exchange exchange = this.createExchange(true);
        Message in = exchange.getIn();
        switch (this.messageKind.ordinal()) {
            case 2: {
                this.createPushTopicMessage(message, in);
                break;
            }
            case 1: {
                this.createPlatformEventMessage(message, in);
                break;
            }
            case 0: {
                this.createChangeEventMessage(message, in);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown message kind: " + String.valueOf((Object)this.messageKind));
            }
        }
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    }

    void createChangeEventMessage(org.cometd.bayeux.Message message, Message in) {
        this.setHeaders(in, message);
        Map data = message.getDataAsMap();
        Map event = (Map)data.get(EVENT_PROPERTY);
        Object replayId = event.get(REPLAY_ID_PROPERTY);
        if (replayId != null) {
            in.setHeader("CamelSalesforceReplayId", replayId);
        }
        in.setHeader("CamelSalesforceChangeEventSchema", data.get(SCHEMA_PROPERTY));
        in.setHeader("CamelSalesforceEventType", (Object)this.topicName.substring(this.topicName.lastIndexOf(47) + 1));
        Map payload = (Map)data.get(PAYLOAD_PROPERTY);
        Map changeEventHeader = (Map)payload.get("ChangeEventHeader");
        in.setHeader("CamelSalesforceChangeType", changeEventHeader.get("changeType"));
        in.setHeader("CamelSalesforceChangeOrigin", changeEventHeader.get("changeOrigin"));
        in.setHeader("CamelSalesforceTransactionKey", changeEventHeader.get("transactionKey"));
        in.setHeader("CamelSalesforceSequenceNumber", changeEventHeader.get("sequenceNumber"));
        in.setHeader("CamelSalesforceIsTransactionEnd", changeEventHeader.get("isTransactionEnd"));
        in.setHeader("CamelSalesforceCommitTimestamp", changeEventHeader.get("commitTimestamp"));
        in.setHeader("CamelSalesforceCommitUser", changeEventHeader.get("commitUser"));
        in.setHeader("CamelSalesforceCommitNumber", changeEventHeader.get("commitNumber"));
        in.setHeader("CamelSalesforceEntityName", changeEventHeader.get("entityName"));
        in.setHeader("CamelSalesforceRecordIds", changeEventHeader.get("recordIds"));
        if (this.rawPayload) {
            in.setBody((Object)new JacksonJSONContextClient().generate((Message.Mutable)new HashMapMessage(message)));
        } else {
            payload.remove("ChangeEventHeader");
            in.setBody((Object)payload);
        }
    }

    void createPlatformEventMessage(org.cometd.bayeux.Message message, Message in) {
        this.setHeaders(in, message);
        Map data = message.getDataAsMap();
        Map event = (Map)data.get(EVENT_PROPERTY);
        Object replayId = event.get(REPLAY_ID_PROPERTY);
        if (replayId != null) {
            in.setHeader("CamelSalesforceReplayId", replayId);
        }
        in.setHeader("CamelSalesforcePlatformEventSchema", data.get(SCHEMA_PROPERTY));
        in.setHeader("CamelSalesforceEventType", (Object)this.topicName.substring(this.topicName.lastIndexOf(47) + 1));
        Object payload = data.get(PAYLOAD_PROPERTY);
        PlatformEvent platformEvent = (PlatformEvent)this.objectMapper.convertValue(payload, PlatformEvent.class);
        in.setHeader("CamelSalesforceCreatedDate", (Object)platformEvent.getCreated());
        if (this.rawPayload) {
            in.setBody((Object)new JacksonJSONContextClient().generate((Message.Mutable)new HashMapMessage(message)));
        } else {
            in.setBody((Object)platformEvent);
        }
    }

    void createPushTopicMessage(org.cometd.bayeux.Message message, Message in) {
        this.setHeaders(in, message);
        Map data = message.getDataAsMap();
        Map event = (Map)data.get(EVENT_PROPERTY);
        Object eventType = event.get(TYPE_PROPERTY);
        Object createdDate = event.get(CREATED_DATE_PROPERTY);
        Object replayId = event.get(REPLAY_ID_PROPERTY);
        in.setHeader("CamelSalesforceTopicName", (Object)this.topicName);
        in.setHeader("CamelSalesforceEventType", eventType);
        in.setHeader("CamelSalesforceCreatedDate", createdDate);
        if (replayId != null) {
            in.setHeader("CamelSalesforceReplayId", replayId);
        }
        Map sObject = (Map)data.get(SOBJECT_PROPERTY);
        try {
            String sObjectString = this.objectMapper.writeValueAsString((Object)sObject);
            LOG.debug("Received SObject: {}", (Object)sObjectString);
            if (this.rawPayload) {
                in.setBody((Object)sObjectString);
            } else if (this.sObjectClass == null) {
                in.setBody((Object)sObject);
            } else {
                in.setBody(this.objectMapper.readValue((Reader)new StringReader(sObjectString), this.sObjectClass));
            }
        }
        catch (IOException e) {
            String msg = String.format("Error parsing message [%s] from Topic %s: %s", message, this.topicName, e.getMessage());
            this.handleException(msg, (Throwable)((Object)new SalesforceException(msg, e)));
        }
    }

    void setHeaders(Message in, org.cometd.bayeux.Message message) {
        in.setHeader("CamelSalesforceChannel", (Object)message.getChannel());
        String clientId = message.getClientId();
        if (ObjectHelper.isNotEmpty((String)clientId)) {
            in.setHeader("CamelSalesforceClientId", (Object)clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        super.doStart();
        this.determineSObjectClass();
        SalesforceEndpointConfig config = this.endpoint.getConfiguration();
        if (this.messageKind == MessageKind.PUSH_TOPIC && ObjectHelper.isNotEmpty((String)config.getSObjectQuery())) {
            SalesforceComponent salesforceComponent = this.endpoint.getComponent();
            RestClient restClient = salesforceComponent.createRestClientFor(this.endpoint);
            ServiceHelper.startService((Object)restClient);
            try {
                PushTopicHelper helper = new PushTopicHelper(config, this.topicName, restClient);
                helper.createOrUpdateTopic();
            }
            finally {
                ServiceHelper.stopService((Object)restClient);
            }
        }
        ServiceHelper.startService((Service)this.subscriptionHelper);
        this.subscriptionHelper.subscribe(this.topicName, this);
        this.subscribed = true;
    }

    public void stop(boolean alsoStopSubscription) {
        if (alsoStopSubscription) {
            LOG.info("Force stopping Consumer and SubscriptionHelper");
        }
        this.stop();
        if (alsoStopSubscription) {
            try {
                ServiceHelper.stopService((Service)this.subscriptionHelper);
            }
            catch (Exception e) {
                LOG.warn("Failed to stop subscription due to: {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.subscribed) {
            this.subscribed = false;
            this.subscriptionHelper.unsubscribe(this.topicName, this);
        }
    }

    void determineSObjectClass() {
        if (!this.rawPayload) {
            String sObjectName = this.endpoint.getConfiguration().getSObjectName();
            if (sObjectName != null) {
                this.sObjectClass = this.endpoint.getComponent().getClassMap().get(sObjectName);
                if (this.sObjectClass == null) {
                    throw new IllegalArgumentException(String.format("SObject Class not found for %s", sObjectName));
                }
            } else {
                String className = this.endpoint.getConfiguration().getSObjectClass();
                if (className != null) {
                    this.sObjectClass = this.endpoint.getComponent().getCamelContext().getClassResolver().resolveClass(className);
                    if (this.sObjectClass == null) {
                        throw new IllegalArgumentException(String.format("SObject Class not found %s", className));
                    }
                } else {
                    LOG.warn("Property sObjectName or sObjectClass NOT set, messages will be of type java.lang.Map");
                    this.sObjectClass = null;
                }
            }
        } else {
            this.sObjectClass = null;
        }
    }

    private static enum MessageKind {
        CHANGE_EVENT,
        PLATFORM_EVENT,
        PUSH_TOPIC;


        public static MessageKind fromTopicName(String topicName) {
            if (topicName.startsWith("event/") || topicName.startsWith("/event/")) {
                return PLATFORM_EVENT;
            }
            if (topicName.startsWith("data/") || topicName.startsWith("/data/")) {
                return CHANGE_EVENT;
            }
            return PUSH_TOPIC;
        }
    }
}

