/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.SalesforceComponentVerifierExtension;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.SalesforceMetaDataExtension;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractDTOBase;
import org.apache.camel.component.salesforce.api.utils.SecurityUtils;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.DefaultRawClient;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.client.RawClient;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.streaming.SubscriptionHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="salesforce")
public class SalesforceComponent
extends DefaultComponent
implements SSLContextParametersAware {
    public static final String HTTP_PROXY_HOST = "httpProxyHost";
    public static final String HTTP_PROXY_PORT = "httpProxyPort";
    public static final String HTTP_PROXY_IS_SOCKS4 = "isHttpProxySocks4";
    public static final String HTTP_PROXY_IS_SECURE = "isHttpProxySecure";
    public static final String HTTP_PROXY_INCLUDE = "httpProxyInclude";
    public static final String HTTP_PROXY_EXCLUDE = "httpProxyExclude";
    public static final String HTTP_PROXY_USERNAME = "httpProxyUsername";
    public static final String HTTP_PROXY_PASSWORD = "httpProxyPassword";
    public static final String HTTP_PROXY_USE_DIGEST_AUTH = "httpProxyUseDigestAuth";
    public static final String HTTP_PROXY_AUTH_URI = "httpProxyAuthUri";
    public static final String HTTP_PROXY_REALM = "httpProxyRealm";
    public static final String HTTP_CONNECTION_TIMEOUT = "httpConnectionTimeout";
    public static final String HTTP_IDLE_TIMEOUT = "httpIdleTimeout";
    public static final String HTTP_REQUEST_TIMEOUT = "httpRequestTimeout";
    public static final String HTTP_MAX_CONTENT_LENGTH = "httpMaxContentLength";
    public static final String HTTP_REQUEST_BUFFER_SIZE = "httpRequestBufferSize";
    static final int CONNECTION_TIMEOUT = 60000;
    static final int REQUEST_TIMEOUT = 60000;
    static final int IDLE_TIMEOUT = 10000;
    static final int REQUEST_BUFFER_SIZE = 8192;
    static final Pattern SOBJECT_NAME_PATTERN = Pattern.compile("^.*[\\?&]sObjectName=([^&,]+).*$");
    static final String APEX_CALL_PREFIX = OperationName.APEX_CALL.value() + "/";
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceComponent.class);
    @Metadata(description="All authentication configuration in one nested bean, all properties set there can be set directly on the component as well", label="common,security")
    private SalesforceLoginConfig loginConfig;
    @Metadata(description="URL of the Salesforce instance used after authentication, by default received from Salesforce on successful authentication", label="common,security")
    private String instanceUrl;
    @Metadata(description="URL of the Salesforce instance used for authentication, by default set to https://login.salesforce.com", label="common,security", defaultValue="https://login.salesforce.com", required=true)
    private String loginUrl;
    @Metadata(description="OAuth Consumer Key of the connected app configured in the Salesforce instance setup. Typically a connected app needs to be configured but one can be provided by installing a package.", label="common,security", required=true)
    private String clientId;
    @Metadata(description="OAuth Consumer Secret of the connected app configured in the Salesforce instance setup.", label="common,security", secret=true)
    private String clientSecret;
    @Metadata(description="Refresh token already obtained in the refresh token OAuth flow. One needs to setup a web application and configure a callback URL to receive the refresh token, or configure using the builtin callback at https://login.salesforce.com/services/oauth2/success or  https://test.salesforce.com/services/oauth2/success and then retrive the refresh_token from the URL at the end of the flow. Note that in development organizations Salesforce allows hosting the callback web  application at localhost.", label="common,security", secret=true)
    private String refreshToken;
    @Metadata(description="Username used in OAuth flow to gain access to access token. It's easy to get started with password OAuth flow, but in general one should avoid it as it is deemed less secure than other flows.", label="common,security")
    private String userName;
    @Metadata(description="Password used in OAuth flow to gain access to access token. It's easy to get started with password OAuth flow, but in general one should avoid it as it is deemed less secure than other flows. Make sure that you append security token to the end of the password if using one.", label="common,security", secret=true)
    private String password;
    @Metadata(description="KeyStore parameters to use in OAuth JWT flow. The KeyStore should contain only one entry with private key and certificate. Salesforce does not verify the certificate chain, so this can easily be a selfsigned certificate. Make sure that you upload the certificate to the corresponding connected app.", label="common,security", secret=true)
    private KeyStoreParameters keystore;
    @Metadata(description="Value to use for the Audience claim (aud) when using OAuth JWT flow. If not set, the login URL will be used, which is appropriate in most cases.", label="common,security")
    private String jwtAudience;
    @Metadata(description="Explicit authentication method to be used, one of USERNAME_PASSWORD, REFRESH_TOKEN or JWT. Salesforce component can auto-determine the authentication method to use from the properties set, set this  property to eliminate any ambiguity.", label="common,security", enums="USERNAME_PASSWORD,REFRESH_TOKEN,JWT")
    private AuthenticationType authenticationType;
    @Metadata(description="If set to true prevents the component from authenticating to Salesforce with the start of the component. You would generally set this to the (default) false and authenticate early and be immediately aware of any authentication issues.", defaultValue="false", label="common,security")
    private boolean lazyLogin;
    @Metadata(description="Global endpoint configuration - use to set values that are common to all endpoints", label="common,advanced")
    private SalesforceEndpointConfig config;
    @Metadata(description="Timeout used by the HttpClient when waiting for response from the Salesforce server.", label="common", defaultValue="10000")
    private long httpClientIdleTimeout = 10000L;
    @Metadata(description="Connection timeout used by the HttpClient when connecting to the Salesforce server.", label="common", defaultValue="60000")
    private long httpClientConnectionTimeout = 60000L;
    @Metadata(description="Timeout value for HTTP requests.", label="common", defaultValue="60000")
    private long httpRequestTimeout = 60000L;
    @Metadata(description="Max content length of an HTTP response.", label="common")
    private Integer httpMaxContentLength;
    @Metadata(description="HTTP request buffer size. May need to be increased for large SOQL queries.", label="common", defaultValue="8192")
    private Integer httpRequestBufferSize;
    @Metadata(description="Used to set any properties that can be configured on the underlying HTTP client. Have a look at properties of SalesforceHttpClient and the Jetty HttpClient for all available options.", label="common,advanced")
    private Map<String, Object> httpClientProperties;
    @Metadata(description="Size of the thread pool used to handle HTTP responses.", label="common,advanced", defaultValue="10")
    private int workerPoolSize = 10;
    @Metadata(description="Maximum size of the thread pool used to handle HTTP responses.", label="common,advanced", defaultValue="20")
    private int workerPoolMaxSize = 20;
    @Metadata(description="Used to set any properties that can be configured on the LongPollingTransport used by the BayeuxClient (CometD) used by the streaming api", label="common,advanced")
    private Map<String, Object> longPollingTransportProperties;
    @Metadata(description="SSL parameters to use, see SSLContextParameters class for all available options.", label="common,security")
    private SSLContextParameters sslContextParameters;
    @Metadata(description="Enable usage of global SSL context parameters", label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(description="Hostname of the HTTP proxy server to use.", label="common,proxy")
    private String httpProxyHost;
    @Metadata(description="Port number of the HTTP proxy server to use.", label="common,proxy")
    private Integer httpProxyPort;
    @Metadata(description="If set to true the configures the HTTP proxy to use as a SOCKS4 proxy.", defaultValue="false", label="common,proxy")
    private boolean httpProxySocks4;
    @Metadata(description="If set to false disables the use of TLS when accessing the HTTP proxy.", defaultValue="true", label="common,proxy,security")
    private boolean httpProxySecure = true;
    @Metadata(description="A list of addresses for which HTTP proxy server should be used.", label="common,proxy")
    private Set<String> httpProxyIncludedAddresses;
    @Metadata(description="A list of addresses for which HTTP proxy server should not be used.", label="common,proxy")
    private Set<String> httpProxyExcludedAddresses;
    @Metadata(description="Username to use to authenticate against the HTTP proxy server.", label="common,proxy,security")
    private String httpProxyUsername;
    @Metadata(description="Password to use to authenticate against the HTTP proxy server.", label="common,proxy,security", secret=true)
    private String httpProxyPassword;
    @Metadata(description="Used in authentication against the HTTP proxy server, needs to match the URI of the proxy server in order for the httpProxyUsername and httpProxyPassword to be used for authentication.", label="common,proxy,security")
    private String httpProxyAuthUri;
    @Metadata(description="Realm of the proxy server, used in preemptive Basic/Digest authentication methods against the HTTP proxy server.", label="common,proxy,security")
    private String httpProxyRealm;
    @Metadata(description="If set to true Digest authentication will be used when authenticating to the HTTP proxy, otherwise Basic authorization method will be used", defaultValue="false", label="common,proxy,security")
    private boolean httpProxyUseDigestAuth;
    @Metadata(description="In what packages are the generated DTO classes. Typically the classes would be generated using camel-salesforce-maven-plugin.  Set it if using the generated DTOs to gain the benefit of using short  SObject names in parameters/header values. Multiple packages can be separated by comma.", javaType="java.lang.String", label="common")
    private String packages;
    private SalesforceHttpClient httpClient;
    private SalesforceSession session;
    private Map<String, Class<?>> classMap;
    private SubscriptionHelper subscriptionHelper;

    public SalesforceComponent() {
        this(null);
    }

    public SalesforceComponent(CamelContext context) {
        super(context);
        this.registerExtension(SalesforceComponentVerifierExtension::new);
        this.registerExtension(SalesforceMetaDataExtension::new);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        OperationName operationName = null;
        String topicName = null;
        String apexUrl = null;
        LOG.debug("Creating endpoint for: {}", (Object)remaining);
        if (remaining.startsWith(APEX_CALL_PREFIX)) {
            apexUrl = remaining.substring(APEX_CALL_PREFIX.length());
            remaining = OperationName.APEX_CALL.value();
        } else if (remaining.startsWith(OperationName.SUBSCRIBE.value())) {
            String[] parts = remaining.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("topicName must be supplied for subscribe operation.");
            }
            remaining = parts[0];
            topicName = parts[1];
        }
        operationName = OperationName.fromValue(remaining);
        if (this.config == null) {
            this.config = new SalesforceEndpointConfig();
        }
        if (this.config.getHttpClient() == null) {
            this.config.setHttpClient(this.httpClient);
        }
        SalesforceEndpointConfig copy = this.config.copy();
        this.setProperties(copy, parameters);
        if (apexUrl != null) {
            copy.setApexUrl(apexUrl);
        }
        SalesforceEndpoint endpoint = new SalesforceEndpoint(uri, this, copy, operationName, topicName);
        this.setProperties((Endpoint)endpoint, parameters);
        if (operationName == OperationName.APEX_CALL && !parameters.isEmpty()) {
            HashMap<String, Object> queryParams = new HashMap<String, Object>(copy.getApexQueryParams());
            queryParams.putAll(parameters);
            parameters.clear();
            copy.setApexQueryParams(queryParams);
        }
        return endpoint;
    }

    private Map<String, Class<?>> parsePackages() {
        HashMap result = new HashMap();
        Set classes = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getPackageScanClassResolver().findImplementations(AbstractDTOBase.class, this.getPackagesAsArray());
        for (Class aClass : classes) {
            result.put(aClass.getSimpleName(), aClass);
        }
        return result;
    }

    public SalesforceHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.loginConfig == null) {
            this.loginConfig = new SalesforceLoginConfig();
            this.loginConfig.setInstanceUrl(this.instanceUrl);
            this.loginConfig.setClientId(this.clientId);
            this.loginConfig.setClientSecret(this.clientSecret);
            this.loginConfig.setKeystore(this.keystore);
            this.loginConfig.setJwtAudience(this.jwtAudience);
            this.loginConfig.setLazyLogin(this.lazyLogin);
            this.loginConfig.setLoginUrl(this.loginUrl);
            this.loginConfig.setPassword(this.password);
            this.loginConfig.setRefreshToken(this.refreshToken);
            this.loginConfig.setType(this.authenticationType);
            this.loginConfig.setUserName(this.userName);
            LOG.debug("Created login configuration: {}", (Object)this.loginConfig);
        } else {
            LOG.debug("Using shared login configuration: {}", (Object)this.loginConfig);
        }
        if (this.httpClient == null) {
            if (this.config != null && this.config.getHttpClient() != null) {
                this.httpClient = this.config.getHttpClient();
            } else {
                SSLContextParameters contextParameters = Optional.ofNullable(this.sslContextParameters).orElseGet(() -> Optional.ofNullable(this.retrieveGlobalSslContextParameters()).orElseGet(() -> new SSLContextParameters()));
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setSslContext(contextParameters.createSSLContext(this.getCamelContext()));
                this.httpClient = SalesforceComponent.createHttpClient((Object)this, sslContextFactory, this.getCamelContext(), this.workerPoolSize, this.workerPoolMaxSize);
            }
            if (this.config != null) {
                this.config.setHttpClient(this.httpClient);
            }
        }
        if (this.httpClientProperties == null) {
            this.httpClientProperties = new HashMap<String, Object>();
        }
        SalesforceComponent.defineComponentPropertiesIn(this.httpClientProperties, this);
        SalesforceComponent.setupHttpClient(this.httpClient, this.getCamelContext(), this.httpClientProperties);
        if (this.session == null) {
            this.session = new SalesforceSession(this.getCamelContext(), this.httpClient, this.httpClient.getTimeout(), this.loginConfig);
        }
        this.httpClient.setSession(this.session);
        this.httpClient.start();
        if (!this.loginConfig.isLazyLogin()) {
            ServiceHelper.startService((Object)((Object)this.session));
        }
        if (this.packages != null) {
            this.classMap = this.parsePackages();
            LOG.info("Found {} generated classes in packages: {}", (Object)this.classMap.size(), (Object)this.packages);
        } else {
            LOG.warn("Missing property packages, getSObject* operations will NOT work without property rawPayload=true");
            this.classMap = new HashMap(0);
        }
        if (this.subscriptionHelper != null) {
            ServiceHelper.startService((Object)((Object)this.subscriptionHelper));
        }
    }

    protected void doStop() throws Exception {
        if (this.classMap != null) {
            this.classMap.clear();
        }
        try {
            if (this.subscriptionHelper != null) {
                ServiceHelper.stopService((Object)((Object)this.subscriptionHelper));
                this.subscriptionHelper = null;
            }
            if (this.session != null && this.session.getAccessToken() != null) {
                ServiceHelper.stopService((Object)((Object)this.session));
            }
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.stop();
                if (this.config != null && this.config.getHttpClient() == null) {
                    this.httpClient.destroy();
                }
                this.httpClient = null;
            }
        }
    }

    public SubscriptionHelper getSubscriptionHelper() throws Exception {
        if (this.subscriptionHelper == null) {
            this.subscriptionHelper = new SubscriptionHelper(this);
        }
        return this.subscriptionHelper;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public SalesforceLoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(SalesforceLoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setKeystore(KeyStoreParameters keystore) {
        this.keystore = keystore;
    }

    public KeyStoreParameters getKeystore() {
        return this.keystore;
    }

    public String getJwtAudience() {
        return this.jwtAudience;
    }

    public void setJwtAudience(String jwtAudience) {
        this.jwtAudience = jwtAudience;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isLazyLogin() {
        return this.lazyLogin;
    }

    public void setLazyLogin(boolean lazyLogin) {
        this.lazyLogin = lazyLogin;
    }

    public SalesforceEndpointConfig getConfig() {
        return this.config;
    }

    public void setConfig(SalesforceEndpointConfig config) {
        this.config = config;
    }

    public Map<String, Object> getHttpClientProperties() {
        return this.httpClientProperties;
    }

    public void setHttpClientProperties(Map<String, Object> httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    public Map<String, Object> getLongPollingTransportProperties() {
        return this.longPollingTransportProperties;
    }

    public void setLongPollingTransportProperties(Map<String, Object> longPollingTransportProperties) {
        this.longPollingTransportProperties = longPollingTransportProperties;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public long getHttpClientIdleTimeout() {
        return this.httpClientIdleTimeout;
    }

    public void setHttpClientIdleTimeout(long httpClientIdleTimeout) {
        this.httpClientIdleTimeout = httpClientIdleTimeout;
    }

    public long getHttpClientConnectionTimeout() {
        return this.httpClientConnectionTimeout;
    }

    public void setHttpClientConnectionTimeout(long httpClientConnectionTimeout) {
        this.httpClientConnectionTimeout = httpClientConnectionTimeout;
    }

    public long getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public void setHttpRequestTimeout(long httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
    }

    public Integer getHttpMaxContentLength() {
        return this.httpMaxContentLength;
    }

    public void setHttpMaxContentLength(Integer httpMaxContentLength) {
        this.httpMaxContentLength = httpMaxContentLength;
    }

    public Integer getHttpRequestBufferSize() {
        return this.httpRequestBufferSize;
    }

    public void setHttpRequestBufferSize(Integer httpRequestBufferSize) {
        this.httpRequestBufferSize = httpRequestBufferSize;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public boolean isHttpProxySocks4() {
        return this.httpProxySocks4;
    }

    public void setHttpProxySocks4(boolean isHttpProxySocks4) {
        this.httpProxySocks4 = isHttpProxySocks4;
    }

    public boolean isHttpProxySecure() {
        return this.httpProxySecure;
    }

    public void setHttpProxySecure(boolean isHttpProxySecure) {
        this.httpProxySecure = isHttpProxySecure;
    }

    public Set<String> getHttpProxyIncludedAddresses() {
        return this.httpProxyIncludedAddresses;
    }

    public void setHttpProxyIncludedAddresses(Set<String> httpProxyIncludedAddresses) {
        this.httpProxyIncludedAddresses = httpProxyIncludedAddresses;
    }

    public Set<String> getHttpProxyExcludedAddresses() {
        return this.httpProxyExcludedAddresses;
    }

    public void setHttpProxyExcludedAddresses(Set<String> httpProxyExcludedAddresses) {
        this.httpProxyExcludedAddresses = httpProxyExcludedAddresses;
    }

    public String getHttpProxyAuthUri() {
        return this.httpProxyAuthUri;
    }

    public void setHttpProxyAuthUri(String httpProxyAuthUri) {
        this.httpProxyAuthUri = httpProxyAuthUri;
    }

    public String getHttpProxyRealm() {
        return this.httpProxyRealm;
    }

    public void setHttpProxyRealm(String httpProxyRealm) {
        this.httpProxyRealm = httpProxyRealm;
    }

    public boolean isHttpProxyUseDigestAuth() {
        return this.httpProxyUseDigestAuth;
    }

    public void setHttpProxyUseDigestAuth(boolean httpProxyUseDigestAuth) {
        this.httpProxyUseDigestAuth = httpProxyUseDigestAuth;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    public int getWorkerPoolMaxSize() {
        return this.workerPoolMaxSize;
    }

    public void setWorkerPoolMaxSize(int workerPoolMaxSize) {
        this.workerPoolMaxSize = workerPoolMaxSize;
    }

    public String getPackages() {
        return this.packages;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }

    public String[] getPackagesAsArray() {
        if (this.packages != null) {
            return this.packages.split(",");
        }
        return null;
    }

    public SalesforceSession getSession() {
        return this.session;
    }

    public Map<String, Class<?>> getClassMap() {
        return this.classMap;
    }

    public RestClient createRestClientFor(SalesforceEndpoint endpoint) throws SalesforceException {
        SalesforceEndpointConfig endpointConfig = endpoint.getConfiguration();
        return this.createRestClientFor(endpointConfig);
    }

    RestClient createRestClientFor(SalesforceEndpointConfig endpointConfig) throws SalesforceException {
        String version = endpointConfig.getApiVersion();
        return new DefaultRestClient(this.httpClient, version, this.session, this.loginConfig);
    }

    RestClient createRestClient(Map<String, Object> properties) throws Exception {
        SalesforceEndpointConfig modifiedConfig = Optional.ofNullable(this.config).map(SalesforceEndpointConfig::copy).orElseGet(() -> new SalesforceEndpointConfig());
        CamelContext camelContext = this.getCamelContext();
        PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)modifiedConfig, properties);
        return this.createRestClientFor(modifiedConfig);
    }

    static RestClient createRestClient(CamelContext camelContext, Map<String, Object> properties) throws Exception {
        SalesforceEndpointConfig config = new SalesforceEndpointConfig();
        PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)config, new HashMap<String, Object>(properties));
        SalesforceLoginConfig loginConfig = new SalesforceLoginConfig();
        PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)loginConfig, new HashMap<String, Object>(properties));
        SSLContextParameters sslContextParameters = Optional.ofNullable(camelContext.getSSLContextParameters()).orElseGet(() -> new SSLContextParameters());
        PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)sslContextParameters, new HashMap<String, Object>(properties));
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setSslContext(sslContextParameters.createSSLContext(camelContext));
        SalesforceHttpClient httpClient = SalesforceComponent.createHttpClient("SalesforceComponent", sslContextFactory, camelContext, 10, 20);
        SalesforceComponent.setupHttpClient(httpClient, camelContext, properties);
        SalesforceSession session = new SalesforceSession(camelContext, httpClient, httpClient.getTimeout(), loginConfig);
        httpClient.setSession(session);
        return new DefaultRestClient(httpClient, config.getApiVersion(), session, loginConfig);
    }

    public RawClient createRawClientFor(SalesforceEndpoint endpoint) throws SalesforceException {
        return new DefaultRawClient(this.httpClient, "", this.session, this.loginConfig);
    }

    static SalesforceHttpClient createHttpClient(Object source, SslContextFactory sslContextFactory, CamelContext context, int workerPoolSize, int workerPoolMaxSize) {
        SecurityUtils.adaptToIBMCipherNames(sslContextFactory);
        SalesforceHttpClient httpClient = new SalesforceHttpClient(context, context.getExecutorServiceManager().newThreadPool(source, "SalesforceHttpClient", workerPoolSize, workerPoolMaxSize), sslContextFactory);
        httpClient.setConnectTimeout(60000L);
        httpClient.setIdleTimeout(10000L);
        return httpClient;
    }

    static SalesforceHttpClient setupHttpClient(SalesforceHttpClient httpClient, CamelContext camelContext, Map<String, Object> httpClientProperties) throws Exception {
        if (httpClientProperties == null || httpClientProperties.isEmpty()) {
            return httpClient;
        }
        TypeConverter typeConverter = camelContext.getTypeConverter();
        PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)((Object)httpClient), new HashMap<String, Object>(httpClientProperties));
        Long httpConnectionTimeout = (Long)typeConverter.convertTo(Long.class, httpClientProperties.get(HTTP_CONNECTION_TIMEOUT));
        Long httpIdleTimeout = (Long)typeConverter.convertTo(Long.class, httpClientProperties.get(HTTP_IDLE_TIMEOUT));
        Long httpRequestTimeout = (Long)typeConverter.convertTo(Long.class, httpClientProperties.get(HTTP_REQUEST_TIMEOUT));
        Integer maxContentLength = (Integer)typeConverter.convertTo(Integer.class, httpClientProperties.get(HTTP_MAX_CONTENT_LENGTH));
        Integer requestBufferSize = (Integer)typeConverter.convertTo(Integer.class, httpClientProperties.get(HTTP_REQUEST_BUFFER_SIZE));
        if (requestBufferSize == null) {
            requestBufferSize = 8192;
        }
        String httpProxyHost = (String)typeConverter.convertTo(String.class, httpClientProperties.get(HTTP_PROXY_HOST));
        Integer httpProxyPort = (Integer)typeConverter.convertTo(Integer.class, httpClientProperties.get(HTTP_PROXY_PORT));
        boolean isHttpProxySocks4 = (Boolean)typeConverter.convertTo(Boolean.TYPE, httpClientProperties.get(HTTP_PROXY_IS_SOCKS4));
        boolean isHttpProxySecure = (Boolean)typeConverter.convertTo(Boolean.TYPE, httpClientProperties.get(HTTP_PROXY_IS_SECURE));
        Set httpProxyIncludedAddresses = (Set)httpClientProperties.get(HTTP_PROXY_INCLUDE);
        Set httpProxyExcludedAddresses = (Set)httpClientProperties.get(HTTP_PROXY_EXCLUDE);
        String httpProxyUsername = (String)typeConverter.convertTo(String.class, httpClientProperties.get(HTTP_PROXY_USERNAME));
        String httpProxyPassword = (String)typeConverter.convertTo(String.class, httpClientProperties.get(HTTP_PROXY_PASSWORD));
        String httpProxyAuthUri = (String)typeConverter.convertTo(String.class, httpClientProperties.get(HTTP_PROXY_AUTH_URI));
        String httpProxyRealm = (String)typeConverter.convertTo(String.class, httpClientProperties.get(HTTP_PROXY_REALM));
        boolean httpProxyUseDigestAuth = (Boolean)typeConverter.convertTo(Boolean.TYPE, httpClientProperties.get(HTTP_PROXY_USE_DIGEST_AUTH));
        if (httpIdleTimeout != null) {
            httpClient.setIdleTimeout(httpIdleTimeout);
        }
        if (httpConnectionTimeout != null) {
            httpClient.setConnectTimeout(httpConnectionTimeout);
        }
        if (maxContentLength != null) {
            httpClient.setMaxContentLength(maxContentLength);
        }
        if (httpRequestTimeout != null) {
            httpClient.setTimeout(httpRequestTimeout);
        }
        httpClient.setRequestBufferSize(requestBufferSize);
        if (httpProxyHost != null && httpProxyPort != null) {
            Origin.Address proxyAddress = new Origin.Address(httpProxyHost, httpProxyPort.intValue());
            Object proxy = isHttpProxySocks4 ? new Socks4Proxy(proxyAddress, isHttpProxySecure) : new HttpProxy(proxyAddress, isHttpProxySecure);
            if (httpProxyIncludedAddresses != null && !httpProxyIncludedAddresses.isEmpty()) {
                proxy.getIncludedAddresses().addAll(httpProxyIncludedAddresses);
            }
            if (httpProxyExcludedAddresses != null && !httpProxyExcludedAddresses.isEmpty()) {
                proxy.getExcludedAddresses().addAll(httpProxyExcludedAddresses);
            }
            httpClient.getProxyConfiguration().getProxies().add(proxy);
        }
        if (httpProxyUsername != null && httpProxyPassword != null) {
            StringHelper.notEmpty((String)httpProxyAuthUri, (String)HTTP_PROXY_AUTH_URI);
            StringHelper.notEmpty((String)httpProxyRealm, (String)HTTP_PROXY_REALM);
            Object authentication = httpProxyUseDigestAuth ? new DigestAuthentication(new URI(httpProxyAuthUri), httpProxyRealm, httpProxyUsername, httpProxyPassword) : new BasicAuthentication(new URI(httpProxyAuthUri), httpProxyRealm, httpProxyUsername, httpProxyPassword);
            httpClient.getAuthenticationStore().addAuthentication((Authentication)authentication);
        }
        return httpClient;
    }

    private static void defineComponentPropertiesIn(Map<String, Object> httpClientProperties, SalesforceComponent salesforce) {
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_IDLE_TIMEOUT, salesforce::getHttpClientIdleTimeout);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_CONNECTION_TIMEOUT, salesforce::getHttpClientConnectionTimeout);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_REQUEST_TIMEOUT, salesforce::getHttpRequestTimeout);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_HOST, salesforce::getHttpProxyHost);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_PORT, salesforce::getHttpProxyPort);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_INCLUDE, salesforce::getHttpProxyIncludedAddresses);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_EXCLUDE, salesforce::getHttpProxyExcludedAddresses);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_USERNAME, salesforce::getHttpProxyUsername);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_PASSWORD, salesforce::getHttpProxyPassword);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_REALM, salesforce::getHttpProxyRealm);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_AUTH_URI, salesforce::getHttpProxyAuthUri);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_MAX_CONTENT_LENGTH, salesforce::getHttpMaxContentLength);
        SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_REQUEST_BUFFER_SIZE, salesforce::getHttpRequestBufferSize);
        if (ObjectHelper.isNotEmpty((String)salesforce.getHttpProxyHost())) {
            SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_IS_SOCKS4, salesforce::isHttpProxySocks4);
            SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_IS_SECURE, salesforce::isHttpProxySecure);
            SalesforceComponent.putValueIfGivenTo(httpClientProperties, HTTP_PROXY_USE_DIGEST_AUTH, salesforce::isHttpProxyUseDigestAuth);
        }
    }

    private static void putValueIfGivenTo(Map<String, Object> properties, String key, Supplier<Object> valueSupplier) {
        Object value = valueSupplier.get();
        if (ObjectHelper.isNotEmpty((Object)value)) {
            properties.putIfAbsent(key, value);
        }
    }
}

