/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.ZonedDateTime;
import org.apache.camel.component.salesforce.api.utils.DateTimeHandling;

final class ZonedDateTimeConverter
implements SingleValueConverter {
    static final SingleValueConverter INSTANCE = new ZonedDateTimeConverter();

    private ZonedDateTimeConverter() {
    }

    public boolean canConvert(Class type) {
        return ZonedDateTime.class.equals((Object)type);
    }

    public Object fromString(String value) {
        return ZonedDateTime.parse(value, DateTimeHandling.ISO_OFFSET_DATE_TIME);
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return DateTimeHandling.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
    }
}

