/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.routebox.RouteboxComponent;
import org.apache.camel.component.routebox.strategy.RouteboxDispatchStrategy;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class RouteboxConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RouteboxConfiguration.class);
    private URI uri;
    private String authority;
    @UriPath
    @Metadata(required="true")
    private String routeboxName;
    @UriParam
    private RouteboxDispatchStrategy dispatchStrategy;
    @UriParam
    private Map<String, String> dispatchMap;
    @UriParam(defaultValue="true")
    private boolean forkContext = true;
    @UriParam(label="producer", defaultValue="20000")
    private long connectionTimeout = 20000L;
    @UriParam(label="consumer", defaultValue="1000")
    private long pollInterval = 1000L;
    @UriParam(defaultValue="direct", enums="direct,seda")
    private String innerProtocol = "direct";
    @UriParam(label="consumer", defaultValue="20")
    private int threads = 20;
    @UriParam
    private int queueSize;
    @UriParam(label="producer", defaultValue="true")
    private boolean sendToConsumer = true;
    @UriParam(label="advanced")
    private CamelContext innerContext;
    @UriParam(label="advanced")
    private Registry innerRegistry;
    @UriParam(label="advanced")
    private ProducerTemplate innerProducerTemplate;
    @UriParam(label="advanced", javaType="java.lang.String")
    private List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();

    public RouteboxConfiguration() {
    }

    public RouteboxConfiguration(URI uri) {
        this();
        this.uri = uri;
    }

    public void parseURI(URI uri, Map<String, Object> parameters, RouteboxComponent component) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("routebox")) {
            throw new IllegalArgumentException("Unrecognized protocol: " + protocol + " for uri: " + uri);
        }
        this.setUri(uri);
        this.setAuthority(uri.getAuthority());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Authority: {}", (Object)uri.getAuthority());
        }
        this.setRouteboxName(this.getAuthority());
        if (parameters.containsKey("threads")) {
            this.setThreads(Integer.valueOf((String)parameters.get("threads")));
        }
        if (parameters.containsKey("forkContext") && !Boolean.valueOf((String)parameters.get("forkContext")).booleanValue()) {
            this.setForkContext(false);
        }
        if (parameters.containsKey("innerProtocol")) {
            this.setInnerProtocol((String)parameters.get("innerProtocol"));
            if (!this.innerProtocol.equalsIgnoreCase("seda") && !this.innerProtocol.equalsIgnoreCase("direct")) {
                throw new IllegalArgumentException("Unrecognized inner protocol: " + this.innerProtocol + " for uri: " + uri);
            }
        } else {
            this.setInnerProtocol("direct");
        }
        if (parameters.containsKey("sendToConsumer") && !Boolean.valueOf((String)parameters.get("sendToConsumer")).booleanValue()) {
            this.setSendToConsumer(false);
        }
        if (parameters.containsKey("connectionTimeout")) {
            this.setConnectionTimeout(Long.parseLong((String)parameters.get("connectionTimeout")));
        }
        if (parameters.containsKey("pollInterval")) {
            this.setConnectionTimeout(Long.parseLong((String)parameters.get("pollInterval")));
        }
        if (parameters.containsKey("routeBuilders")) {
            this.routeBuilders = (List)component.resolveAndRemoveReferenceParameter(parameters, "routeBuilders", List.class);
        }
        if (parameters.containsKey("innerRegistry")) {
            this.innerRegistry = (Registry)component.resolveAndRemoveReferenceParameter(parameters, "innerRegistry", Registry.class);
        }
        this.innerContext = this.isForkContext() ? (this.innerRegistry != null ? (CamelContext)component.resolveAndRemoveReferenceParameter(parameters, "innerContext", CamelContext.class, new DefaultCamelContext(this.innerRegistry)) : (CamelContext)component.resolveAndRemoveReferenceParameter(parameters, "innerContext", CamelContext.class, new DefaultCamelContext())) : component.getCamelContext();
        this.innerProducerTemplate = this.innerContext.createProducerTemplate();
        this.setQueueSize((Integer)component.getAndRemoveParameter(parameters, "size", Integer.class, 0));
        this.dispatchStrategy = (RouteboxDispatchStrategy)component.resolveAndRemoveReferenceParameter(parameters, "dispatchStrategy", RouteboxDispatchStrategy.class, null);
        this.dispatchMap = (Map)component.resolveAndRemoveReferenceParameter(parameters, "dispatchMap", HashMap.class, new HashMap());
        if (this.dispatchStrategy == null && this.dispatchMap == null) {
            LOG.warn("No Routebox Dispatch Map or Strategy has been set. Routebox may not have more than one inner route.");
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public CamelContext getInnerContext() {
        return this.innerContext;
    }

    public void setInnerContext(CamelContext innerContext) {
        this.innerContext = innerContext;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setForkContext(boolean forkContext) {
        this.forkContext = forkContext;
    }

    public boolean isForkContext() {
        return this.forkContext;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setRouteboxName(String routeboxName) {
        this.routeboxName = routeboxName;
    }

    public String getRouteboxName() {
        return this.routeboxName;
    }

    public void setDispatchStrategy(RouteboxDispatchStrategy dispatchStrategy) {
        this.dispatchStrategy = dispatchStrategy;
    }

    public RouteboxDispatchStrategy getDispatchStrategy() {
        return this.dispatchStrategy;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setInnerProducerTemplate(ProducerTemplate innerProducerTemplate) {
        this.innerProducerTemplate = innerProducerTemplate;
    }

    public ProducerTemplate getInnerProducerTemplate() {
        return this.innerProducerTemplate;
    }

    public void setInnerProtocol(String innerProtocol) {
        this.innerProtocol = innerProtocol;
    }

    public String getInnerProtocol() {
        return this.innerProtocol;
    }

    public void setInnerRegistry(Registry innerRegistry) {
        this.innerRegistry = innerRegistry;
    }

    public Registry getInnerRegistry() {
        return this.innerRegistry;
    }

    public void setSendToConsumer(boolean sendToConsumer) {
        this.sendToConsumer = sendToConsumer;
    }

    public boolean isSendToConsumer() {
        return this.sendToConsumer;
    }

    public void setDispatchMap(Map<String, String> dispatchMap) {
        this.dispatchMap = dispatchMap;
    }

    public Map<String, String> getDispatchMap() {
        return this.dispatchMap;
    }
}

