/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.parser.helper.XmlLineNumberParser;
import org.apache.camel.parser.model.CoverageData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RouteCoverageHelper {
    private RouteCoverageHelper() {
    }

    public static List<CoverageData> parseDumpRouteCoverageByRouteId(String directory, String routeId) throws Exception {
        ArrayList<CoverageData> answer = new ArrayList<CoverageData>();
        if (routeId == null) {
            return answer;
        }
        File[] files = new File(directory).listFiles(f -> f.getName().endsWith(".xml"));
        if (files == null) {
            return answer;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog(true);
        for (File file : files) {
            try (FileInputStream fis = new FileInputStream(file);){
                Document dom = XmlLineNumberParser.parseXml(fis);
                NodeList routes = dom.getElementsByTagName("route");
                for (int i = 0; i < routes.getLength(); ++i) {
                    String id;
                    Node route = routes.item(i);
                    Node n = route.getAttributes().getNamedItem("id");
                    String string = id = n != null ? n.getNodeValue() : null;
                    if (!routeId.equals(id)) continue;
                    AtomicInteger counter = new AtomicInteger();
                    RouteCoverageHelper.parseRouteData((CamelCatalog)catalog, route, answer, counter);
                }
            }
        }
        return answer;
    }

    public static Map<String, List<CoverageData>> parseDumpRouteCoverageByClassAndTestMethod(String directory) throws Exception {
        LinkedHashMap<String, List<CoverageData>> answer = new LinkedHashMap<String, List<CoverageData>>();
        File[] files = new File(directory).listFiles(f -> f.getName().endsWith(".xml"));
        if (files == null) {
            return answer;
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog(true);
        for (File file : files) {
            try (FileInputStream fis = new FileInputStream(file);){
                Document dom = XmlLineNumberParser.parseXml(fis);
                NodeList routes = dom.getElementsByTagName("route");
                for (int i = 0; i < routes.getLength(); ++i) {
                    Node route = routes.item(i);
                    AtomicInteger counter = new AtomicInteger();
                    ArrayList<CoverageData> data = new ArrayList<CoverageData>();
                    RouteCoverageHelper.parseRouteData((CamelCatalog)catalog, route, data, counter);
                    String key = file.getName();
                    key = key.substring(0, key.length() - 4);
                    List existing = (List)answer.get(key);
                    if (existing != null) {
                        existing.addAll(data);
                        continue;
                    }
                    answer.put(key, data);
                }
            }
        }
        return answer;
    }

    private static void parseRouteData(CamelCatalog catalog, Node node, List<CoverageData> data, AtomicInteger counter) {
        NodeList children;
        boolean skip;
        String key = node.getNodeName();
        boolean valid = catalog.findModelNames().contains(key);
        if (!valid) {
            return;
        }
        boolean bl = skip = "onException".equals(key) || "onCompletion".equals(key) || "intercept".equals(key) || "interceptFrom".equals(key) || "interceptSendToEndpoint".equals(key);
        if (skip) {
            return;
        }
        if (!("route".equals(key) || "policy".equals(key) || "transacted".equals(key))) {
            CoverageData holder;
            int count = 0;
            Node total = node.getAttributes().getNamedItem("exchangesTotal");
            if (total != null) {
                count = Integer.parseInt(total.getNodeValue());
            }
            CoverageData coverageData = holder = data.size() > counter.get() ? data.get(counter.get()) : null;
            if (holder != null && holder.getNode().equals(key)) {
                count += holder.getCount();
            }
            if (holder == null) {
                data.add(counter.get(), new CoverageData(key, count));
            } else {
                data.set(counter.get(), new CoverageData(key, count));
            }
            counter.incrementAndGet();
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                RouteCoverageHelper.parseRouteData(catalog, child, data, counter);
            }
        }
    }
}

