/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.parser.helper.CamelJavaParserHelper;
import org.apache.camel.parser.helper.ParserCommon;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CamelNodeDetailsFactory;
import org.apache.camel.tooling.model.JsonMapper;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.InfixExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TextBlock;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class CamelJavaTreeParserHelper {
    private final CamelCatalog camelCatalog = new DefaultCamelCatalog(true);

    public List<CamelNodeDetails> parseCamelRouteTree(JavaClassSource clazz, String fullyQualifiedFileName, MethodSource<JavaClassSource> configureMethod) {
        MethodDeclaration md;
        Block block;
        CamelNodeDetailsFactory nodeFactory = CamelNodeDetailsFactory.newInstance();
        CamelNodeDetails route = nodeFactory.newNode(null, "route");
        if (configureMethod != null && (block = (md = (MethodDeclaration)configureMethod.getInternal()).getBody()) != null) {
            for (Object statement : md.getBody().statements()) {
                ExpressionStatement es;
                Expression exp;
                boolean valid;
                if (!(statement instanceof ExpressionStatement) || !(valid = this.isFromCamelRoute(exp = (es = (ExpressionStatement)statement).getExpression()))) continue;
                this.parseExpression(nodeFactory, fullyQualifiedFileName, clazz, configureMethod, block, exp, route);
            }
        }
        ArrayList<CamelNodeDetails> answer = new ArrayList<CamelNodeDetails>();
        if (route.getOutputs() == null || route.getOutputs().isEmpty()) {
            return answer;
        }
        nodeFactory = CamelNodeDetailsFactory.newInstance();
        CamelNodeDetails parent = route.getOutputs().get(0);
        for (int i = 0; i < route.getOutputs().size(); ++i) {
            CamelNodeDetails output;
            CamelNodeDetails node = route.getOutputs().get(i);
            String name = node.getName();
            if ("from".equals(name)) {
                CamelNodeDetails from = nodeFactory.copyNode(null, "from", node);
                from.setFileName(fullyQualifiedFileName);
                answer.add(from);
                parent = from;
                continue;
            }
            if ("routeId".equals(name)) {
                parent.setRouteId(node.getRouteId());
                continue;
            }
            if ("end".equals(name) || "endParent".equals(name) || "endRest".equals(name) || "endDoTry".equals(name)) {
                if (parent.getParent() == null) continue;
                parent = parent.getParent();
                continue;
            }
            if ("endChoice".equals(name)) {
                while (!"from".equals(parent.getName()) && !"choice".equals(parent.getName()) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                continue;
            }
            if ("choice".equals(name)) {
                CamelNodeDetails output2 = nodeFactory.copyNode(parent, name, node);
                parent.addOutput(output2);
                parent = output2;
                continue;
            }
            if ("when".equals(name) || "otherwise".equals(name)) {
                while (!"from".equals(parent.getName()) && !"choice".equals(parent.getName()) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                continue;
            }
            boolean hasOutput = this.hasOutput(name);
            if (hasOutput) {
                output = nodeFactory.copyNode(parent, name, node);
                parent.addOutput(output);
                parent = output;
                continue;
            }
            output = nodeFactory.copyNode(parent, name, node);
            parent.addOutput(output);
        }
        return answer;
    }

    private boolean isFromCamelRoute(Expression exp) {
        Expression parent;
        String rootMethodName = null;
        Expression sub = exp;
        while (sub instanceof MethodInvocation && (!((sub = ((MethodInvocation)sub).getExpression()) instanceof MethodInvocation) || (parent = ((MethodInvocation)sub).getExpression()) != null)) {
        }
        if (sub instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)sub;
            rootMethodName = methodInvocation.getName().getIdentifier();
        } else if (sub instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)sub;
            rootMethodName = simpleName.getIdentifier();
        } else if (sub == null && exp instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)exp;
            rootMethodName = methodInvocation.getName().getIdentifier();
        }
        return "from".equals(rootMethodName) || "route".equals(rootMethodName);
    }

    private boolean hasOutput(String name) {
        String json = this.camelCatalog.modelJSonSchema(name);
        return JsonMapper.generateEipModel((String)json).isOutput();
    }

    private boolean hasInput(String name) {
        String json = this.camelCatalog.modelJSonSchema(name);
        return JsonMapper.generateEipModel((String)json).isInput();
    }

    private static CamelNodeDetails grandParent(CamelNodeDetails node, String parentName) {
        if (node == null) {
            return null;
        }
        if (parentName.equals(node.getName())) {
            return node;
        }
        return CamelJavaTreeParserHelper.grandParent(node.getParent(), parentName);
    }

    private void parseExpression(CamelNodeDetailsFactory nodeFactory, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, Expression exp, CamelNodeDetails node) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            node = this.doParseCamelModels(nodeFactory, fullyQualifiedFileName, clazz, configureMethod, block, mi, node);
            exp = mi.getExpression();
            this.parseExpression(nodeFactory, fullyQualifiedFileName, clazz, configureMethod, block, exp, node);
        }
    }

    private CamelNodeDetails doParseCamelModels(CamelNodeDetailsFactory nodeFactory, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, MethodInvocation mi, CamelNodeDetails node) {
        boolean isEip;
        String name = mi.getName().getIdentifier();
        boolean isEnd = "end".equals(name) || "endChoice".equals(name) || "endDoTry".equals(name) || "endParent".equals(name) || "endRest".equals(name);
        boolean isRoute = "route".equals(name) || "from".equals(name) || "routeId".equals(name);
        boolean bl = isEip = this.camelCatalog.findModelNames().contains(name) && (this.hasInput(name) || this.hasOutput(name));
        if (isEnd || isRoute || isEip) {
            Expression exp;
            String routeId;
            List args;
            CamelNodeDetails newNode = nodeFactory.newNode(node, name);
            int pos = mi.getName().getStartPosition();
            int line = ParserCommon.findLineNumber(fullyQualifiedFileName, pos);
            if (line > -1) {
                newNode.setLineNumber(Integer.toString(line));
            }
            if ((line = ParserCommon.findLineNumber(fullyQualifiedFileName, pos = mi.getName().getStartPosition() + mi.getName().getLength())) > -1) {
                newNode.setLineNumberEnd(Integer.toString(line));
            }
            newNode.setFileName(fullyQualifiedFileName);
            newNode.setClassName(clazz.getQualifiedName());
            newNode.setMethodName(configureMethod.getName());
            if ("routeId".equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && (routeId = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, exp = (Expression)args.get(0))) != null) {
                newNode.setRouteId(routeId);
            }
            node.addPreliminaryOutput(newNode);
            return node;
        }
        return node;
    }

    @Deprecated
    public static String getLiteralValue(JavaClassSource clazz, Block block, Expression expression) {
        if (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).booleanValue());
        }
        if (expression instanceof NumberLiteral) {
            return ((NumberLiteral)expression).getToken();
        }
        if (expression instanceof TextBlock) {
            TextBlock textBlock = (TextBlock)expression;
            return textBlock.getLiteralValue();
        }
        if (expression instanceof MethodInvocation) {
            String name = ((MethodInvocation)expression).getName().getIdentifier();
            return "{{" + name + "}}";
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)expression;
            String name = qn.getFullyQualifiedName();
            return "{{" + name + "}}";
        }
        if (expression instanceof SimpleName) {
            FieldSource<JavaClassSource> field = ParserCommon.getField(clazz, block, (SimpleName)expression);
            if (field != null) {
                if (field.getAnnotations() != null) {
                    for (Annotation ann : field.getAnnotations()) {
                        boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                        if (!valid) continue;
                        Expression exp = (Expression)ann.getInternal();
                        if (exp instanceof SingleMemberAnnotation) {
                            exp = ((SingleMemberAnnotation)exp).getValue();
                        } else if (exp instanceof NormalAnnotation) {
                            List values = ((NormalAnnotation)exp).values();
                            for (Object value : values) {
                                MemberValuePair pair = (MemberValuePair)value;
                                if (!"uri".equals(pair.getName().toString())) continue;
                                exp = pair.getValue();
                                break;
                            }
                        }
                        if (exp == null) continue;
                        return CamelJavaTreeParserHelper.getLiteralValue(clazz, block, exp);
                    }
                }
                return CamelJavaParserHelper.endpointTypeCheck(clazz, block, field);
            }
            String fieldName = ((SimpleName)expression).getIdentifier();
            return "{{" + fieldName + "}}";
        }
        if (expression instanceof InfixExpression) {
            InfixExpression ie = (InfixExpression)expression;
            return CamelJavaTreeParserHelper.getValueFromExpression(clazz, block, ie);
        }
        return null;
    }

    private static String getValueFromExpression(JavaClassSource clazz, Block block, InfixExpression ie) {
        Object answer = null;
        if (InfixExpression.Operator.PLUS.equals(ie.getOperator())) {
            List extended;
            boolean numeric;
            String val1 = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, ie.getLeftOperand());
            String val2 = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, ie.getRightOperand());
            boolean bl = numeric = ParserCommon.isNumericOperator(clazz, block, ie.getLeftOperand()) && ParserCommon.isNumericOperator(clazz, block, ie.getRightOperand());
            if (numeric) {
                long num1 = val1 != null ? Long.parseLong(val1) : 0L;
                long num2 = val2 != null ? Long.parseLong(val2) : 0L;
                answer = Long.toString(num1 + num2);
            } else {
                answer = (val1 != null ? val1 : "") + (val2 != null ? val2 : "");
            }
            if (!((String)answer).isEmpty() && (extended = ie.extendedOperands()) != null) {
                StringBuilder answerBuilder = new StringBuilder((String)answer);
                for (Object ext : extended) {
                    String val3 = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, (Expression)ext);
                    if (numeric) {
                        long num3 = val3 != null ? Long.parseLong(val3) : 0L;
                        long num = Long.parseLong(answerBuilder.toString());
                        answerBuilder = new StringBuilder(Long.toString(num + num3));
                        continue;
                    }
                    answerBuilder.append(val3 != null ? val3 : "");
                }
                answer = answerBuilder.toString();
            }
        }
        return answer;
    }
}

