/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CamelNodeDetailsFactory;
import org.apache.camel.parser.roaster.StatementFieldSource;
import org.apache.camel.tooling.model.JsonMapper;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.InfixExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class CamelJavaTreeParserHelper {
    private final CamelCatalog camelCatalog = new DefaultCamelCatalog(true);

    public List<CamelNodeDetails> parseCamelRouteTree(JavaClassSource clazz, String fullyQualifiedFileName, MethodSource<JavaClassSource> configureMethod) {
        MethodDeclaration md;
        Block block;
        CamelNodeDetailsFactory nodeFactory = CamelNodeDetailsFactory.newInstance();
        CamelNodeDetails route = nodeFactory.newNode(null, "route");
        if (configureMethod != null && (block = (md = (MethodDeclaration)configureMethod.getInternal()).getBody()) != null) {
            for (Object statement : md.getBody().statements()) {
                ExpressionStatement es;
                Expression exp;
                boolean valid;
                if (!(statement instanceof ExpressionStatement) || !(valid = this.isFromCamelRoute(exp = (es = (ExpressionStatement)statement).getExpression()))) continue;
                this.parseExpression(nodeFactory, fullyQualifiedFileName, clazz, configureMethod, block, exp, route);
            }
        }
        ArrayList<CamelNodeDetails> answer = new ArrayList<CamelNodeDetails>();
        if (route.getOutputs() == null || route.getOutputs().isEmpty()) {
            return answer;
        }
        nodeFactory = CamelNodeDetailsFactory.newInstance();
        CamelNodeDetails parent = route.getOutputs().get(0);
        for (int i = 0; i < route.getOutputs().size(); ++i) {
            CamelNodeDetails output;
            CamelNodeDetails node = route.getOutputs().get(i);
            String name = node.getName();
            if ("from".equals(name)) {
                CamelNodeDetails from = nodeFactory.copyNode(null, "from", node);
                from.setFileName(fullyQualifiedFileName);
                answer.add(from);
                parent = from;
                continue;
            }
            if ("routeId".equals(name)) {
                parent.setRouteId(node.getRouteId());
                continue;
            }
            if ("end".equals(name) || "endParent".equals(name) || "endRest".equals(name) || "endDoTry".equals(name)) {
                if (parent.getParent() == null) continue;
                parent = parent.getParent();
                continue;
            }
            if ("endChoice".equals(name)) {
                while (!"from".equals(parent.getName()) && !"choice".equals(parent.getName()) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                continue;
            }
            if ("choice".equals(name)) {
                CamelNodeDetails output2 = nodeFactory.copyNode(parent, name, node);
                parent.addOutput(output2);
                parent = output2;
                continue;
            }
            if ("when".equals(name) || "otherwise".equals(name)) {
                while (!"from".equals(parent.getName()) && !"choice".equals(parent.getName()) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                continue;
            }
            boolean hasOutput = this.hasOutput(name);
            if (hasOutput) {
                output = nodeFactory.copyNode(parent, name, node);
                parent.addOutput(output);
                parent = output;
                continue;
            }
            output = nodeFactory.copyNode(parent, name, node);
            parent.addOutput(output);
        }
        return answer;
    }

    private boolean isFromCamelRoute(Expression exp) {
        Expression parent;
        String rootMethodName = null;
        Expression sub = exp;
        while (sub instanceof MethodInvocation && (!((sub = ((MethodInvocation)sub).getExpression()) instanceof MethodInvocation) || (parent = ((MethodInvocation)sub).getExpression()) != null)) {
        }
        if (sub instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)sub;
            rootMethodName = methodInvocation.getName().getIdentifier();
        } else if (sub instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)sub;
            rootMethodName = simpleName.getIdentifier();
        } else if (sub == null && exp instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)exp;
            rootMethodName = methodInvocation.getName().getIdentifier();
        }
        return "from".equals(rootMethodName) || "route".equals(rootMethodName);
    }

    private boolean hasOutput(String name) {
        String json = this.camelCatalog.modelJSonSchema(name);
        return JsonMapper.generateEipModel((String)json).isOutput();
    }

    private boolean hasInput(String name) {
        String json = this.camelCatalog.modelJSonSchema(name);
        return JsonMapper.generateEipModel((String)json).isInput();
    }

    private static CamelNodeDetails grandParent(CamelNodeDetails node, String parentName) {
        if (node == null) {
            return null;
        }
        if (parentName.equals(node.getName())) {
            return node;
        }
        return CamelJavaTreeParserHelper.grandParent(node.getParent(), parentName);
    }

    private void parseExpression(CamelNodeDetailsFactory nodeFactory, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, Expression exp, CamelNodeDetails node) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            node = this.doParseCamelModels(nodeFactory, fullyQualifiedFileName, clazz, configureMethod, block, mi, node);
            exp = mi.getExpression();
            this.parseExpression(nodeFactory, fullyQualifiedFileName, clazz, configureMethod, block, exp, node);
        }
    }

    private CamelNodeDetails doParseCamelModels(CamelNodeDetailsFactory nodeFactory, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, MethodInvocation mi, CamelNodeDetails node) {
        boolean isEip;
        String name = mi.getName().getIdentifier();
        boolean isEnd = "end".equals(name) || "endChoice".equals(name) || "endDoTry".equals(name) || "endParent".equals(name) || "endRest".equals(name);
        boolean isRoute = "route".equals(name) || "from".equals(name) || "routeId".equals(name);
        boolean bl = isEip = this.camelCatalog.findModelNames().contains(name) && (this.hasInput(name) || this.hasOutput(name));
        if (isEnd || isRoute || isEip) {
            Expression exp;
            String routeId;
            List args;
            CamelNodeDetails newNode = nodeFactory.newNode(node, name);
            int pos = mi.getName().getStartPosition();
            int line = CamelJavaTreeParserHelper.findLineNumber(fullyQualifiedFileName, pos);
            if (line > -1) {
                newNode.setLineNumber(Integer.toString(line));
            }
            if ((line = CamelJavaTreeParserHelper.findLineNumber(fullyQualifiedFileName, pos = mi.getName().getStartPosition() + mi.getName().getLength())) > -1) {
                newNode.setLineNumberEnd(Integer.toString(line));
            }
            newNode.setFileName(fullyQualifiedFileName);
            newNode.setClassName(clazz.getQualifiedName());
            newNode.setMethodName(configureMethod.getName());
            if ("routeId".equals(name) && (args = mi.arguments()) != null && !args.isEmpty() && (routeId = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, exp = (Expression)args.get(0))) != null) {
                newNode.setRouteId(routeId);
            }
            node.addPreliminaryOutput(newNode);
            return node;
        }
        return node;
    }

    private static FieldSource<JavaClassSource> getField(JavaClassSource clazz, Block block, SimpleName ref) {
        String fieldName = ref.getIdentifier();
        if (fieldName != null) {
            FieldSource<JavaClassSource> field;
            FieldSource<JavaClassSource> fieldSource = field = clazz != null ? clazz.getField(fieldName) : null;
            if (field == null) {
                field = CamelJavaTreeParserHelper.findFieldInBlock(clazz, block, fieldName);
            }
            return field;
        }
        return null;
    }

    private static FieldSource<JavaClassSource> findFieldInBlock(JavaClassSource clazz, Block block, String fieldName) {
        for (Object statement : block.statements()) {
            ASTNode node;
            if (statement instanceof VariableDeclarationStatement) {
                Type type = ((VariableDeclarationStatement)statement).getType();
                for (Object obj : ((VariableDeclarationStatement)statement).fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource<JavaClassSource>(clazz, fragment, type);
                }
            }
            if ((node = block.getParent()) instanceof MethodDeclaration) {
                node = node.getParent();
            }
            if (!(node instanceof AnonymousClassDeclaration)) continue;
            List declarations = ((AnonymousClassDeclaration)node).bodyDeclarations();
            for (Object dec : declarations) {
                if (!(dec instanceof FieldDeclaration)) continue;
                FieldDeclaration fd = (FieldDeclaration)dec;
                Type type = fd.getType();
                for (Object obj : fd.fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource<JavaClassSource>(clazz, fragment, type);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String getLiteralValue(JavaClassSource clazz, Block block, Expression expression) {
        boolean numeric;
        if (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).booleanValue());
        }
        if (expression instanceof NumberLiteral) {
            return ((NumberLiteral)expression).getToken();
        }
        if (expression instanceof MethodInvocation) {
            String name = ((MethodInvocation)expression).getName().getIdentifier();
            return "{{" + name + "}}";
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)expression;
            String name = qn.getFullyQualifiedName();
            return "{{" + name + "}}";
        }
        if (expression instanceof SimpleName) {
            FieldSource<JavaClassSource> field = CamelJavaTreeParserHelper.getField(clazz, block, (SimpleName)expression);
            if (field != null) {
                VariableDeclarationFragment vdf;
                if (field.getAnnotations() != null) {
                    for (Annotation ann : field.getAnnotations()) {
                        boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                        if (!valid) continue;
                        Expression exp = (Expression)ann.getInternal();
                        if (exp instanceof SingleMemberAnnotation) {
                            exp = ((SingleMemberAnnotation)exp).getValue();
                        } else if (exp instanceof NormalAnnotation) {
                            List values = ((NormalAnnotation)exp).values();
                            for (Object value : values) {
                                MemberValuePair pair = (MemberValuePair)value;
                                if (!"uri".equals(pair.getName().toString())) continue;
                                exp = pair.getValue();
                                break;
                            }
                        }
                        if (exp == null) continue;
                        return CamelJavaTreeParserHelper.getLiteralValue(clazz, block, exp);
                    }
                }
                if ("Endpoint".equals(field.getType().getSimpleName())) {
                    vdf = (VariableDeclarationFragment)field.getInternal();
                    expression = vdf.getInitializer();
                    if (!(expression instanceof MethodInvocation)) return null;
                    MethodInvocation mi = (MethodInvocation)expression;
                    List args = mi.arguments();
                    if (args == null) return null;
                    if (args.isEmpty()) return null;
                    expression = (Expression)args.get(0);
                    return CamelJavaTreeParserHelper.getLiteralValue(clazz, block, expression);
                }
                vdf = (VariableDeclarationFragment)field.getInternal();
                expression = vdf.getInitializer();
                if (expression != null) return CamelJavaTreeParserHelper.getLiteralValue(clazz, block, expression);
                return "{{" + field.getName() + "}}";
            }
            String fieldName = ((SimpleName)expression).getIdentifier();
            return "{{" + fieldName + "}}";
        }
        if (!(expression instanceof InfixExpression)) return null;
        InfixExpression ie = (InfixExpression)expression;
        Object answer = null;
        if (!InfixExpression.Operator.PLUS.equals(ie.getOperator())) return answer;
        String val1 = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, ie.getLeftOperand());
        String val2 = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, ie.getRightOperand());
        boolean bl = numeric = CamelJavaTreeParserHelper.isNumericOperator(clazz, block, ie.getLeftOperand()) && CamelJavaTreeParserHelper.isNumericOperator(clazz, block, ie.getRightOperand());
        if (numeric) {
            long num1 = val1 != null ? Long.parseLong(val1) : 0L;
            long num2 = val2 != null ? Long.parseLong(val2) : 0L;
            answer = Long.toString(num1 + num2);
        } else {
            answer = (val1 != null ? val1 : "") + (val2 != null ? val2 : "");
        }
        if (((String)answer).isEmpty()) return answer;
        List extended = ie.extendedOperands();
        if (extended == null) return answer;
        StringBuilder answerBuilder = new StringBuilder((String)answer);
        Iterator iterator = extended.iterator();
        while (iterator.hasNext()) {
            Object ext = iterator.next();
            String val3 = CamelJavaTreeParserHelper.getLiteralValue(clazz, block, (Expression)ext);
            if (numeric) {
                long num3 = val3 != null ? Long.parseLong(val3) : 0L;
                long num = Long.parseLong(answerBuilder.toString());
                answerBuilder = new StringBuilder(Long.toString(num + num3));
                continue;
            }
            answerBuilder.append(val3 != null ? val3 : "");
        }
        return answerBuilder.toString();
    }

    private static boolean isNumericOperator(JavaClassSource clazz, Block block, Expression expression) {
        FieldSource<JavaClassSource> field;
        if (expression instanceof NumberLiteral) {
            return true;
        }
        if (expression instanceof SimpleName && (field = CamelJavaTreeParserHelper.getField(clazz, block, (SimpleName)expression)) != null) {
            return field.getType().isType("int") || field.getType().isType("long") || field.getType().isType("Integer") || field.getType().isType("Long");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLineNumber(String fullyQualifiedFileName, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new FileReader(fullyQualifiedFileName));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int n = lines;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }
}

