/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.robotframework;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.robotframework.RobotFrameworkArguments;
import org.apache.camel.component.robotframework.RobotFrameworkCamelConfiguration;
import org.apache.camel.component.robotframework.RobotFrameworkCamelConstants;
import org.apache.camel.component.robotframework.RobotFrameworkCamelUtils;
import org.apache.camel.component.robotframework.RobotFrameworkComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.robotframework.RobotFramework;

@UriEndpoint(firstVersion="3.0.0", scheme="robotframework", title="Robot Framework", syntax="robotframework:resourceUri", category={Category.TESTING}, headersClass=RobotFrameworkCamelConstants.class)
public class RobotFrameworkEndpoint
extends ResourceEndpoint {
    @UriParam
    private RobotFrameworkCamelConfiguration configuration;

    public RobotFrameworkEndpoint(String uri, RobotFrameworkComponent component, String resourceUri, RobotFrameworkCamelConfiguration configuration) {
        super(uri, (Component)component, resourceUri);
        this.configuration = configuration;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "robotframework:" + this.getResourceUri();
    }

    public RobotFrameworkCamelConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isAllowContextMapAll() {
        return this.configuration.isAllowContextMapAll();
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.configuration.setAllowContextMapAll(allowContextMapAll);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        RobotFrameworkArguments generatedArguments = new RobotFrameworkArguments();
        generatedArguments.addFileToArguments(this.configuration.getOutputDirectory(), "-d");
        generatedArguments.addFileToArguments(this.configuration.getOutput(), "-o");
        generatedArguments.addFileToArguments(this.configuration.getLog(), "-l");
        generatedArguments.addFileToArguments(this.configuration.getReport(), "-r");
        generatedArguments.addFileToArguments(this.configuration.getDebugFile(), "-b");
        generatedArguments.addFileToArguments(this.configuration.getArgumentFiles(), "-A");
        generatedArguments.addFileToArguments(this.configuration.getRunFailed(), "-R");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getName(), "-N");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getDocument(), "-D");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getRunMode(), "--runmode");
        generatedArguments.addFlagToArguments(this.configuration.isDryrun(), "--dryrun");
        generatedArguments.addFlagToArguments(this.configuration.isExitOnFailure(), "--exitonfailure");
        generatedArguments.addFlagToArguments(this.configuration.isSkipTeardownOnExit(), "--skipteardownonexit");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getRandomize(), "--randomize");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getSplitOutputs(), "--splitoutputs");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getLogTitle(), "--logtitle");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getReportTitle(), "--reporttitle");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getReportBackground(), "--reportbackground");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getSummaryTitle(), "--summarytitle");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getLogLevel(), "-L");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getSuiteStatLevel(), "--suitestatlevel");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getMonitorWidth(), "--monitorwidth");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getMonitorColors(), "--monitorcolors");
        generatedArguments.addNonEmptyStringToArguments(this.configuration.getListener(), "--listener");
        generatedArguments.addFlagToArguments(this.configuration.isRunEmptySuite(), "--runemptysuite");
        generatedArguments.addFlagToArguments(this.configuration.isNoStatusReturnCode(), "--nostatusrc");
        generatedArguments.addFlagToArguments(this.configuration.isTimestampOutputs(), "-T");
        generatedArguments.addFlagToArguments(this.configuration.isWarnOnSkippedFiles(), "--warnonskippedfiles");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getMetadata() != null ? this.configuration.getMetadata() : "").split(",")), "-M");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getTags() != null ? this.configuration.getTags() : "").split(",")), "-G");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getTests() != null ? this.configuration.getTests() : "").split(",")), "-t");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getSuites() != null ? this.configuration.getSuites() : "").split(",")), "-s");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getIncludes() != null ? this.configuration.getIncludes() : "").split(",")), "-i");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getExcludes() != null ? this.configuration.getExcludes() : "").split(",")), "-e");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getCriticalTags() != null ? this.configuration.getCriticalTags() : "").split(",")), "-c");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getNonCriticalTags() != null ? this.configuration.getNonCriticalTags() : "").split(",")), "-n");
        List<String> variables = RobotFrameworkCamelUtils.createRobotVariablesFromCamelExchange(exchange, this.isAllowContextMapAll());
        exchange.getIn().setHeader("CamelRobotVariables", variables);
        generatedArguments.addListToArguments(variables, "-v");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getVariableFiles() != null ? this.configuration.getVariableFiles() : "").split(",")), "-V");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getTagStatIncludes() != null ? this.configuration.getTagStatIncludes() : "").split(",")), "--tagstatinclude");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getTagStatExcludes() != null ? this.configuration.getTagStatExcludes() : "").split(",")), "--tagstatexclude");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getCombinedTagStats() != null ? this.configuration.getCombinedTagStats() : "").split(",")), "--tagstatcombine");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getTagDocs() != null ? this.configuration.getTagDocs() : "").split(",")), "--tagdoc");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getTagStatLinks() != null ? this.configuration.getTagStatLinks() : "").split(",")), "--tagstatlink");
        generatedArguments.addListToArguments(Arrays.asList((this.configuration.getListeners() != null ? this.configuration.getListeners() : "").split(",")), "--listener");
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        this.log.debug("RobotFrameworkEndpoint resourceUri:{}", (Object)path);
        String newResourceUri = null;
        if (this.getConfiguration().isAllowTemplateFromHeader()) {
            newResourceUri = (String)exchange.getIn().getHeader("CamelRobotResourceUri", String.class);
        }
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelRobotResourceUri");
            this.log.debug("{} set to {} setting resourceUri to pass robotframework", (Object)"CamelRobotResourceUri", (Object)newResourceUri);
            path = newResourceUri;
        }
        if (this.configuration.getXunitFile() == null) {
            this.configuration.setXunitFile("TEST-" + path.replace(' ', '_') + ".xml");
        }
        generatedArguments.addFileToArguments(this.configuration.getXunitFile(), "-x");
        generatedArguments.addFlagToArguments(true, "--xunitskipnoncritical");
        generatedArguments.add(path);
        int camelRobotReturnCode = RobotFramework.run((String[])generatedArguments.toArray());
        exchange.getIn().setHeader("CamelRobotReturnCode", (Object)camelRobotReturnCode);
    }
}

