/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.rmi.RmiEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class RmiConsumer
extends DefaultConsumer
implements InvocationHandler {
    private final RmiEndpoint endpoint;
    private Remote stub;
    private Remote proxy;

    public RmiConsumer(RmiEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        Class[] interfaces = new Class[this.endpoint.getRemoteInterfaces().size()];
        this.endpoint.getRemoteInterfaces().toArray(interfaces);
        this.proxy = (Remote)Proxy.newProxyInstance(this.endpoint.getClassLoader(), interfaces, (InvocationHandler)this);
        this.stub = UnicastRemoteObject.exportObject(this.proxy, this.endpoint.getPort());
        try {
            Registry registry = this.endpoint.getRegistry();
            String name = this.endpoint.getName();
            registry.bind(name, this.stub);
        }
        catch (Exception e) {
            try {
                UnicastRemoteObject.unexportObject(this.stub, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.stub = null;
            throw e;
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            Registry registry = this.endpoint.getRegistry();
            registry.unbind(this.endpoint.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UnicastRemoteObject.unexportObject(this.proxy, true);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.isStarted()) {
            throw new IllegalStateException("The endpoint is not active: " + this.getEndpoint().getEndpointUri());
        }
        BeanInvocation invocation = new BeanInvocation(method, args);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)invocation);
        try {
            this.log.debug("Invoking {} with args {}", (Object)method, (Object)args);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        Exception fault = exchange.getException();
        if (fault != null) {
            Object match = null;
            for (Class<?> type : method.getExceptionTypes()) {
                Object found = exchange.getException(type);
                if (found == null) continue;
                match = found;
                break;
            }
            if (match instanceof Throwable) {
                throw (Throwable)match;
            }
            throw new RemoteException("Error invoking " + method, fault);
        }
        return exchange.getOut().getBody();
    }

    public Remote getProxy() {
        return this.proxy;
    }

    public Remote getStub() {
        return this.stub;
    }
}

