/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;
import org.apache.camel.component.rest.openapi.RestOpenApiEndpoint;
import org.apache.camel.spi.ContentTypeAware;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class RestOpenApiHelper {
    private static final Pattern HOST_PATTERN = Pattern.compile("https?://[^:]+(:\\d+)?", 2);
    private static final List<String> YAML_CONTENT_TYPES = Arrays.asList("application/yaml", "application/yml", "text/yaml", "text/yml", "text/x-yaml");

    private RestOpenApiHelper() {
    }

    public static String isMediaRange(String given, String name) {
        return StringHelper.notEmpty((String)given, (String)name);
    }

    public static boolean isYamlResource(Resource resource) {
        Objects.requireNonNull(resource, "resource cannot be null");
        if (resource instanceof ContentTypeAware) {
            String contentType = ((ContentTypeAware)resource).getContentType();
            return RestOpenApiHelper.isYamlResourceLocation(resource.getLocation()) || RestOpenApiHelper.isYamlContentType(contentType);
        }
        return RestOpenApiHelper.isYamlResourceLocation(resource.getLocation());
    }

    static String isHostParam(String given) {
        String hostUri = StringHelper.notEmpty((String)given, (String)"host");
        Matcher matcher = HOST_PATTERN.matcher(given);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("host must be an absolute URI (e.g. http://api.example.com), given: `" + hostUri + "`");
        }
        return hostUri;
    }

    private static boolean isYamlContentType(String contentType) {
        if (ObjectHelper.isEmpty((String)contentType)) {
            return false;
        }
        return Stream.of(contentType.split(";")).map(String::trim).anyMatch(YAML_CONTENT_TYPES::contains);
    }

    private static boolean isYamlResourceLocation(String location) {
        if (ObjectHelper.isEmpty((String)location)) {
            return false;
        }
        return location.toLowerCase().endsWith(".yml") || location.toLowerCase().endsWith(".yaml");
    }

    public static String determineBasePath(CamelContext camelContext, RestOpenApiComponent component, RestOpenApiEndpoint endpoint, OpenAPI openAPI) {
        String specificationBasePath;
        String componentBasePath;
        if (endpoint != null && ObjectHelper.isNotEmpty((String)endpoint.getBasePath())) {
            return endpoint.getBasePath();
        }
        if (component != null && ObjectHelper.isNotEmpty((String)(componentBasePath = component.getBasePath()))) {
            return componentBasePath;
        }
        if (openAPI != null && ObjectHelper.isNotEmpty((String)(specificationBasePath = RestOpenApiHelper.getBasePathFromOpenApi(openAPI)))) {
            return specificationBasePath;
        }
        String cn = endpoint != null ? endpoint.determineComponentName() : null;
        RestConfiguration restConfiguration = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)cn);
        String restConfigurationBasePath = restConfiguration.getContextPath();
        if (ObjectHelper.isNotEmpty((String)restConfigurationBasePath)) {
            return restConfigurationBasePath;
        }
        return "/";
    }

    public static String getBasePathFromOpenApi(OpenAPI openApi) {
        String basePath = null;
        if (openApi.getServers() != null) {
            for (Server server : openApi.getServers()) {
                if (server.getUrl() == null) continue;
                try {
                    URI serverUrl = new URI(RestOpenApiHelper.parseVariables(server.getUrl(), server));
                    basePath = serverUrl.getPath();
                    if (basePath.indexOf("//") == 0) {
                        basePath = basePath.substring(1);
                    }
                    if (basePath.endsWith("/")) {
                        basePath = basePath.substring(0, basePath.length() - 1);
                    }
                    if (!"/".equals(basePath)) continue;
                    basePath = "";
                }
                catch (URISyntaxException e) {
                    basePath = server.getUrl();
                }
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Server server) {
        Pattern p = Pattern.compile("\\{(.*?)\\}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String variable = m.group(1);
            if (server == null || server.getVariables() == null || server.getVariables().get((Object)variable) == null) continue;
            String varValue = ((ServerVariable)server.getVariables().get((Object)variable)).getDefault();
            url = url.replace("{" + variable + "}", varValue);
        }
        return url;
    }
}

