/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.maven.htmlxlsx.model.EipAttribute;

public class ChildEip {
    private String id;
    private Map<String, Object> eipAttributeMap = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private static ObjectMapper OBJECT_MAPPER;

    protected ObjectMapper objectMapper() {
        if (OBJECT_MAPPER == null) {
            OBJECT_MAPPER = new ObjectMapper();
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OBJECT_MAPPER.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        }
        return OBJECT_MAPPER;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Object> getEipAttributeMap() {
        return this.eipAttributeMap;
    }

    public void setEipAttributeMap(Map<String, Object> eipAttributeMap) {
        this.eipAttributeMap = eipAttributeMap;
    }

    @JsonAnySetter
    public void setEipAttribute(String key, Object value) {
        if (value instanceof Map) {
            try {
                String childJson = this.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(value);
                EipAttribute eipAttribute = (EipAttribute)this.objectMapper().readValue(childJson, EipAttribute.class);
                this.eipAttributeMap.put(key, eipAttribute);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.eipAttributeMap.put(key, value);
        }
    }

    public String toString() {
        return "ChildEip{id='" + this.id + "', eipAttributes=" + String.valueOf(this.eipAttributeMap) + "}";
    }
}

