/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.ConfigurationPropertiesValidationResult;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.LanguageValidationResult;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.common.CatalogHelper;
import org.apache.camel.catalog.common.FileUtil;
import org.apache.camel.catalog.lucene.LuceneSuggestionStrategy;
import org.apache.camel.catalog.maven.MavenVersionManager;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelRouteDetails;
import org.apache.camel.parser.model.CamelSimpleExpressionDetails;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.StringHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;

@Mojo(name="validate", threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="camel.skipValidation", defaultValue="false")
    private boolean skip;
    @Parameter(property="camel.failOnError", defaultValue="false")
    private boolean failOnError;
    @Parameter(property="camel.logUnparseable", defaultValue="false")
    private boolean logUnparseable;
    @Parameter(property="camel.includeJava", defaultValue="true")
    private boolean includeJava;
    @Parameter(property="camel.extraRepositories")
    private String[] extraMavenRepositories;
    @Parameter(property="camel.sourcesArtifacts")
    private String[] sourcesArtifacts;
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(property="camel.includeXml", defaultValue="true")
    private boolean includeXml;
    @Parameter(property="camel.includeTest", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="camel.includes")
    private String includes;
    @Parameter(property="camel.excludes")
    private String excludes;
    @Parameter(property="camel.ignoreUnknownComponent", defaultValue="true")
    private boolean ignoreUnknownComponent;
    @Parameter(property="camel.ignoreIncapable", defaultValue="true")
    private boolean ignoreIncapable;
    @Parameter(property="camel.ignoreDeprecated", defaultValue="true")
    private boolean ignoreDeprecated;
    @Parameter(property="camel.ignoreLenientProperties", defaultValue="true")
    private boolean ignoreLenientProperties;
    @Parameter(property="camel.showAll", defaultValue="false")
    private boolean showAll;
    @Parameter(property="camel.downloadVersion", defaultValue="true")
    private boolean downloadVersion;
    @Parameter(property="camel.duplicateRouteId", defaultValue="true")
    private boolean duplicateRouteId;
    @Parameter(property="camel.internalContextPairCheck", alias="camel.directOrSedaPairCheck", defaultValue="true")
    private boolean internalContextPairCheck;
    @Parameter(property="camel.downloadTransitiveArtifacts", defaultValue="false")
    private boolean downloadTransitiveArtifacts;
    @Parameter(property="camel.configurationFiles", defaultValue="application.properties")
    private String configurationFiles;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    private static final Set<File> javaFiles = new LinkedHashSet<File>();
    private static final Set<File> xmlFiles = new LinkedHashSet<File>();
    private static final Set<String> downloadedArtifacts = new LinkedHashSet<String>();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping route validation as per configuration");
            return;
        }
        this.downloadExtraSources();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.addComponent("activemq", "org.apache.activemq.camel.component.ActiveMQComponent");
        catalog.setSuggestionStrategy((SuggestionStrategy)new LuceneSuggestionStrategy());
        catalog.setVersionManager((VersionManager)new MavenVersionManager(this.repositorySystem, this.repositorySystemSession, this.session.getSettings()));
        catalog.getJSonSchemaResolver().setClassLoader(ValidateMojo.class.getClassLoader());
        catalog.enableCache();
        String detectedVersion = ValidateMojo.findCamelVersion(this.project);
        if (detectedVersion != null) {
            this.getLog().info((CharSequence)("Detected Camel version used in project: " + detectedVersion));
        }
        this.downloadCamelCatalogVersion((CamelCatalog)catalog);
        if (catalog.getLoadedVersion() != null) {
            this.getLog().info((CharSequence)("Validating using downloaded Camel version: " + catalog.getLoadedVersion()));
        } else {
            this.getLog().info((CharSequence)("Validating using Camel version: " + catalog.getCatalogVersion()));
        }
        this.doExecuteRoutes((CamelCatalog)catalog);
        this.doExecuteConfigurationFiles((CamelCatalog)catalog);
    }

    private void downloadCamelCatalogVersion(CamelCatalog catalog) {
        if (this.downloadVersion) {
            String catalogVersion = catalog.getCatalogVersion();
            String version = ValidateMojo.findCamelVersion(this.project);
            if (version != null && !version.equals(catalogVersion)) {
                this.getLog().info((CharSequence)("Downloading Camel version: " + version));
                boolean loaded = catalog.loadVersion(version);
                if (!loaded) {
                    this.getLog().warn((CharSequence)("Error downloading Camel version: " + version));
                }
            }
        }
    }

    private void downloadExtraSources() throws MojoExecutionException {
        if (!"pom".equals(this.project.getPackaging()) && this.sourcesArtifacts != null && this.sourcesArtifacts.length > 0) {
            List<String> artifacts = Arrays.asList(this.sourcesArtifacts);
            artifacts.parallelStream().forEach(artifact -> {
                if (!artifact.contains(":sources:")) {
                    this.getLog().warn((CharSequence)("The artifact " + artifact + " does not contain sources classifier, and may be excluded in future releases"));
                }
            });
            try (MavenDownloaderImpl downloader = new MavenDownloaderImpl(this.repositorySystem, this.repositorySystemSession, this.session.getSettings());){
                this.downloadArtifacts(downloader, artifacts);
            }
            catch (IOException e) {
                throw new MojoExecutionException((Throwable)e);
            }
            catch (MavenResolutionException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }

    private void downloadArtifacts(MavenDownloaderImpl downloader, List<String> artifacts) throws MavenResolutionException, IOException {
        downloader.init();
        Set<String> repositorySet = Arrays.stream(this.extraMavenRepositories).collect(Collectors.toSet());
        ArrayList<String> artifactList = new ArrayList<String>(artifacts);
        artifactList.removeAll(downloadedArtifacts);
        if (!artifactList.isEmpty()) {
            this.doDownloadArtifacts(artifactList, downloader, repositorySet);
        }
    }

    private void doDownloadArtifacts(List<String> artifactList, MavenDownloaderImpl downloader, Set<String> repositorySet) throws MavenResolutionException, IOException {
        this.getLog().info((CharSequence)("Downloading the following artifacts: " + String.valueOf(artifactList)));
        List mavenSourcesArtifacts = downloader.resolveArtifacts(artifactList, repositorySet, this.downloadTransitiveArtifacts, false);
        Path extraSourcesPath = Paths.get(this.projectBuildDir, "camel-validate-sources");
        if (!Files.exists(extraSourcesPath, new LinkOption[0])) {
            Files.createDirectories(extraSourcesPath, new FileAttribute[0]);
        }
        this.unzipIntoCache(mavenSourcesArtifacts, extraSourcesPath);
    }

    private void unzipIntoCache(List<MavenArtifact> mavenSourcesArtifacts, Path extraSourcesPath) throws IOException {
        for (MavenArtifact artifact : mavenSourcesArtifacts) {
            String gav = ValidateMojo.toGav(artifact);
            downloadedArtifacts.add(gav);
            Path target = extraSourcesPath.resolve(artifact.getGav().getArtifactId());
            this.getLog().info((CharSequence)("Unzipping the artifact: " + String.valueOf(artifact) + " to " + String.valueOf(target)));
            if (Files.exists(target, new LinkOption[0])) continue;
            ValidateMojo.unzipArtifact(artifact, target);
            FileUtil.findJavaFiles((File)target.toFile(), javaFiles);
            FileUtil.findXmlFiles((File)target.toFile(), xmlFiles);
        }
    }

    private static String toGav(MavenArtifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGav().getGroupId()).append(":").append(artifact.getGav().getArtifactId()).append(":").append(artifact.getGav().getPackaging()).append(":").append(artifact.getGav().getClassifier()).append(":").append(artifact.getGav().getVersion());
        String gav = sb.toString();
        return gav;
    }

    private static void unzipArtifact(MavenArtifact artifact, Path target) throws IOException {
        try (ZipFile zipFile = new ZipFile(artifact.getFile().toPath().toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            target = target.normalize();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path dest = target.resolve(entry.getName()).normalize();
                if (!dest.startsWith(target)) continue;
                if (entry.isDirectory()) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                InputStream in = zipFile.getInputStream(entry);
                try {
                    Files.copy(in, dest, new CopyOption[0]);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    protected void doExecuteConfigurationFiles(CamelCatalog catalog) throws MojoExecutionException {
        LinkedHashSet<File> propertiesFiles = new LinkedHashSet<File>();
        for (Resource dir : this.project.getResources()) {
            this.findPropertiesFiles(new File(dir.getDirectory()), propertiesFiles);
        }
        if (this.includeTest) {
            for (Resource dir : this.project.getTestResources()) {
                this.findPropertiesFiles(new File(dir.getDirectory()), propertiesFiles);
            }
        }
        ArrayList<ConfigurationPropertiesValidationResult> results = new ArrayList<ConfigurationPropertiesValidationResult>();
        for (File file : propertiesFiles) {
            this.parseProperties(catalog, file, results);
        }
        this.validateResults(results);
    }

    private void validateResults(List<ConfigurationPropertiesValidationResult> results) throws MojoExecutionException {
        String configurationSummary;
        ValidationComputedResult validationComputedResult = new ValidationComputedResult();
        for (ConfigurationPropertiesValidationResult result : results) {
            int deprecated = ValidateMojo.countDeprecated(result.getDeprecated());
            validationComputedResult.incrementDeprecatedOptionsBy(deprecated);
            boolean validationPassed = this.checkValidationPassed(validationComputedResult, result, deprecated);
            this.handleValidationResult(validationComputedResult, result, validationPassed);
        }
        if (validationComputedResult.getConfigurationErrors() == 0) {
            int ok = results.size() - validationComputedResult.getConfigurationErrors() - validationComputedResult.getIncapableErrors() - validationComputedResult.getUnknownComponents();
            configurationSummary = String.format("Configuration validation success: (%s = passed, %s = invalid, %s = incapable, %s = unknown components, %s = deprecated options)", ok, validationComputedResult.getConfigurationErrors(), validationComputedResult.getIncapableErrors(), validationComputedResult.getUnknownComponents(), validationComputedResult.getDeprecatedOptions());
        } else {
            int ok = results.size() - validationComputedResult.getConfigurationErrors() - validationComputedResult.getIncapableErrors() - validationComputedResult.getUnknownComponents();
            configurationSummary = String.format("Configuration validation error: (%s = passed, %s = invalid, %s = incapable, %s = unknown components, %s = deprecated options)", ok, validationComputedResult.getConfigurationErrors(), validationComputedResult.getIncapableErrors(), validationComputedResult.getUnknownComponents(), validationComputedResult.getDeprecatedOptions());
        }
        this.logErrorSummary(validationComputedResult.getConfigurationErrors(), configurationSummary);
        if (this.failOnError && validationComputedResult.getConfigurationErrors() > 0) {
            throw new MojoExecutionException(configurationSummary + "\n");
        }
    }

    private String buildValidationFailedSummary(ConfigurationPropertiesValidationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration validation error at: ");
        sb.append("(").append(result.getFileName());
        if (result.getLineNumber() > 0) {
            sb.append(":").append(result.getLineNumber());
        }
        sb.append(")");
        sb.append("\n\n");
        String out = result.summaryErrorMessage(false, this.ignoreDeprecated, true);
        sb.append(out);
        sb.append("\n\n");
        String validationFailed = sb.toString();
        return validationFailed;
    }

    private static String buildValidationPassedSummary(ConfigurationPropertiesValidationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration validation passed at: ");
        sb.append(result.getFileName());
        if (result.getLineNumber() > 0) {
            sb.append(":").append(result.getLineNumber());
        }
        sb.append("\n");
        sb.append("\n\t").append(result.getText());
        sb.append("\n\n");
        String validationPassed = sb.toString();
        return validationPassed;
    }

    private void parseProperties(CamelCatalog catalog, File file, List<ConfigurationPropertiesValidationResult> results) {
        if (this.matchPropertiesFile(file)) {
            try (FileInputStream is = new FileInputStream(file);){
                OrderedProperties prop = new OrderedProperties();
                prop.load(is);
                for (String name : prop.stringPropertyNames()) {
                    this.validateLine(catalog, file, results, name, (Properties)prop);
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing file " + String.valueOf(file) + " code due " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void validateLine(CamelCatalog catalog, File file, List<ConfigurationPropertiesValidationResult> results, String name, Properties prop) {
        String value = prop.getProperty(name);
        if (value == null) {
            return;
        }
        String text = name + "=" + value;
        ConfigurationPropertiesValidationResult result = catalog.validateConfigurationProperty(text);
        if (result.isAccepted()) {
            int lineNumber = this.findLineNumberInPropertiesFile(file, name);
            if (lineNumber != -1) {
                result.setLineNumber(lineNumber);
            }
            results.add(result);
            result.setText(text);
            result.setFileName(file.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findLineNumberInPropertiesFile(File file, String name) {
        name = name.trim();
        try (LineNumberReader r = new LineNumberReader(new FileReader(file));){
            String line = r.readLine();
            while (line != null) {
                int pos = line.indexOf(61);
                if (pos > 0) {
                    line = line.substring(0, pos);
                }
                if ((line = line.trim()).equals(name)) {
                    int n = r.getLineNumber();
                    return n;
                }
                line = r.readLine();
            }
            return -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    protected void doExecuteRoutes(CamelCatalog catalog) throws MojoExecutionException {
        ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
        ArrayList<CamelSimpleExpressionDetails> simpleExpressions = new ArrayList<CamelSimpleExpressionDetails>();
        ArrayList<CamelRouteDetails> routeIds = new ArrayList<CamelRouteDetails>();
        CatalogHelper.findJavaRouteBuilderClasses(javaFiles, (boolean)this.includeJava, (boolean)this.includeTest, (MavenProject)this.project);
        CatalogHelper.findXmlRouters(xmlFiles, (boolean)this.includeXml, (boolean)this.includeTest, (MavenProject)this.project);
        for (File file : javaFiles) {
            if (!this.matchFile(file)) continue;
            this.parseJavaRouteFile(endpoints, simpleExpressions, routeIds, file);
        }
        for (File file : xmlFiles) {
            if (!this.matchFile(file)) continue;
            this.parseXmlRouteFile(endpoints, simpleExpressions, routeIds, file);
        }
        this.validateResults(catalog, endpoints, simpleExpressions, routeIds);
    }

    private void validateResults(CamelCatalog catalog, List<CamelEndpointDetails> endpoints, List<CamelSimpleExpressionDetails> simpleExpressions, List<CamelRouteDetails> routeIds) throws MojoExecutionException {
        ValidationComputedResult validationComputedResult = new ValidationComputedResult();
        for (CamelEndpointDetails detail : endpoints) {
            this.getLog().debug((CharSequence)("Validating endpoint: " + detail.getEndpointUri()));
            EndpointValidationResult result = catalog.validateEndpointProperties(detail.getEndpointUri(), this.ignoreLenientProperties);
            int deprecatedCount = ValidateMojo.countDeprecated(result.getDeprecated());
            validationComputedResult.incrementDeprecatedOptionsBy(deprecatedCount);
            boolean validationPassed = this.checkValidationPassed(validationComputedResult, result, deprecatedCount);
            this.handleValidationResult(validationComputedResult, detail, result, validationPassed);
        }
        String endpointSummary = this.buildEndpointSummaryMessage(endpoints, validationComputedResult.getEndpointErrors(), validationComputedResult.getUnknownComponents(), validationComputedResult.getIncapableErrors(), validationComputedResult.getDeprecatedOptions());
        this.logErrorSummary(validationComputedResult.getEndpointErrors(), endpointSummary);
        int simpleErrors = this.validateSimple(catalog, simpleExpressions);
        String simpleSummary = this.buildSimpleSummaryMessage(simpleExpressions, simpleErrors);
        this.logErrorSummary(simpleErrors, simpleSummary);
        int endpointsWithError = 0;
        String logErrorSummary = "";
        if (this.internalContextPairCheck) {
            long numberOfEndpoints = (long)this.countEndpointPairs(endpoints, "direct") + (long)this.countEndpointPairs(endpoints, "seda") + (long)this.countEndpointPairs(endpoints, "disruptor") + (long)this.countEndpointPairs(endpoints, "disruptor-vm");
            logErrorSummary = ValidateMojo.getSedaDirectSummary(endpointsWithError += this.validateEndpointPairs(endpoints, "direct") + this.validateEndpointPairs(endpoints, "seda") + this.validateEndpointPairs(endpoints, "disruptor") + this.validateEndpointPairs(endpoints, "disruptor-vm"), numberOfEndpoints);
            this.logErrorSummary(endpointsWithError, logErrorSummary);
        }
        int duplicateRouteIdErrors = this.validateDuplicateRouteId(routeIds);
        String routeIdSummary = "";
        if (this.duplicateRouteId) {
            routeIdSummary = this.handleDuplicateRouteId(duplicateRouteIdErrors, routeIds);
        }
        if (this.failOnError && ValidateMojo.hasErrors(validationComputedResult.getEndpointErrors(), simpleErrors, duplicateRouteIdErrors) || endpointsWithError > 0) {
            throw new MojoExecutionException(endpointSummary + "\n" + simpleSummary + "\n" + routeIdSummary + "\n" + logErrorSummary);
        }
    }

    private void handleValidationResult(ValidationComputedResult validationComputedResult, CamelEndpointDetails detail, EndpointValidationResult result, boolean validationPassed) {
        if (!validationPassed) {
            if (result.getUnknownComponent() != null) {
                validationComputedResult.incrementUnknownComponents();
            } else if (result.getIncapable() != null) {
                validationComputedResult.incrementIncapableErrors();
            } else {
                validationComputedResult.incrementEndpointErrors();
            }
            String msg = this.buildValidationErrorMessage(detail, result);
            this.getLog().warn((CharSequence)msg);
        } else if (this.showAll) {
            String msg = this.buildValidationPassedMessage(detail, result);
            this.getLog().info((CharSequence)msg);
        }
    }

    private void handleValidationResult(ValidationComputedResult validationComputedResult, ConfigurationPropertiesValidationResult result, boolean validationPassed) {
        if (!validationPassed) {
            if (result.getUnknownComponent() != null) {
                validationComputedResult.incrementUnknownComponents();
            } else if (result.getIncapable() != null) {
                validationComputedResult.incrementIncapableErrors();
            } else {
                validationComputedResult.incrementConfigurationErrors();
            }
            String validationFailed = this.buildValidationFailedSummary(result);
            this.getLog().warn((CharSequence)validationFailed);
        } else if (this.showAll) {
            String validationPassedSummary = ValidateMojo.buildValidationPassedSummary(result);
            this.getLog().info((CharSequence)validationPassedSummary);
        }
    }

    private boolean checkValidationPassed(ValidationComputedResult validationComputedResult, EndpointValidationResult result, int deprecatedCount) {
        boolean validationPassed = this.checkValidationPassed(result.isSuccess(), result.hasWarnings(), result.getUnknownComponent(), validationComputedResult, result.getIncapable(), deprecatedCount);
        return validationPassed;
    }

    private boolean checkValidationPassed(ValidationComputedResult validationComputedResult, ConfigurationPropertiesValidationResult result, int deprecatedCount) {
        boolean validationPassed = this.checkValidationPassed(result.isSuccess(), result.hasWarnings(), result.getUnknownComponent(), validationComputedResult, result.getIncapable(), deprecatedCount);
        return validationPassed;
    }

    private boolean checkValidationPassed(boolean success, boolean hasWarning, String unknownComponent, ValidationComputedResult validationComputedResult, String incapable, int deprecatedCount) {
        boolean validationPassed;
        boolean bl = validationPassed = success && !hasWarning;
        if (!validationPassed && this.ignoreUnknownComponent && unknownComponent != null) {
            validationComputedResult.incrementUnknownComponents();
            validationPassed = true;
        }
        if (!validationPassed && this.ignoreIncapable && incapable != null) {
            validationComputedResult.incrementIncapableErrors();
            validationPassed = true;
        }
        if (validationPassed && !this.ignoreDeprecated && deprecatedCount > 0) {
            validationPassed = false;
        }
        return validationPassed;
    }

    private static String getSedaDirectSummary(int endpointErrors, long totalPairs) {
        String summary = endpointErrors == 0 ? String.format("Endpoint pair (seda/direct/disruptor/disruptor-vm) validation success: (%s = pairs)", totalPairs) : String.format("Endpoint pair (seda/direct/disruptor/disruptor-vm) validation error: (%s = pairs, %s = non-pairs)", totalPairs, endpointErrors);
        return summary;
    }

    private static int countDeprecated(Set<String> result) {
        return result != null ? result.size() : 0;
    }

    private void logErrorSummary(int errors, String summary) {
        if (errors > 0) {
            this.getLog().warn((CharSequence)summary);
        } else {
            this.getLog().info((CharSequence)summary);
        }
    }

    private static boolean hasErrors(int endpointErrors, int simpleErrors, int duplicateRouteIdErrors) {
        return endpointErrors > 0 || simpleErrors > 0 || duplicateRouteIdErrors > 0;
    }

    private String handleDuplicateRouteId(int duplicateRouteIdErrors, List<CamelRouteDetails> routeIds) {
        String routeIdSummary = duplicateRouteIdErrors == 0 ? String.format("Duplicate route id validation success: (%s = ids)", routeIds.size()) : String.format("Duplicate route id validation error: (%s = ids, %s = duplicates)", routeIds.size(), duplicateRouteIdErrors);
        this.logErrorSummary(duplicateRouteIdErrors, routeIdSummary);
        return routeIdSummary;
    }

    private String buildSimpleSummaryMessage(List<CamelSimpleExpressionDetails> simpleExpressions, int simpleErrors) {
        String simpleSummary;
        if (simpleErrors == 0) {
            int ok = simpleExpressions.size() - simpleErrors;
            simpleSummary = String.format("Simple validation success: (%s = passed, %s = invalid)", ok, simpleErrors);
        } else {
            int ok = simpleExpressions.size() - simpleErrors;
            simpleSummary = String.format("Simple validation error: (%s = passed, %s = invalid)", ok, simpleErrors);
        }
        return simpleSummary;
    }

    private String buildEndpointSummaryMessage(List<CamelEndpointDetails> endpoints, int endpointErrors, int unknownComponents, int incapableErrors, int deprecatedOptions) {
        String endpointSummary;
        if (endpointErrors == 0) {
            int ok = endpoints.size() - endpointErrors - incapableErrors - unknownComponents;
            endpointSummary = String.format("Endpoint validation success: (%s = passed, %s = invalid, %s = incapable, %s = unknown components, %s = deprecated options)", ok, endpointErrors, incapableErrors, unknownComponents, deprecatedOptions);
        } else {
            int ok = endpoints.size() - endpointErrors - incapableErrors - unknownComponents;
            endpointSummary = String.format("Endpoint validation error: (%s = passed, %s = invalid, %s = incapable, %s = unknown components, %s = deprecated options)", ok, endpointErrors, incapableErrors, unknownComponents, deprecatedOptions);
        }
        return endpointSummary;
    }

    private String buildValidationPassedMessage(CamelEndpointDetails detail, EndpointValidationResult result) {
        StringBuilder sb = this.buildValidationSuccessMessage("Endpoint validation passed at: ", detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName(), result.getUri());
        return sb.toString();
    }

    private String buildValidationErrorMessage(CamelEndpointDetails detail, EndpointValidationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Endpoint validation error at: ");
        this.buildErrorMessage(sb, detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName());
        sb.append("\n\n");
        String out = result.summaryErrorMessage(false, this.ignoreDeprecated, true);
        sb.append(out);
        sb.append("\n\n");
        return sb.toString();
    }

    private void parseXmlRouteFile(List<CamelEndpointDetails> endpoints, List<CamelSimpleExpressionDetails> simpleExpressions, List<CamelRouteDetails> routeIds, File file) {
        try {
            ArrayList fileEndpoints = new ArrayList();
            ArrayList fileSimpleExpressions = new ArrayList();
            ArrayList fileRouteIds = new ArrayList();
            String fqn = file.getPath();
            String baseDir = ".";
            try (FileInputStream is = new FileInputStream(file);){
                XmlRouteParser.parseXmlRouteEndpoints((InputStream)is, (String)baseDir, (String)fqn, fileEndpoints);
            }
            is = new FileInputStream(file);
            try {
                XmlRouteParser.parseXmlRouteSimpleExpressions((InputStream)is, (String)baseDir, (String)fqn, fileSimpleExpressions);
            }
            finally {
                ((InputStream)is).close();
            }
            if (this.duplicateRouteId) {
                is = new FileInputStream(file);
                try {
                    XmlRouteParser.parseXmlRouteRouteIds((InputStream)is, (String)baseDir, (String)fqn, fileRouteIds);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            endpoints.addAll(fileEndpoints);
            simpleExpressions.addAll(fileSimpleExpressions);
            routeIds.addAll(fileRouteIds);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error parsing xml file " + String.valueOf(file) + " code due " + e.getMessage()), (Throwable)e);
        }
    }

    private void parseJavaRouteFile(List<CamelEndpointDetails> endpoints, List<CamelSimpleExpressionDetails> simpleExpressions, List<CamelRouteDetails> routeIds, File file) {
        try {
            ArrayList fileEndpoints = new ArrayList();
            ArrayList fileRouteIds = new ArrayList();
            ArrayList fileSimpleExpressions = new ArrayList();
            ArrayList unparsable = new ArrayList();
            String fqn = file.getPath();
            String baseDir = ".";
            JavaType out = Roaster.parse((File)file);
            if (out instanceof JavaClassSource) {
                JavaClassSource clazz = (JavaClassSource)out;
                RouteBuilderParser.parseRouteBuilderEndpoints((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileEndpoints, unparsable, (boolean)this.includeTest);
                RouteBuilderParser.parseRouteBuilderSimpleExpressions((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileSimpleExpressions);
                if (this.duplicateRouteId) {
                    RouteBuilderParser.parseRouteBuilderRouteIds((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileRouteIds);
                }
                endpoints.addAll(fileEndpoints);
                simpleExpressions.addAll(fileSimpleExpressions);
                routeIds.addAll(fileRouteIds);
                if (this.logUnparseable && !unparsable.isEmpty()) {
                    for (String uri : unparsable) {
                        this.getLog().warn((CharSequence)("Cannot parse endpoint uri " + uri + " in java file " + String.valueOf(file)));
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error parsing java file " + String.valueOf(file) + " code due " + e.getMessage()), (Throwable)e);
        }
    }

    private int countEndpointPairs(List<CamelEndpointDetails> endpoints, String scheme) {
        int pairs = 0;
        Set consumers = endpoints.stream().filter(e -> e.isConsumerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        Set producers = endpoints.stream().filter(e -> e.isProducerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        for (CamelEndpointDetails p : producers) {
            boolean any = consumers.stream().anyMatch(c -> ValidateMojo.matchEndpointPath(p.getEndpointUri(), c.getEndpointUri()));
            if (!any) continue;
            ++pairs;
        }
        return pairs;
    }

    private int validateEndpointPairs(List<CamelEndpointDetails> endpoints, String scheme) {
        int errors = 0;
        Set consumers = endpoints.stream().filter(e -> e.isConsumerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        Set producers = endpoints.stream().filter(e -> e.isProducerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        for (CamelEndpointDetails detail : producers) {
            boolean none = consumers.stream().noneMatch(c -> ValidateMojo.matchEndpointPath(detail.getEndpointUri(), c.getEndpointUri()));
            if (none) {
                ++errors;
                String msg = this.buildEndpointValidationErrorMessage(detail);
                this.getLog().warn((CharSequence)msg);
                continue;
            }
            if (!this.showAll) continue;
            StringBuilder sb = this.buildValidationSuccessMessage("Endpoint pair (seda/direct) validation passed at: ", detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName(), detail.getEndpointUri());
            String msg = sb.toString();
            this.getLog().info((CharSequence)msg);
        }
        return errors;
    }

    private StringBuilder buildValidationSuccessMessage(String str, String className, String lineNumber, String methodName, String fileName, String uri) {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        this.buildErrorMessage(sb, className, lineNumber, methodName, fileName);
        sb.append("\n");
        sb.append("\n\t").append(uri);
        sb.append("\n\n");
        return sb;
    }

    private String buildEndpointValidationErrorMessage(CamelEndpointDetails detail) {
        StringBuilder sb = new StringBuilder();
        sb.append("Endpoint pair (seda/direct) validation error at: ");
        this.buildErrorMessage(sb, detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName());
        sb.append("\n");
        sb.append("\n\t").append(detail.getEndpointUri());
        sb.append("\n\n\t\t\t\t").append(ValidateMojo.endpointPathSummaryError(detail));
        sb.append("\n\n");
        return sb.toString();
    }

    private void buildErrorMessage(StringBuilder sb, String className, String lineNumber, String methodName, String fileName) {
        if (className != null && lineNumber != null) {
            sb.append(className);
            if (methodName != null) {
                sb.append(".").append(methodName);
            }
            sb.append("(").append(ValidateMojo.asSimpleClassName(className)).append(".java:");
            sb.append(lineNumber).append(")");
        } else if (lineNumber != null) {
            String fqn = CatalogHelper.stripRootPath((String)CatalogHelper.asRelativeFile((String)fileName, (MavenProject)this.project), (MavenProject)this.project);
            if (fqn.endsWith(".xml")) {
                fqn = fqn.substring(0, fqn.length() - 4);
                fqn = ValidateMojo.asPackageName(fqn);
            }
            sb.append(fqn);
            sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
            sb.append(lineNumber).append(")");
        } else {
            sb.append(fileName);
        }
    }

    private static String endpointPathSummaryError(CamelEndpointDetails detail) {
        String uri = detail.getEndpointUri();
        String p = uri.contains("?") ? StringHelper.before((String)uri, (String)"?") : uri;
        String path = StringHelper.after((String)p, (String)":");
        return path + "\tSending to non existing " + detail.getEndpointComponentName() + " queue name";
    }

    private static boolean matchEndpointPath(String uri, String uri2) {
        String p = uri.contains("?") ? StringHelper.before((String)uri, (String)"?") : uri;
        String p2 = uri2.contains("?") ? StringHelper.before((String)uri2, (String)"?") : uri2;
        p = p.trim();
        p2 = p2.trim();
        return p.equals(p2);
    }

    private int validateSimple(CamelCatalog catalog, List<CamelSimpleExpressionDetails> simpleExpressions) {
        int simpleErrors = 0;
        for (CamelSimpleExpressionDetails detail : simpleExpressions) {
            StringBuilder sb;
            LanguageValidationResult result;
            boolean predicate = detail.isPredicate();
            if (predicate) {
                this.getLog().debug((CharSequence)("Validating simple predicate: " + detail.getSimple()));
                result = catalog.validateLanguagePredicate(null, "simple", detail.getSimple());
            } else {
                this.getLog().debug((CharSequence)("Validating simple expression: " + detail.getSimple()));
                result = catalog.validateLanguageExpression(null, "simple", detail.getSimple());
            }
            if (!result.isSuccess()) {
                String[] lines;
                ++simpleErrors;
                sb = new StringBuilder();
                sb.append("Simple validation error at: ");
                this.buildErrorMessage(sb, detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName());
                sb.append("\n");
                for (String line : lines = result.getError().split("\n")) {
                    sb.append("\n\t").append(line);
                }
                sb.append("\n");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            if (!this.showAll) continue;
            sb = this.buildValidationSuccessMessage("Simple validation passed at: ", detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName(), result.getText());
            this.getLog().info((CharSequence)sb.toString());
        }
        return simpleErrors;
    }

    private int validateDuplicateRouteId(List<CamelRouteDetails> routeIds) {
        int duplicateRouteIdErrors = 0;
        if (this.duplicateRouteId) {
            for (CamelRouteDetails detail : routeIds) {
                String msg;
                if (detail.getRouteId() == null || "".equals(detail.getRouteId())) continue;
                int count = ValidateMojo.countRouteId(routeIds, detail.getRouteId());
                if (count > 1) {
                    ++duplicateRouteIdErrors;
                    msg = this.buildRouteIdValidationMessage("Duplicate route id validation error at: ", detail);
                    this.getLog().warn((CharSequence)msg);
                    continue;
                }
                if (!this.showAll) continue;
                msg = this.buildRouteIdValidationMessage("Duplicate route id validation passed at: ", detail);
                this.getLog().info((CharSequence)msg);
            }
        }
        return duplicateRouteIdErrors;
    }

    private String buildRouteIdValidationMessage(String str, CamelRouteDetails detail) {
        StringBuilder sb = this.buildValidationSuccessMessage(str, detail.getClassName(), detail.getLineNumber(), detail.getMethodName(), detail.getFileName(), detail.getRouteId());
        return sb.toString();
    }

    private static int countRouteId(List<CamelRouteDetails> details, String routeId) {
        int answer = 0;
        for (CamelRouteDetails detail : details) {
            if (!routeId.equals(detail.getRouteId())) continue;
            ++answer;
        }
        return answer;
    }

    private static String findCamelVersion(MavenProject project) {
        Dependency candidate = null;
        for (Dependency dep : project.getDependencies()) {
            if (!"org.apache.camel".equals(dep.getGroupId())) continue;
            if ("camel-core".equals(dep.getArtifactId())) {
                candidate = dep;
                break;
            }
            candidate = dep;
        }
        if (candidate != null) {
            return candidate.getVersion();
        }
        return null;
    }

    private void findPropertiesFiles(File dir, Set<File> propertiesFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".properties")) {
                    propertiesFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileUtil.findJavaFiles((File)file, propertiesFiles);
            }
        }
    }

    private boolean matchPropertiesFile(File file) {
        for (String part : this.configurationFiles.split(",")) {
            part = part.trim();
            String fqn = CatalogHelper.stripRootPath((String)CatalogHelper.asRelativeFile((String)file.getAbsolutePath(), (MavenProject)this.project), (MavenProject)this.project);
            boolean match = PatternHelper.matchPattern((String)fqn, (String)part);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean matchFile(File file) {
        return CatalogHelper.matchRouteFile((File)file, (String)this.excludes, (String)this.includes, (MavenProject)this.project);
    }

    private static String asPackageName(String name) {
        return name.replace(File.separator, ".");
    }

    private static String asSimpleClassName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            return className.substring(dot + 1);
        }
        return className;
    }

    private static class ValidationComputedResult {
        private int endpointErrors = 0;
        private int configurationErrors = 0;
        private int unknownComponents = 0;
        private int incapableErrors = 0;
        private int deprecatedOptions = 0;

        private ValidationComputedResult() {
        }

        public void incrementEndpointErrors() {
            ++this.endpointErrors;
        }

        public void incrementConfigurationErrors() {
            ++this.configurationErrors;
        }

        public void incrementUnknownComponents() {
            ++this.unknownComponents;
        }

        public void incrementIncapableErrors() {
            ++this.incapableErrors;
        }

        public void incrementDeprecatedOptionsBy(int extra) {
            this.deprecatedOptions += extra;
        }

        public int getEndpointErrors() {
            return this.endpointErrors;
        }

        public int getConfigurationErrors() {
            return this.configurationErrors;
        }

        public int getUnknownComponents() {
            return this.unknownComponents;
        }

        public int getIncapableErrors() {
            return this.incapableErrors;
        }

        public int getDeprecatedOptions() {
            return this.deprecatedOptions;
        }
    }
}

