/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import java.io.Closeable;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsCamelSubscriber
implements Subscriber<Exchange>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStreamsCamelSubscriber.class);
    private static final long UNBOUNDED_REQUESTS = Long.MAX_VALUE;
    private final String name;
    private ReactiveStreamsConsumer consumer;
    private Subscription subscription;
    private long requested;
    private long inflightCount;

    public ReactiveStreamsCamelSubscriber(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachConsumer(ReactiveStreamsConsumer consumer) {
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            if (this.consumer != null) {
                throw new IllegalStateException("A consumer is already attached to the stream '" + this.name + "'");
            }
            this.consumer = consumer;
        }
        this.refill();
    }

    public synchronized ReactiveStreamsConsumer getConsumer() {
        return this.consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachConsumer() {
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            this.consumer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription is null for stream '" + this.name + "'");
        }
        boolean allowed = true;
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            if (this.subscription != null) {
                allowed = false;
            } else {
                this.subscription = subscription;
            }
        }
        if (!allowed) {
            LOG.warn("There is another active subscription: cancelled");
            subscription.cancel();
        } else {
            this.refill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Exchange exchange) {
        ReactiveStreamsConsumer target;
        if (exchange == null) {
            throw new NullPointerException("exchange is null");
        }
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            if (this.requested < Long.MAX_VALUE) {
                --this.requested;
            }
            if ((target = this.consumer) != null) {
                ++this.inflightCount;
            }
        }
        if (target != null) {
            target.process(exchange, doneSync -> {
                ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
                synchronized (reactiveStreamsCamelSubscriber) {
                    --this.inflightCount;
                }
                this.refill();
            });
        } else {
            LOG.warn("Message received in stream '{}', but no consumers were attached. Discarding {}.", (Object)this.name, (Object)exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refill() {
        Long toBeRequested = null;
        Subscription subs = null;
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            if (this.consumer != null && this.subscription != null) {
                long max;
                Integer consMax = this.consumer.getEndpoint().getMaxInflightExchanges();
                long l = max = consMax != null && consMax > 0 ? consMax.longValue() : Long.MAX_VALUE;
                if (this.requested < Long.MAX_VALUE) {
                    long lowWatermark = Math.max(0L, Math.round(this.consumer.getEndpoint().getExchangesRefillLowWatermark() * (double)max));
                    long minRequests = Math.min(max, max - lowWatermark);
                    long newRequest = max - this.requested - this.inflightCount;
                    if (newRequest > 0L && newRequest >= minRequests) {
                        toBeRequested = newRequest;
                        this.requested += toBeRequested.longValue();
                        subs = this.subscription;
                    }
                }
            }
        }
        if (toBeRequested != null) {
            subs.request(toBeRequested.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        ReactiveStreamsConsumer consumer;
        if (throwable == null) {
            throw new NullPointerException("throwable is null");
        }
        LOG.error("Error in reactive stream '{}'", (Object)this.name, (Object)throwable);
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            consumer = this.consumer;
            this.subscription = null;
        }
        if (consumer != null) {
            consumer.onError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        ReactiveStreamsConsumer consumer;
        LOG.info("Reactive stream '{}' completed", (Object)this.name);
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            consumer = this.consumer;
            this.subscription = null;
        }
        if (consumer != null) {
            consumer.onComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Subscription subscription;
        ReactiveStreamsCamelSubscriber reactiveStreamsCamelSubscriber = this;
        synchronized (reactiveStreamsCamelSubscriber) {
            subscription = this.subscription;
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public long getRequested() {
        return this.requested;
    }

    public long getInflightCount() {
        return this.inflightCount;
    }
}

