/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reactive.tomcat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.Experimental;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed TomcatReactiveExecutor")
@JdkService(value="reactive-executor")
@Experimental
public class TomcatReactiveExecutor
extends ServiceSupport
implements ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatReactiveExecutor.class);
    private static final int MAX_TRACKING_SIZE = 1000;
    private final ConcurrentMap<Thread, Field> threads = new ConcurrentHashMap<Thread, Field>();
    private final TrackingThreadLocal workers = new TrackingThreadLocal();
    private boolean statisticsEnabled;
    private final AtomicInteger createdWorkers = new AtomicInteger();
    private final LongAdder runningWorkers = new LongAdder();
    private final LongAdder pendingTasks = new LongAdder();

    private void clearWorkers() {
        int size = this.threads.size();
        this.threads.forEach((t, f) -> {
            try {
                Method m;
                Object map = ReflectionHelper.getField((Field)f, (Object)t);
                if (map != null && (m = ReflectionHelper.findMethod(map.getClass(), (String)"remove", (Class[])new Class[]{ThreadLocal.class})) != null) {
                    ObjectHelper.invokeMethodSafe((Method)m, (Object)map, (Object[])new Object[]{this});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.threads.clear();
        if (size > 0) {
            LOG.info("Cleared {} ThreadLocals", (Object)size);
        }
    }

    public void schedule(Runnable runnable) {
        ((Worker)this.workers.get()).schedule(runnable, false, false, false);
    }

    public void scheduleMain(Runnable runnable) {
        ((Worker)this.workers.get()).schedule(runnable, true, true, false);
    }

    public void scheduleSync(Runnable runnable) {
        ((Worker)this.workers.get()).schedule(runnable, false, true, true);
    }

    public void scheduleQueue(Runnable runnable) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("ScheduleQueue: {}", (Object)runnable);
        }
        ((Worker)this.workers.get()).queue.add(runnable);
    }

    public boolean executeFromQueue() {
        return ((Worker)this.workers.get()).executeFromQueue();
    }

    @ManagedAttribute(description="Whether statistics is enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Number of created workers")
    public int getCreatedWorkers() {
        return this.createdWorkers.get();
    }

    @ManagedAttribute(description="Number of running workers")
    public int getRunningWorkers() {
        return this.runningWorkers.intValue();
    }

    @ManagedAttribute(description="Number of pending tasks")
    public int getPendingTasks() {
        return this.pendingTasks.intValue();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled() && this.statisticsEnabled) {
            LOG.debug("Stopping TomcatReactiveExecutor [createdWorkers: {}, runningWorkers: {}, pendingTasks: {}]", new Object[]{this.getCreatedWorkers(), this.getRunningWorkers(), this.getPendingTasks()});
        }
    }

    protected void doShutdown() throws Exception {
        this.clearWorkers();
    }

    public String toString() {
        return "camel-reactive-executor-tomcat";
    }

    private static class Worker {
        private final int number;
        private final TomcatReactiveExecutor executor;
        private final boolean stats;
        private volatile Deque<Runnable> queue = new ArrayDeque<Runnable>();
        private volatile Deque<Deque<Runnable>> back;
        private volatile boolean running;

        public Worker(int number, TomcatReactiveExecutor executor) {
            this.number = number;
            this.executor = executor;
            this.stats = executor != null && executor.isStatisticsEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(Runnable runnable, boolean first, boolean main, boolean sync) {
            block22: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Schedule [first={}, main={}, sync={}]: {}", new Object[]{first, main, sync, runnable});
                }
                if (main && !this.queue.isEmpty()) {
                    if (this.back == null) {
                        this.back = new ArrayDeque<Deque<Runnable>>();
                    }
                    this.back.push(this.queue);
                    this.queue = new ArrayDeque<Runnable>();
                }
                if (first) {
                    this.queue.addFirst(runnable);
                    if (this.stats) {
                        this.executor.pendingTasks.increment();
                    }
                } else {
                    this.queue.addLast(runnable);
                    if (this.stats) {
                        this.executor.pendingTasks.increment();
                    }
                }
                if (!this.running || sync) {
                    this.running = true;
                    if (this.stats) {
                        this.executor.runningWorkers.increment();
                    }
                    block5: while (true) {
                        while (true) {
                            Runnable polled;
                            if ((polled = this.queue.pollFirst()) == null) {
                                if (this.back != null && !this.back.isEmpty()) {
                                    this.queue = this.back.pollFirst();
                                    continue;
                                }
                                break block22;
                            }
                            try {
                                if (this.stats) {
                                    this.executor.pendingTasks.decrement();
                                }
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Worker #{} running: {}", (Object)this.number, (Object)polled);
                                }
                                polled.run();
                                continue block5;
                            }
                            catch (Throwable t) {
                                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t.getMessage(), (Object)t);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        this.running = false;
                        if (this.stats) {
                            this.executor.runningWorkers.decrement();
                        }
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Queuing reactive work: {}", (Object)runnable);
                }
            }
        }

        boolean executeFromQueue() {
            Runnable polled;
            Runnable runnable = polled = this.queue != null ? this.queue.pollFirst() : null;
            if (polled == null) {
                return false;
            }
            try {
                if (this.stats) {
                    this.executor.pendingTasks.decrement();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running: {}", (Object)polled);
                }
                polled.run();
            }
            catch (Throwable t) {
                LOG.warn("Error executing reactive work due to {}. This exception is ignored.", (Object)t.getMessage(), (Object)t);
            }
            return true;
        }
    }

    private final class TrackingThreadLocal
    extends ThreadLocal<Worker> {
        private TrackingThreadLocal() {
        }

        @Override
        protected Worker initialValue() {
            try {
                if (TomcatReactiveExecutor.this.threads.size() < 1000) {
                    Thread t = Thread.currentThread();
                    Field f = Thread.class.getDeclaredField("threadLocals");
                    TomcatReactiveExecutor.this.threads.putIfAbsent(t, f);
                }
            }
            catch (Exception t) {
                // empty catch block
            }
            int number = TomcatReactiveExecutor.this.createdWorkers.incrementAndGet();
            return new Worker(number, TomcatReactiveExecutor.this);
        }

        public String toString() {
            return "CamelTomcatReactiveWorker";
        }
    }
}

