/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class RabbitMQEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":exchangeName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "rabbitmq".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "exchangeName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(67);
        props.add("additionalHeaders");
        props.add("additionalProperties");
        props.add("addresses");
        props.add("allowCustomHeaders");
        props.add("allowMessageBodySerialization");
        props.add("allowNullHeaders");
        props.add("args");
        props.add("autoAck");
        props.add("autoDelete");
        props.add("automaticRecoveryEnabled");
        props.add("bridgeEndpoint");
        props.add("bridgeErrorHandler");
        props.add("channelPoolMaxSize");
        props.add("channelPoolMaxWait");
        props.add("clientProperties");
        props.add("concurrentConsumers");
        props.add("connectionFactory");
        props.add("connectionFactoryExceptionHandler");
        props.add("connectionTimeout");
        props.add("consumerTag");
        props.add("deadLetterExchange");
        props.add("deadLetterExchangeType");
        props.add("deadLetterQueue");
        props.add("deadLetterRoutingKey");
        props.add("declare");
        props.add("durable");
        props.add("exceptionHandler");
        props.add("exchangeName");
        props.add("exchangePattern");
        props.add("exchangeType");
        props.add("exclusive");
        props.add("exclusiveConsumer");
        props.add("guaranteedDeliveries");
        props.add("hostname");
        props.add("immediate");
        props.add("lazyStartProducer");
        props.add("mandatory");
        props.add("networkRecoveryInterval");
        props.add("passive");
        props.add("password");
        props.add("portNumber");
        props.add("prefetchCount");
        props.add("prefetchEnabled");
        props.add("prefetchGlobal");
        props.add("prefetchSize");
        props.add("publisherAcknowledgements");
        props.add("publisherAcknowledgementsTimeout");
        props.add("queue");
        props.add("reQueue");
        props.add("recoverFromDeclareException");
        props.add("requestTimeout");
        props.add("requestTimeoutCheckerInterval");
        props.add("requestedChannelMax");
        props.add("requestedFrameMax");
        props.add("requestedHeartbeat");
        props.add("routingKey");
        props.add("skipDlqDeclare");
        props.add("skipExchangeDeclare");
        props.add("skipQueueBind");
        props.add("skipQueueDeclare");
        props.add("sslProtocol");
        props.add("threadPoolSize");
        props.add("topologyRecoveryEnabled");
        props.add("transferException");
        props.add("trustManager");
        props.add("username");
        props.add("vhost");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("arg.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

