/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.python;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.language.python.PythonExpression;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.TypedLanguageSupport;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

@Language(value="python")
public class PythonLanguage
extends TypedLanguageSupport
implements ScriptingLanguage {
    private final Map<String, PyCode> compiledScriptsCache;
    private final PythonInterpreter compiler = new PythonInterpreter();

    private PythonLanguage(Map<String, PyCode> compiledScriptsCache) {
        this.compiledScriptsCache = compiledScriptsCache;
    }

    public PythonLanguage() {
        this(LRUCacheFactory.newLRUSoftCache((int)16, (int)1000, (boolean)true));
    }

    public Predicate createPredicate(String expression) {
        return this.createPythonExpression(expression, Boolean.class);
    }

    public Expression createExpression(String expression) {
        return this.createPythonExpression(expression, Object.class);
    }

    private PythonExpression createPythonExpression(String expression, Class<?> type) {
        return new PythonExpression(this.loadResource(expression), type);
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        PyCode code = this.getCompiledScriptFromCache(script = this.loadResource(script));
        if (code == null) {
            try {
                code = this.compiler.compile(script);
                this.addCompiledScriptToCache(script, code);
            }
            catch (Exception e) {
                throw new ExpressionIllegalSyntaxException(script, (Throwable)e);
            }
        }
        try {
            PyObject out;
            if (bindings != null) {
                bindings.forEach((arg_0, arg_1) -> ((PythonInterpreter)this.compiler).set(arg_0, arg_1));
            }
            if ((out = this.compiler.eval((PyObject)code)) != null) {
                String value = out.toString();
                Object object = this.getCamelContext().getTypeConverter().convertTo(resultType, (Object)value);
                return (T)object;
            }
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(script, (Throwable)e);
        }
        finally {
            this.compiler.cleanup();
        }
        return null;
    }

    private void addCompiledScriptToCache(String script, PyCode compiledScript) {
        this.compiledScriptsCache.put(script, compiledScript);
    }

    private PyCode getCompiledScriptFromCache(String script) {
        return this.compiledScriptsCache.get(script);
    }

    public static class Builder {
        private final Map<String, PyCode> cache = new HashMap<String, PyCode>();

        public void addScript(String script, PyCode compiledScript) {
            this.cache.put(script, compiledScript);
        }

        public PythonLanguage build() {
            return new PythonLanguage(Collections.unmodifiableMap(this.cache));
        }
    }
}

