/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.scraper.config.JobConfigurationImpl;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.config.triggeredscraper.ScraperConfigurationTriggeredImpl;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollectorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4XConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XConsumer.class);
    private final Map<String, String> tags;
    private final String trigger;
    private final Plc4XEndpoint plc4XEndpoint;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> future;

    public Plc4XConsumer(Plc4XEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.plc4XEndpoint = endpoint;
        this.tags = endpoint.getTags();
        this.trigger = endpoint.getTrigger();
    }

    public String toString() {
        return "Plc4XConsumer[" + this.plc4XEndpoint + "]";
    }

    public Endpoint getEndpoint() {
        return this.plc4XEndpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            this.plc4XEndpoint.setupConnection();
        }
        catch (PlcConnectionException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.error("Connection setup failed, stopping Consumer", (Throwable)e);
            } else {
                LOGGER.error("Connection setup failed, stopping Consumer");
            }
            this.doStop();
        }
        if (this.trigger == null) {
            this.startUnTriggered();
        } else {
            this.startTriggered();
        }
    }

    private void startUnTriggered() {
        try {
            this.plc4XEndpoint.reconnectIfNeeded();
        }
        catch (PlcConnectionException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.warn("Unable to reconnect, skipping request", (Throwable)e);
            } else {
                LOGGER.warn("Unable to reconnect, skipping request");
            }
            return;
        }
        PlcReadRequest request = this.plc4XEndpoint.buildPlcReadRequest();
        this.future = this.executorService.schedule(() -> request.execute().thenAccept(response -> {
            try {
                Exchange exchange = this.plc4XEndpoint.createExchange();
                HashMap<String, Object> rsp = new HashMap<String, Object>();
                for (String field : response.getTagNames()) {
                    rsp.put(field, response.getObject(field));
                }
                exchange.getIn().setBody(rsp);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException((Throwable)e);
            }
        }), 500L, TimeUnit.MILLISECONDS);
    }

    private void startTriggered() throws ScraperException {
        ScraperConfigurationTriggeredImpl configuration = this.getScraperConfig(this.tags);
        TriggerCollectorImpl collector = new TriggerCollectorImpl((PlcConnectionManager)this.plc4XEndpoint.getPlcDriverManager());
        TriggeredScraperImpl scraper = new TriggeredScraperImpl((ScraperConfiguration)configuration, (job, alias, response) -> {
            try {
                this.plc4XEndpoint.reconnectIfNeeded();
                Exchange exchange = this.plc4XEndpoint.createExchange();
                exchange.getIn().setBody((Object)response);
                this.getProcessor().process(exchange);
            }
            catch (PlcConnectionException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.warn("Unable to reconnect, skipping request", (Throwable)e);
                } else {
                    LOGGER.warn("Unable to reconnect, skipping request");
                }
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException((Throwable)e);
            }
        }, (TriggerCollector)collector);
        scraper.start();
        collector.start();
    }

    private ScraperConfigurationTriggeredImpl getScraperConfig(Map<String, String> tagList) {
        String config = "(TRIGGER_VAR," + this.plc4XEndpoint.getPeriod() + ",(" + this.plc4XEndpoint.getTrigger() + ")==(true))";
        List<JobConfigurationImpl> job = Collections.singletonList(new JobConfigurationImpl("PLC4X-Camel", config, Integer.valueOf(0), Collections.singletonList("PLC"), tagList));
        Map<String, String> source = Collections.singletonMap("PLC", this.plc4XEndpoint.getUri());
        return new ScraperConfigurationTriggeredImpl(source, job);
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
        }
        super.doStop();
    }
}

