/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4XProducer
extends DefaultAsyncProducer {
    protected AtomicInteger openRequests;
    private final Logger log = LoggerFactory.getLogger(Plc4XProducer.class);
    private final Plc4XEndpoint plc4XEndpoint;

    public Plc4XProducer(Plc4XEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.plc4XEndpoint = endpoint;
        this.openRequests = new AtomicInteger();
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            this.plc4XEndpoint.setupConnection();
        }
        catch (PlcConnectionException e) {
            if (this.log.isTraceEnabled()) {
                this.log.error("Connection setup failed, stopping producer", (Throwable)e);
            } else {
                this.log.error("Connection setup failed, stopping producer");
            }
            this.doStop();
        }
        if (!this.plc4XEndpoint.canWrite()) {
            throw new PlcException("This connection (" + this.plc4XEndpoint.getUri() + ") doesn't support writing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        try {
            this.plc4XEndpoint.reconnectIfNeeded();
        }
        catch (PlcConnectionException e) {
            if (this.log.isTraceEnabled()) {
                this.log.warn("Unable to reconnect, skipping request", (Throwable)e);
            } else {
                this.log.warn("Unable to reconnect, skipping request");
            }
            return;
        }
        Message in = exchange.getIn();
        Object body = in.getBody();
        if (!(body instanceof Map)) {
            throw new PlcInvalidFieldException("The body must contain a Map<String,Map<String,Object>");
        }
        Map tags = (Map)body;
        PlcWriteRequest plcWriteRequest = this.plc4XEndpoint.buildPlcWriteRequest(tags);
        CompletableFuture completableFuture = plcWriteRequest.execute();
        int currentlyOpenRequests = this.openRequests.incrementAndGet();
        try {
            this.log.debug("Currently open requests including {}:{}", (Object)exchange, (Object)currentlyOpenRequests);
            Object plcWriteResponse = completableFuture.get(5000L, TimeUnit.MILLISECONDS);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getMessage();
                out.copyFrom(exchange.getIn());
                out.setBody(plcWriteResponse);
            } else {
                in.setBody(plcWriteResponse);
            }
        }
        finally {
            int openRequestsAfterFinish = this.openRequests.decrementAndGet();
            this.log.trace("Open Requests after {}:{}", (Object)exchange, (Object)openRequestsAfterFinish);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
            Message out = exchange.getMessage();
            out.copyFrom(exchange.getIn());
        }
        catch (Exception e) {
            exchange.setMessage(null);
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected void doStop() throws Exception {
        super.doStop();
        int openRequestsAtStop = this.openRequests.get();
        this.log.debug("Stopping with {} open requests", (Object)openRequestsAtStop);
        if (openRequestsAtStop > 0) {
            this.log.warn("There are still {} open requests", (Object)openRequestsAtStop);
        }
    }
}

