/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.scraper.config.JobConfigurationImpl;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.config.triggeredscraper.ScraperConfigurationTriggeredImpl;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollectorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4XConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XConsumer.class);
    private PlcConnection plcConnection;
    private final Map<String, Object> tags;
    private final String trigger;
    private final Plc4XEndpoint plc4XEndpoint;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> future;

    public Plc4XConsumer(Plc4XEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.plc4XEndpoint = endpoint;
        this.tags = endpoint.getTags();
        this.trigger = endpoint.getTrigger();
    }

    public String toString() {
        return "Plc4XConsumer[" + this.plc4XEndpoint + "]";
    }

    public Endpoint getEndpoint() {
        return this.plc4XEndpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.plcConnection = this.plc4XEndpoint.getConnection();
        if (!this.plcConnection.isConnected()) {
            this.plc4XEndpoint.reconnect();
        }
        if (this.trigger == null) {
            this.startUnTriggered();
        } else {
            this.startTriggered();
        }
    }

    private void startUnTriggered() {
        PlcReadRequest.Builder builder = this.plcConnection.readRequestBuilder();
        if (this.tags != null) {
            for (Map.Entry<String, Object> tag : this.tags.entrySet()) {
                try {
                    builder.addItem(tag.getKey(), (String)tag.getValue());
                }
                catch (PlcIncompatibleDatatypeException e) {
                    LOGGER.error("For consumer, please use Map<String,String>, currently using {}", (Object)this.tags.getClass().getSimpleName());
                }
            }
        }
        PlcReadRequest request = builder.build();
        this.future = this.executorService.schedule(() -> request.execute().thenAccept(response -> {
            try {
                Exchange exchange = this.plc4XEndpoint.createExchange();
                HashMap<String, Object> rsp = new HashMap<String, Object>();
                for (String field : response.getFieldNames()) {
                    rsp.put(field, response.getObject(field));
                }
                exchange.getIn().setBody(rsp);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException((Throwable)e);
            }
        }), 500L, TimeUnit.MILLISECONDS);
    }

    private void startTriggered() throws ScraperException {
        ScraperConfigurationTriggeredImpl configuration = this.getScraperConfig(this.validateTags());
        TriggerCollectorImpl collector = new TriggerCollectorImpl(this.plc4XEndpoint.getPlcDriverManager());
        TriggeredScraperImpl scraper = new TriggeredScraperImpl((ScraperConfiguration)configuration, (job, alias, response) -> {
            try {
                Exchange exchange = this.plc4XEndpoint.createExchange();
                exchange.getIn().setBody((Object)response);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException((Throwable)e);
            }
        }, (TriggerCollector)collector);
        scraper.start();
        collector.start();
    }

    private Map<String, String> validateTags() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.tags != null) {
            for (Map.Entry<String, Object> tag : this.tags.entrySet()) {
                if (!(tag.getValue() instanceof String)) continue;
                map.put(tag.getKey(), (String)tag.getValue());
            }
            if (map.size() != this.tags.size()) {
                LOGGER.error("At least one entry does not match the format : Map.Entry<String,String> ");
                return null;
            }
        }
        return map;
    }

    private ScraperConfigurationTriggeredImpl getScraperConfig(Map<String, String> tagList) {
        String config = "(TRIGGER_VAR," + this.plc4XEndpoint.getPeriod() + ",(" + this.plc4XEndpoint.getTrigger() + ")==(true))";
        List<JobConfigurationImpl> job = Collections.singletonList(new JobConfigurationImpl("PLC4X-Camel", config, Integer.valueOf(0), Collections.singletonList("PLC"), tagList));
        Map<String, String> source = Collections.singletonMap("PLC", this.plc4XEndpoint.getUri());
        return new ScraperConfigurationTriggeredImpl(source, job);
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
        }
        super.doStop();
    }
}

