/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4XProducer
extends DefaultAsyncProducer {
    private final Logger log = LoggerFactory.getLogger(Plc4XProducer.class);
    private PlcConnection plcConnection;
    private AtomicInteger openRequests;
    private final Plc4XEndpoint plc4XEndpoint;

    public Plc4XProducer(Plc4XEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.plc4XEndpoint = endpoint;
        this.openRequests = new AtomicInteger();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.plcConnection = this.plc4XEndpoint.getConnection();
        if (!this.plcConnection.isConnected()) {
            this.plc4XEndpoint.reconnect();
        }
        if (!this.plcConnection.getMetadata().canWrite()) {
            throw new PlcException("This connection (" + this.plc4XEndpoint.getUri() + ") doesn't support writing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Object body = in.getBody();
        PlcWriteRequest.Builder builder = this.plcConnection.writeRequestBuilder();
        if (body instanceof Map) {
            Map tags = (Map)body;
            for (Map.Entry entry : tags.entrySet()) {
                String name = (String)entry.getKey();
                String query = (String)((Map)entry.getValue()).keySet().iterator().next();
                Object value = ((Map)entry.getValue()).get(query);
                builder.addItem(name, query, new Object[]{value});
            }
        } else {
            throw new PlcInvalidFieldException("The body must contain a Map<String,Map<String,Object>");
        }
        CompletableFuture completableFuture = builder.build().execute();
        int currentlyOpenRequests = this.openRequests.incrementAndGet();
        try {
            this.log.debug("Currently open requests including {}:{}", (Object)exchange, (Object)currentlyOpenRequests);
            Object plcWriteResponse = completableFuture.get(5000L, TimeUnit.MILLISECONDS);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getMessage();
                out.copyFrom(exchange.getIn());
                out.setBody(plcWriteResponse);
            } else {
                in.setBody(plcWriteResponse);
            }
        }
        finally {
            int openRequestsAfterFinish = this.openRequests.decrementAndGet();
            this.log.trace("Open Requests after {}:{}", (Object)exchange, (Object)openRequestsAfterFinish);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
            Message out = exchange.getMessage();
            out.copyFrom(exchange.getIn());
        }
        catch (Exception e) {
            exchange.setMessage(null);
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected void doStop() throws Exception {
        super.doStop();
        int openRequestsAtStop = this.openRequests.get();
        this.log.debug("Stopping with {} open requests", (Object)openRequestsAtStop);
        if (openRequestsAtStop > 0) {
            this.log.warn("There are still {} open requests", (Object)openRequestsAtStop);
        }
    }
}

