/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.Map;
import java.util.Objects;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.plc4x.Plc4XConsumer;
import org.apache.camel.component.plc4x.Plc4XProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcDriverManager;

@UriEndpoint(scheme="plc4x", firstVersion="3.20.0", title="PLC4X", syntax="plc4x:driver", category={Category.IOT})
public class Plc4XEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true, description="PLC4X connection string for the connection to the target")
    private String driver;
    @UriParam
    @Metadata(description="The tags to read as Map<String,String> containing the tag name associated to its query")
    private Map<String, Object> tags;
    @UriParam
    @Metadata(label="consumer", description="Query to a trigger. On a rising edge of the trigger, the tags will be read once")
    private String trigger;
    @UriParam
    @Metadata(label="consumer", description="Interval on which the Trigger should be checked")
    private int period;
    private PlcDriverManager plcDriverManager = new PlcDriverManager();
    private PlcConnection connection;
    private String uri;

    public Plc4XEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.uri = endpointUri.replaceFirst("plc4x:/?/?", "");
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
        this.plcDriverManager = new PooledPlcDriverManager();
    }

    public PlcConnection getConnection() throws PlcConnectionException {
        if (this.connection == null) {
            this.connection = this.plcDriverManager.getConnection(this.uri);
        }
        return this.connection;
    }

    public void reconnect() throws PlcConnectionException {
        this.connection.connect();
    }

    public Producer createProducer() {
        return new Plc4XProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Plc4XConsumer consumer = new Plc4XConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PlcDriverManager getPlcDriverManager() {
        return this.plcDriverManager;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plc4XEndpoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Plc4XEndpoint that = (Plc4XEndpoint)((Object)o);
        return Objects.equals(this.getDriver(), that.getDriver()) && Objects.equals(this.getTags(), that.getTags()) && Objects.equals(this.getPlcDriverManager(), that.getPlcDriverManager());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDriver(), this.getTags(), this.getPlcDriverManager());
    }

    public void doStop() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.close();
        }
    }
}

