/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.Set;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.platform.http.DefaultPlatformHttpConsumer;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.cookie.CookieConfiguration;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumer;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.http.base.HttpHeaderFilterStrategy;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.MimeTypeHelper;

@UriEndpoint(firstVersion="3.0.0", scheme="platform-http", title="Platform HTTP", syntax="platform-http:path", category={Category.HTTP}, consumerOnly=true)
@Metadata(annotations={"protocol=http"})
public class PlatformHttpEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware,
EndpointServiceLocation {
    private static final String PROXY_PATH = "proxy";
    private static final Set<String> COMMON_HTTP_REQUEST_HEADERS = Set.of("A-IM", "Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Datetime", "Access-Control-Request-Method", "Access-Control-Request-Headers", "Authorization", "Cookie", "Expect", "Forwarded", "From", "Host", "HTTP2-Settings", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Origin", "Prefer", "Proxy-Authorization", "Range", "Referer", "TE", "User-Agent");
    @UriPath(description="The path under which this endpoint serves the HTTP requests, for proxy use 'proxy'")
    @Metadata(required=true)
    private final String path;
    @UriParam(label="consumer", defaultValue="false", description="Whether or not the consumer should try to find a target consumer by matching the URI prefix if no exact match is found.")
    private boolean matchOnUriPrefix;
    @UriParam(label="consumer", description="A comma separated list of HTTP methods to serve, e.g. GET,POST . If no methods are specified, all methods will be served.")
    private String httpMethodRestrict;
    @UriParam(label="consumer", description="The content type this endpoint accepts as an input, such as application/xml or application/json. <code>null</code> or <code>&#42;/&#42;</code> mean no restriction.")
    private String consumes;
    @UriParam(label="consumer", description="The content type this endpoint produces, such as application/xml or application/json.")
    private String produces;
    @UriParam(label="consumer", defaultValue="true", description="If enabled and an Exchange failed processing on the consumer side the response's body won't contain the exception's stack trace.")
    private boolean muteException = true;
    @UriParam(label="consumer,advanced", description="A comma or whitespace separated list of file extensions. Uploads having these extensions will be stored locally. Null value or asterisk (*) will allow all files.")
    private String fileNameExtWhitelist;
    @UriParam(label="advanced", description="An HTTP Server engine implementation to serve the requests of this endpoint.")
    private PlatformHttpEngine platformHttpEngine;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter headers to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    @UriParam(label="advanced,consumer", description="Whether to use streaming for large requests and responses (currently only supported by camel-platform-http-vertx)")
    private boolean useStreaming;
    @UriParam(label="advanced,consumer", description="The properties set on a Cookies when a Cookie is added via the Cookie Handler (currently only supported by camel-platform-http-vertx)")
    private CookieConfiguration cookieConfiguration = new CookieConfiguration();
    @UriParam(label="advanced,consumer", description="Whether to enable the Cookie Handler that allows Cookie addition, expiry, and retrieval (currently only supported by camel-platform-http-vertx)")
    private boolean useCookieHandler;
    @UriParam(label="advanced,consumer", defaultValue="false", description="Whether to include HTTP request headers (Accept, User-Agent, etc.) into HTTP response produced by this endpoint.")
    private boolean returnHttpRequestHeaders;
    @UriParam(label="advanced,consumer", defaultValue="false", description="When Camel is complete processing the message, and the HTTP server is writing response. This option controls whether Camel should catch any failure during writing response and store this on the Exchange, which allows onCompletion/UnitOfWork to regard the Exchange as failed and have access to the caused exception from the HTTP server.")
    private boolean handleWriteResponseError;
    @UriParam(label="advanced,consumer", defaultValue="true", description="Whether to populate the message Body with a Map containing application/x-www-form-urlencoded form properties.")
    private boolean populateBodyWithForm = true;
    @UriParam(label="advanced,consumer", defaultValue="true", description="Whether to use BodyHandler for the request. If set to false then the request will no be read and parsed.")
    private boolean useBodyHandler = true;
    @UriParam(label="advanced,consumer", description="The period in milliseconds after which the request should be timed out.")
    private long requestTimeout;

    public PlatformHttpEndpoint(String uri, String remaining, Component component) {
        super(uri, component);
        this.path = remaining;
    }

    public PlatformHttpComponent getComponent() {
        return (PlatformHttpComponent)super.getComponent();
    }

    public String getServiceUrl() {
        Object server = "http://0.0.0.0";
        int port = this.getOrCreateEngine().getServerPort();
        if (port > 0) {
            server = (String)server + ":" + port;
        }
        return server;
    }

    public String getServiceProtocol() {
        return "http";
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer is not supported");
    }

    public DefaultPlatformHttpConsumer createConsumer(Processor processor) throws Exception {
        DefaultPlatformHttpConsumer consumer = new DefaultPlatformHttpConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected PlatformHttpConsumer createPlatformHttpConsumer(Processor processor) throws Exception {
        PlatformHttpConsumer consumer = this.getOrCreateEngine().createConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (!this.returnHttpRequestHeaders) {
            return this.enhanceHeaderFilterStrategyToSkipHttpRequestHeaders(this.headerFilterStrategy);
        }
        return this.headerFilterStrategy;
    }

    private HeaderFilterStrategy enhanceHeaderFilterStrategyToSkipHttpRequestHeaders(final HeaderFilterStrategy headerFilterStrategy) {
        return new HeaderFilterStrategy(){

            public boolean applyFilterToCamelHeaders(String headerName, Object headerValue, Exchange exchange) {
                if (COMMON_HTTP_REQUEST_HEADERS.contains(headerName)) {
                    return true;
                }
                return headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
            }

            public boolean applyFilterToExternalHeaders(String headerName, Object headerValue, Exchange exchange) {
                return headerFilterStrategy.applyFilterToExternalHeaders(headerName, headerValue, exchange);
            }
        };
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public String getPath() {
        return this.isHttpProxy() ? "/" : this.path;
    }

    public PlatformHttpEngine getPlatformHttpEngine() {
        return this.platformHttpEngine;
    }

    public void setPlatformHttpEngine(PlatformHttpEngine platformHttpEngine) {
        this.platformHttpEngine = platformHttpEngine;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public String getFileNameExtWhitelist() {
        return this.fileNameExtWhitelist;
    }

    public void setFileNameExtWhitelist(String fileNameExtWhitelist) {
        this.fileNameExtWhitelist = fileNameExtWhitelist;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = MimeTypeHelper.sanitizeMimeType((String)consumes);
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = MimeTypeHelper.sanitizeMimeType((String)produces);
    }

    public boolean isMuteException() {
        return this.muteException;
    }

    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    public CookieConfiguration getCookieConfiguration() {
        return this.cookieConfiguration;
    }

    public void setCookieConfiguration(CookieConfiguration cookieConfiguration) {
        this.cookieConfiguration = cookieConfiguration;
    }

    public boolean isUseCookieHandler() {
        return this.useCookieHandler;
    }

    public void setUseCookieHandler(boolean useCookieHandler) {
        this.useCookieHandler = useCookieHandler;
    }

    PlatformHttpEngine getOrCreateEngine() {
        return this.platformHttpEngine != null ? this.platformHttpEngine : this.getComponent().getOrCreateEngine();
    }

    public boolean isHttpProxy() {
        return this.path.startsWith(PROXY_PATH);
    }

    public boolean isReturnHttpRequestHeaders() {
        return this.returnHttpRequestHeaders;
    }

    public void setReturnHttpRequestHeaders(boolean returnHttpRequestHeaders) {
        this.returnHttpRequestHeaders = returnHttpRequestHeaders;
    }

    public boolean isHandleWriteResponseError() {
        return this.handleWriteResponseError;
    }

    public void setHandleWriteResponseError(boolean handleWriteResponseError) {
        this.handleWriteResponseError = handleWriteResponseError;
    }

    public boolean isPopulateBodyWithForm() {
        return this.populateBodyWithForm;
    }

    public void setPopulateBodyWithForm(boolean populateBodyWithForm) {
        this.populateBodyWithForm = populateBodyWithForm;
    }

    public boolean isUseBodyHandler() {
        return this.useBodyHandler;
    }

    public void setUseBodyHandler(boolean useBodyHandler) {
        this.useBodyHandler = useBodyHandler;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }
}

