/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx.auth;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationConfig {
    public static final String DEFAULT_VERTX_PROPERTIES_FILE = "camel-platform-http-vertx-auth.properties";
    private boolean authenticationEnabled;
    private final List<AuthenticationConfigEntry> entries;

    public AuthenticationConfig() {
        AuthenticationConfigEntry defaultAuthConfig = new AuthenticationConfigEntry();
        defaultAuthConfig.setPath("/*");
        defaultAuthConfig.setAuthenticationProviderFactory(vertx -> PropertyFileAuthentication.create((Vertx)vertx, (String)DEFAULT_VERTX_PROPERTIES_FILE));
        defaultAuthConfig.setAuthenticationHandlerFactory(BasicAuthHandler::create);
        this.entries = new ArrayList<AuthenticationConfigEntry>();
        this.entries.add(defaultAuthConfig);
    }

    public AuthenticationConfig(List<AuthenticationConfigEntry> authenticationConfigEntries) {
        this.entries = authenticationConfigEntries;
    }

    public List<AuthenticationConfigEntry> getEntries() {
        return this.entries;
    }

    public boolean isEnabled() {
        return this.authenticationEnabled;
    }

    public void setEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public static class AuthenticationConfigEntry {
        private String path;
        private AuthenticationProviderFactory authenticationProviderFactory;
        private AuthenticationHandlerFactory authenticationHandlerFactory;

        public Handler<RoutingContext> createAuthenticationHandler(Vertx vertx) {
            AuthenticationProvider provider = this.authenticationProviderFactory.createAuthenticationProvider(vertx);
            return this.authenticationHandlerFactory.createAuthenticationHandler(provider);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public AuthenticationProviderFactory getAuthenticationProviderFactory() {
            return this.authenticationProviderFactory;
        }

        public void setAuthenticationProviderFactory(AuthenticationProviderFactory authenticationProviderFactory) {
            this.authenticationProviderFactory = authenticationProviderFactory;
        }

        public AuthenticationHandlerFactory getAuthenticationHandlerFactory() {
            return this.authenticationHandlerFactory;
        }

        public void setAuthenticationHandlerFactory(AuthenticationHandlerFactory authenticationHandlerFactory) {
            this.authenticationHandlerFactory = authenticationHandlerFactory;
        }
    }

    public static interface AuthenticationProviderFactory {
        public AuthenticationProvider createAuthenticationProvider(Vertx var1);
    }

    public static interface AuthenticationHandlerFactory {
        public AuthenticationHandler createAuthenticationHandler(AuthenticationProvider var1);
    }
}

