/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import java.util.Map;
import org.apache.camel.component.platform.http.main.MainHttpServer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="main-http-server", displayName="Main HTTP Server", description="Camel Main HTTP Server")
public class MainHttpServerDevConsole
extends AbstractDevConsole {
    public MainHttpServerDevConsole() {
        super("camel", "main-http-server", "Main HTTP Server", "Camel Main HTTP Server");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        MainHttpServer server = (MainHttpServer)((Object)this.getCamelContext().hasService(MainHttpServer.class));
        if (server != null) {
            String p = server.getPath();
            if (p != null && p.startsWith("/")) {
                p = p.substring(1);
            }
            String url = String.format("%s:%s%s", server.getHost(), server.getPort(), p);
            sb.append(String.format("    Server: http://%s", url));
            if (server.getMaxBodySize() != null) {
                sb.append(String.format("\n    Max Body Size: %s", server.getMaxBodySize()));
            }
            sb.append(String.format("\n    File Upload Enabled: %b", server.isFileUploadEnabled()));
            sb.append(String.format("\n    File Upload Dir: %s", server.getFileUploadDirectory()));
            sb.append(String.format("\n    Use Global SSL ContextParameters: %s", server.isUseGlobalSslContextParameters()));
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        MainHttpServer server = (MainHttpServer)((Object)this.getCamelContext().hasService(MainHttpServer.class));
        if (server != null) {
            root.put((Object)"host", (Object)server.getHost());
            root.put((Object)"port", (Object)server.getPort());
            root.put((Object)"path", (Object)server.getPath());
            if (server.getMaxBodySize() != null) {
                root.put((Object)"maxBodySize", (Object)server.getMaxBodySize());
            }
            root.put((Object)"fileUploadEnabled", (Object)server.isFileUploadEnabled());
            if (server.getFileUploadDirectory() != null) {
                root.put((Object)"fileUploadDirectory", (Object)server.getFileUploadDirectory());
            }
            root.put((Object)"useGlobalSslContextParameters", (Object)server.isUseGlobalSslContextParameters());
        }
        return root;
    }
}

