/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pinecone;

import io.pinecone.clients.Index;
import io.pinecone.clients.Pinecone;
import io.pinecone.proto.UpsertResponse;
import io.pinecone.unsigned_indices_model.QueryResponseWithUnsignedIndices;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.pinecone.PineconeVectorDbAction;
import org.apache.camel.component.pinecone.PineconeVectorDbEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.openapitools.client.model.CollectionModel;
import org.openapitools.client.model.IndexModel;

public class PineconeVectorDbProducer
extends DefaultProducer {
    private Pinecone client;
    private ExecutorService executor;

    public PineconeVectorDbProducer(PineconeVectorDbEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public PineconeVectorDbEndpoint getEndpoint() {
        return (PineconeVectorDbEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client = this.getEndpoint().getClient();
    }

    public void process(Exchange exchange) {
        Message in = exchange.getMessage();
        PineconeVectorDbAction action = (PineconeVectorDbAction)((Object)in.getHeader("CamelPineconeAction", PineconeVectorDbAction.class));
        try {
            if (action == null) {
                throw new NoSuchHeaderException("The action is a required header", exchange, "CamelPineconeAction");
            }
            switch (action) {
                case CREATE_COLLECTION: {
                    this.createCollection(exchange);
                    break;
                }
                case CREATE_SERVERLESS_INDEX: {
                    this.createServerlessIndex(exchange);
                    break;
                }
                case CREATE_POD_INDEX: {
                    this.createPodIndex(exchange);
                    break;
                }
                case UPSERT: {
                    this.upsert(exchange);
                    break;
                }
                case DELETE_INDEX: {
                    this.deleteIndex(exchange);
                    break;
                }
                case DELETE_COLLECTION: {
                    this.deleteCollection(exchange);
                    break;
                }
                case QUERY: {
                    this.query(exchange);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported action: " + action.name());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    private void createCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String collectionName = (String)in.getHeader("CamelPineconeCollectionName", String.class);
        String indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        CollectionModel result = this.client.createCollection(collectionName, indexName);
        this.populateCollectionResponse(result, exchange);
    }

    private void createServerlessIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        String collectionSimilarityMetricName = (String)in.getHeader("CamelPineconeCollectionSimilarityMetric", String.class);
        int collectionDimension = (Integer)in.getHeader("CamelPineconeCollectionDimension", Integer.class);
        String collectionCloudName = (String)in.getHeader("CamelPineconeCollectionCloud", String.class);
        String collectionCloudRegionName = (String)in.getHeader("CamelPineconeCollectionCloudRegion", String.class);
        IndexModel result = this.client.createServerlessIndex(indexName, collectionSimilarityMetricName, collectionDimension, collectionCloudName, collectionCloudRegionName);
        this.populateIndexResponse(result, exchange);
    }

    private void createPodIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        String collectionSimilarityMetricName = (String)in.getHeader("CamelPineconeCollectionSimilarityMetric", String.class);
        int collectionDimension = (Integer)in.getHeader("CamelPineconeCollectionDimension", Integer.class);
        String indexPodType = (String)in.getHeader("CamelPineconeIndexPodType", String.class);
        String indexPodEnv = (String)in.getHeader("CamelPineconeIndexPodEnvironment", String.class);
        IndexModel result = this.client.createPodsIndex(indexName, Integer.valueOf(collectionDimension), indexPodEnv, indexPodType, collectionSimilarityMetricName);
        this.populateIndexResponse(result, exchange);
    }

    private void upsert(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        String indexId = (String)in.getHeader("CamelPineconeIndexId", String.class);
        Index index = this.client.getIndexConnection(indexName);
        UpsertResponse result = index.upsert(indexId, elements);
        this.populateUpsertResponse(result, exchange);
    }

    private void deleteIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        this.client.deleteIndex(indexName);
    }

    private void deleteCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String collectionName = (String)in.getHeader("CamelPineconeCollectionName", String.class);
        this.client.deleteCollection(collectionName);
    }

    private void query(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        int topK = (Integer)in.getHeader("CamelPineconeQueryTopK", Integer.class);
        Index index = this.client.getIndexConnection(indexName);
        QueryResponseWithUnsignedIndices result = index.queryByVector(topK, elements);
        this.populateQueryResponse(result, exchange);
    }

    private CamelContext getCamelContext() {
        return this.getEndpoint().getCamelContext();
    }

    private void populateCollectionResponse(CollectionModel r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateIndexResponse(IndexModel r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateUpsertResponse(UpsertResponse r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateQueryResponse(QueryResponseWithUnsignedIndices r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }
}

