/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf.converter;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.pdf.converter.PdfConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.pdfbox.pdmodel.PDDocument;

@DeferredContextBinding
public final class PdfConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile PdfConverter pdfConverter;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        PdfConverterLoader.addTypeConverter(registry, PDDocument.class, byte[].class, false, (type, exchange, value) -> this.getPdfConverter().convertToPDF((byte[])value));
        PdfConverterLoader.addTypeConverter(registry, PDDocument.class, InputStream.class, false, (type, exchange, value) -> this.getPdfConverter().toPDDocument((InputStream)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private PdfConverter getPdfConverter() {
        if (this.pdfConverter == null) {
            this.pdfConverter = new PdfConverter();
            CamelContextAware.trySetCamelContext((Object)this.pdfConverter, (CamelContext)this.camelContext);
        }
        return this.pdfConverter;
    }
}

