/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.parquet.avro;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.camel.RuntimeCamelException;
import org.apache.parquet.hadoop.ParquetReader;

public class ParquetIterator<T>
implements Iterator<T>,
Closeable {
    private final ParquetReader<T> reader;
    private T current;

    public ParquetIterator(ParquetReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            this.current = this.getNext();
        }
        return this.current != null;
    }

    @Override
    public T next() {
        T next = this.current;
        this.current = null;
        if (next == null && (next = this.getNext()) == null) {
            throw new NoSuchElementException("No more items available");
        }
        return next;
    }

    private T getNext() {
        try {
            return (T)this.reader.read();
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

