/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.parquet.avro;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetInputStream
implements InputFile {
    private final String streamId;
    private final byte[] data;

    public ParquetInputStream(String streamId, byte[] data) {
        this.streamId = streamId;
        this.data = data;
    }

    public long getLength() throws IOException {
        return this.data.length;
    }

    public SeekableInputStream newStream() throws IOException {
        return new DelegatingSeekableInputStream(new SeekableByteArrayInputStream(this.data)){

            public void seek(long newPos) throws IOException {
                ((SeekableByteArrayInputStream)this.getStream()).setPos((int)newPos);
            }

            public long getPos() throws IOException {
                return ((SeekableByteArrayInputStream)this.getStream()).getPos();
            }
        };
    }

    public String toString() {
        return "ParquetInputStream[" + this.streamId + "]";
    }

    private static class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

