/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho.mqtt5;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5Endpoint;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5Message;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PahoMqtt5Consumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PahoMqtt5Consumer.class);
    private volatile MqttClient client;
    private volatile String clientId;
    private volatile boolean stopClient;
    private volatile MqttConnectionOptions connectionOptions;

    public PahoMqtt5Consumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connectionOptions = this.getEndpoint().createMqttConnectionOptions();
        if (this.client == null) {
            this.clientId = this.getEndpoint().getConfiguration().getClientId();
            if (this.clientId == null) {
                this.clientId = PahoMqtt5Endpoint.generateClientId();
            }
            this.stopClient = true;
            this.client = new MqttClient(this.getEndpoint().getConfiguration().getBrokerUrl(), this.clientId, PahoMqtt5Endpoint.createMqttClientPersistence(this.getEndpoint().getConfiguration()));
            LOG.debug("Connecting client: {} to broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.connect(this.connectionOptions);
        }
        this.client.setCallback(new MqttCallback(){

            public void connectComplete(boolean reconnect, String serverURI) {
                if (reconnect) {
                    try {
                        PahoMqtt5Consumer.this.client.subscribe(PahoMqtt5Consumer.this.getEndpoint().getTopic(), PahoMqtt5Consumer.this.getEndpoint().getConfiguration().getQos());
                    }
                    catch (MqttException e) {
                        LOG.error("MQTT resubscribe failed {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }

            public void authPacketArrived(int reasonCode, MqttProperties properties) {
                LOG.debug("Auth packet arrived {} {}", (Object)reasonCode, (Object)properties);
            }

            public void disconnected(MqttDisconnectResponse response) {
                LOG.debug("MQTT broker disconnected due {}", (Object)response.getReasonString(), (Object)response.getException());
            }

            public void mqttErrorOccurred(MqttException exception) {
                LOG.debug("Error occurred {}", (Object)exception.getMessage(), (Object)exception);
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                LOG.debug("Message arrived on topic: {} -> {}", (Object)topic, (Object)message);
                Exchange exchange = PahoMqtt5Consumer.this.createExchange(message, topic);
                AsyncCallback cb = PahoMqtt5Consumer.this.defaultConsumerCallback(exchange, true);
                PahoMqtt5Consumer.this.getAsyncProcessor().process(exchange, cb);
            }

            public void deliveryComplete(IMqttToken token) {
                LOG.debug("Delivery complete. Token: {}", (Object)token);
            }
        });
        LOG.debug("Subscribing client: {} to topic: {}", (Object)this.clientId, (Object)this.getEndpoint().getTopic());
        this.client.subscribe(this.getEndpoint().getTopic(), this.getEndpoint().getConfiguration().getQos());
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.stopClient && this.client != null && this.client.isConnected()) {
            String topic = this.getEndpoint().getTopic();
            if (this.getEndpoint().getConfiguration().isCleanStart()) {
                LOG.debug("Unsubscribing client: {} from topic: {}", (Object)this.clientId, (Object)topic);
                this.client.unsubscribe(topic);
            } else {
                LOG.debug("Client: {} is durable so will not unsubscribe from topic: {}", (Object)this.clientId, (Object)topic);
            }
            LOG.debug("Disconnecting client: {} from broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.disconnect();
        }
        this.client = null;
    }

    public PahoMqtt5Endpoint getEndpoint() {
        return (PahoMqtt5Endpoint)super.getEndpoint();
    }

    public Exchange createExchange(MqttMessage mqttMessage, String topic) {
        Exchange exchange = this.createExchange(true);
        PahoMqtt5Message paho = new PahoMqtt5Message(exchange.getContext(), mqttMessage);
        paho.setBody(mqttMessage.getPayload());
        paho.setHeader("CamelMqttTopic", topic);
        paho.setHeader("CamelMqttQoS", mqttMessage.getQos());
        paho.setHeader("CamelPahoMqtt5MsgProperties", mqttMessage.getProperties());
        exchange.setIn((Message)paho);
        return exchange;
    }
}

