/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.SchemaHelper;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

@Mojo(name="generate-type-converter-loader", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class TypeConverterLoaderGeneratorMojo
extends AbstractGeneratorMojo {
    public static final DotName CONVERTER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.Converter");
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.classesDirectory == null) {
            this.classesDirectory = new File(this.project.getBuild().getOutputDirectory());
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if (!this.classesDirectory.isDirectory()) {
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        Index index = PackagePluginUtils.readJandexIndex(this.project);
        TreeMap<String, ClassConverters> converters = new TreeMap<String, ClassConverters>();
        ArrayList<MethodInfo> bulkConverters = new ArrayList<MethodInfo>();
        AtomicInteger classesCounter = new AtomicInteger();
        List annotations = index.getAnnotations(CONVERTER_ANNOTATION);
        annotations.stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(annotation -> TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateLoader") || TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateBulkLoader")).forEach(annotation -> {
            classesCounter.incrementAndGet();
            String currentClass = annotation.target().asClass().name().toString();
            ClassConverters classConverters = new ClassConverters();
            if (TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateLoader")) {
                converters.put(currentClass + "Loader", classConverters);
            }
            classConverters.setIgnoreOnLoadError(TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "ignoreOnLoadError"));
            annotations.stream().filter(an -> an.target().kind() == AnnotationTarget.Kind.METHOD).filter(an -> currentClass.equals(an.target().asMethod().declaringClass().name().toString())).forEach(an -> {
                MethodInfo ee = an.target().asMethod();
                if (TypeConverterLoaderGeneratorMojo.asBoolean(an, "fallback")) {
                    classConverters.addFallbackTypeConverter(ee);
                } else {
                    Type to = ee.returnType();
                    Type from = (Type)ee.parameterTypes().get(0);
                    if (TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateBulkLoader")) {
                        bulkConverters.add(ee);
                    } else {
                        classConverters.addTypeConverter(to, from, ee);
                    }
                }
            });
        });
        if (!bulkConverters.isEmpty()) {
            Object name;
            String pn = ((MethodInfo)bulkConverters.get(0)).declaringClass().name().prefix().toString();
            if (classesCounter.get() > 1) {
                name = SchemaHelper.dashToCamelCase(this.project.getArtifactId());
                name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
            } else {
                name = ((MethodInfo)bulkConverters.get(0)).declaringClass().name().local().replace("Converter", "");
            }
            String fqn = pn + "." + (String)name + "BulkConverterLoader";
            boolean base = "camel-base".equals(this.project.getArtifactId());
            String source = this.writeBulkLoader(fqn, bulkConverters, base);
            this.updateResource(this.sourcesOutputDir.toPath(), fqn.replace('.', '/') + ".java", source);
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/TypeConverterLoader", "# Generated by camel build tools - do NOT edit this file!\n" + String.join((CharSequence)"\n", fqn) + "\n");
        }
        if (!converters.isEmpty()) {
            converters.forEach((currentClass, classConverters) -> {
                String source = this.writeLoader((String)currentClass, (ClassConverters)classConverters);
                this.updateResource(this.sourcesOutputDir.toPath(), currentClass.replace('.', '/') + ".java", source);
            });
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/TypeConverterLoader", "# Generated by camel build tools - do NOT edit this file!\n" + String.join((CharSequence)"\n", converters.keySet()) + "\n");
        }
    }

    private String writeBulkLoader(String fqn, List<MethodInfo> converters, boolean base) {
        converters.sort((o1, o2) -> {
            Integer order2;
            Integer order1;
            int sort = o1.returnType().name().compareTo(o2.returnType().name());
            if (sort == 0 && (sort = (order1 = Integer.valueOf(TypeConverterLoaderGeneratorMojo.asInteger(o1.annotation(CONVERTER_ANNOTATION), "order"))).compareTo(order2 = Integer.valueOf(TypeConverterLoaderGeneratorMojo.asInteger(o2.annotation(CONVERTER_ANNOTATION), "order")))) == 0) {
                String str1 = o1.parameterTypes().stream().findFirst().map(Type::toString).orElse("");
                String str2 = o2.parameterTypes().stream().findFirst().map(Type::toString).orElse("");
                return str1.compareTo(str2);
            }
            return sort;
        });
        TreeSet converterClasses = new TreeSet();
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("package", p);
        ctx.put("className", c);
        ctx.put("converters", converters);
        ctx.put("mojo", (Object)this);
        ctx.put("converterClasses", converterClasses);
        return this.velocity("velocity/bulk-converter-loader.vm", ctx);
    }

    public String getGenericArgumentsForTypeConvertible(MethodInfo method) {
        StringBuilder writer = new StringBuilder(4096);
        if (((Type)method.parameterTypes().get(0)).kind() == Type.Kind.ARRAY || ((Type)method.parameterTypes().get(0)).kind() == Type.Kind.CLASS) {
            writer.append(((Type)method.parameterTypes().get(0)).toString());
        } else {
            writer.append(((Type)method.parameterTypes().get(0)).name().toString());
        }
        writer.append(".class, ");
        writer.append(this.getToMethod(method));
        writer.append(".class");
        return writer.toString();
    }

    public String getToMethod(MethodInfo method) {
        if (Type.Kind.PRIMITIVE.equals((Object)method.returnType().kind())) {
            return method.returnType().toString();
        }
        if (Type.Kind.ARRAY.equals((Object)method.returnType().kind())) {
            return method.returnType().toString();
        }
        return method.returnType().name().toString();
    }

    public String asPrimitiveType(MethodInfo method) {
        if (!Type.Kind.PRIMITIVE.equals((Object)method.returnType().kind())) {
            String to = method.returnType().name().toString();
            if ("java.lang.Integer".equals(to)) {
                return "int";
            }
            if ("java.lang.Long".equals(to)) {
                return "long";
            }
            if ("java.lang.Short".equals(to)) {
                return "short";
            }
            if ("java.lang.Character".equals(to)) {
                return "char";
            }
            if ("java.lang.Boolean".equals(to)) {
                return "boolean";
            }
            if ("java.lang.Float".equals(to)) {
                return "float";
            }
            if ("java.lang.Double".equals(to)) {
                return "double";
            }
            if ("java.lang.Byte".equals(to)) {
                return "byte";
            }
        }
        return null;
    }

    private String writeLoader(String fqn, ClassConverters converters) {
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1);
        LinkedHashSet converterClasses = new LinkedHashSet();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("package", p);
        ctx.put("className", c);
        ctx.put("converters", converters);
        ctx.put("mojo", (Object)this);
        ctx.put("converterClasses", converterClasses);
        return this.velocity("velocity/type-converter-loader.vm", ctx);
    }

    public String toString(Type type) {
        return type.toString().replaceAll("<.*>", "").replace('$', '.');
    }

    public String toJava(MethodInfo converter, Set<String> converterClasses) {
        String type;
        String paramType;
        String pfx;
        if (Modifier.isStatic(converter.flags())) {
            pfx = converter.declaringClass().toString() + "." + converter.name();
        } else {
            converterClasses.add(converter.declaringClass().toString());
            pfx = "get" + converter.declaringClass().simpleName() + "()." + converter.name();
        }
        String param = "";
        String string = paramType = converter.parameterTypes().size() == 2 ? ((Type)converter.parameterTypes().get(1)).asClassType().name().toString() : null;
        if (paramType != null) {
            if ("org.apache.camel.Exchange".equals(paramType)) {
                param = ", exchange";
            } else if ("org.apache.camel.CamelContext".equals(paramType)) {
                param = ", camelContext";
            }
        }
        Object cast = (type = this.toString((Type)converter.parameterTypes().get(0))).equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(" + (String)cast + "value" + param + ")";
    }

    public String toJavaFallback(MethodInfo converter, Set<String> converterClasses) {
        String pfx;
        if (Modifier.isStatic(converter.flags())) {
            pfx = converter.declaringClass().toString() + "." + converter.name();
        } else {
            converterClasses.add(converter.declaringClass().toString());
            pfx = "get" + converter.declaringClass().simpleName() + "()." + converter.name();
        }
        String type = this.toString((Type)converter.parameterTypes().get(converter.parameterTypes().size() - 2));
        Object cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(type, " + (converter.parameterTypes().size() == 4 ? "exchange, " : "") + (String)cast + "value, registry)";
    }

    public boolean isFallbackCanPromote(MethodInfo element) {
        return TypeConverterLoaderGeneratorMojo.asBoolean(element.annotation(CONVERTER_ANNOTATION), "fallbackCanPromote");
    }

    public boolean isAllowNull(MethodInfo element) {
        return TypeConverterLoaderGeneratorMojo.asBoolean(element.annotation(CONVERTER_ANNOTATION), "allowNull");
    }

    private static boolean asBoolean(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null && av.asBoolean();
    }

    private static int asInteger(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null ? av.asInt() : 0;
    }

    public static final class ClassConverters {
        private final Comparator<Type> comparator;
        private final Map<String, Map<Type, MethodInfo>> converters = new TreeMap<String, Map<Type, MethodInfo>>();
        private final List<MethodInfo> fallbackConverters = new ArrayList<MethodInfo>();
        private int size;
        private int sizeFallback;
        private boolean ignoreOnLoadError;

        ClassConverters() {
            this.comparator = Comparator.comparing(Type::toString);
        }

        public boolean isIgnoreOnLoadError() {
            return this.ignoreOnLoadError;
        }

        void setIgnoreOnLoadError(boolean ignoreOnLoadError) {
            this.ignoreOnLoadError = ignoreOnLoadError;
        }

        void addTypeConverter(Type to, Type from, MethodInfo ee) {
            this.converters.computeIfAbsent(ClassConverters.toString(to), c -> new TreeMap(this.comparator)).put(from, ee);
            ++this.size;
        }

        void addFallbackTypeConverter(MethodInfo ee) {
            this.fallbackConverters.add(ee);
            ++this.sizeFallback;
        }

        public Map<String, Map<Type, MethodInfo>> getConverters() {
            return this.converters;
        }

        public List<MethodInfo> getFallbackConverters() {
            return this.fallbackConverters;
        }

        public long size() {
            return this.size;
        }

        public long sizeFallback() {
            return this.sizeFallback;
        }

        public boolean isEmpty() {
            return this.size == 0 && this.sizeFallback == 0;
        }

        private static String toString(Type type) {
            return type.toString().replaceAll("<.*>", "").replace('$', '.');
        }
    }
}

