/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-xml-parser", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ModelXmlParserGeneratorMojo
extends AbstractGeneratorMojo {
    public static final String XML_PARSER_PACKAGE = "org.apache.camel.xml.io";
    public static final String XML_PULL_PARSER_EXCEPTION = "org.apache.camel.xml.io.XmlPullParserException";
    public static final String PARSER_PACKAGE = "org.apache.camel.xml.in";
    public static final String MODEL_PACKAGE = "org.apache.camel.model";
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${camel-generate-xml-parser}")
    protected boolean generateXmlParser;
    private Class<?> outputDefinitionClass;
    private Class<?> expressionDefinitionClass;
    private Class<?> routesDefinitionClass;
    private Class<?> routeConfigurationsDefinitionClass;
    private Class<?> routeTemplatesDefinitionClass;
    private Class<?> templatedRoutesDefinitionClass;
    private Class<?> restsDefinitionClass;
    private Class<?> processorDefinitionClass;
    private Class<?> dataFormatDefinitionClass;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.sourcesOutputDir = new File(project.getBasedir(), "src/generated/java");
        this.generateXmlParser = Boolean.parseBoolean(project.getProperties().getProperty("camel-generate-xml-parser", "false"));
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException {
        if (!this.generateXmlParser) {
            return;
        }
        Path javaDir = this.sourcesOutputDir.toPath();
        String parser = this.generateParser();
        this.updateResource(javaDir, "org.apache.camel.xml.in.ModelParser".replace('.', '/') + ".java", parser);
    }

    public String generateParser() throws MojoExecutionException {
        Index index;
        DynamicClassLoader classLoader;
        try {
            classLoader = DynamicClassLoader.createDynamicClassLoader(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        this.outputDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.OutputDefinition");
        this.routesDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.RoutesDefinition");
        this.routeConfigurationsDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.RouteConfigurationsDefinition");
        this.routeTemplatesDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.RouteTemplatesDefinition");
        this.templatedRoutesDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.TemplatedRoutesDefinition");
        this.dataFormatDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.DataFormatDefinition");
        this.processorDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.ProcessorDefinition");
        this.restsDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.rest.RestsDefinition");
        this.expressionDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.language.ExpressionDefinition");
        String resName = this.routesDefinitionClass.getName().replace('.', '/') + ".class";
        String url = classLoader.getResource(resName).toExternalForm().replace(resName, "META-INF/jandex.idx");
        try (InputStream is = new URL(url).openStream();){
            index = new IndexReader(is).read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        List<Class<?>> model = Stream.of(XmlRootElement.class, XmlEnum.class, XmlType.class).map(Class::getName).map(DotName::createSimple).map(arg_0 -> ((Index)index).getAnnotations(arg_0)).flatMap(Collection::stream).map(AnnotationInstance::target).map(AnnotationTarget::asClass).map(ClassInfo::name).map(DotName::toString).sorted().distinct().filter(n -> !n.equals("org.apache.camel.model.WhenSkipSendToEndpointDefinition")).map(name -> this.loadClass(classLoader, (String)name)).flatMap(this::references).flatMap(this::fieldReferences).distinct().collect(Collectors.toList());
        JavaClass parser = this.generateParser(model, classLoader);
        return "/*\n * Licensed to the Apache Software Foundation (ASF) under one or more\n * contributor license agreements.  See the NOTICE file distributed with\n * this work for additional information regarding copyright ownership.\n * The ASF licenses this file to You under the Apache License, Version 2.0\n * (the \"License\"); you may not use this file except in compliance with\n * the License.  You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n//CHECKSTYLE:OFF\n\n\n/**\n * Generated by Camel build tools - do NOT edit this file!\n */\n" + parser.printClass() + "\n//CHECKSTYLE:ON\n";
    }

    protected Class<?> loadClass(ClassLoader loader, String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class " + name, e);
        }
    }

    private Stream<Class<?>> references(Class<?> clazz) {
        ArrayList allClasses = new ArrayList();
        for (Class<?> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            allClasses.add(cl);
        }
        return allClasses.stream();
    }

    private Stream<Class<?>> fieldReferences(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), Stream.of(clazz.getDeclaredFields()).filter(f -> f.getAnnotation(XmlTransient.class) == null).map(f -> {
            if (f.getAnnotation(XmlJavaTypeAdapter.class) != null) {
                Class cl = f.getAnnotation(XmlJavaTypeAdapter.class).value();
                while (cl.getSuperclass() != XmlAdapter.class) {
                    cl = cl.getSuperclass();
                }
                return ((ParameterizedType)cl.getGenericSuperclass()).getActualTypeArguments()[0];
            }
            return f.getGenericType();
        }).map(GenericType::new).map(t -> t.getRawClass() == List.class ? t.getActualTypeArgument(0) : t).map(GenericType::getRawClass).filter(c -> c.getName().startsWith("org.apache.camel.")));
    }

    private JavaClass generateParser(List<Class<?>> model, ClassLoader classLoader) {
        JavaClass parser = new JavaClass(classLoader);
        parser.setMaxImportPerPackage(4);
        parser.setPackage(PARSER_PACKAGE);
        parser.setName("ModelParser");
        parser.extendSuperType("BaseParser");
        parser.addImport("org.apache.camel.model.OptionalIdentifiedDefinition");
        parser.addImport(IOException.class);
        parser.addImport(XML_PULL_PARSER_EXCEPTION);
        parser.addImport(Array.class);
        parser.addImport(List.class);
        parser.addImport(ArrayList.class);
        parser.addAnnotation(SuppressWarnings.class).setLiteralValue("\"unused\"");
        parser.addMethod().setConstructor(true).setPublic().setName("ModelParser").addParameter("org.apache.camel.spi.Resource", "input").addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody("super(input);");
        parser.addMethod().setConstructor(true).setPublic().setName("ModelParser").addParameter("org.apache.camel.spi.Resource", "input").addParameter(String.class, "namespace").addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody("super(input, namespace);");
        parser.addMethod().setConstructor(true).setPublic().setName("ModelParser").addParameter(InputStream.class, "input").addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody("super(input);");
        parser.addMethod().setConstructor(true).setPublic().setName("ModelParser").addParameter(Reader.class, "reader").addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody("super(reader);");
        parser.addMethod().setConstructor(true).setPublic().setName("ModelParser").addParameter(InputStream.class, "input").addParameter(String.class, "namespace").addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody("super(input, namespace);");
        parser.addMethod().setConstructor(true).setPublic().setName("ModelParser").addParameter(Reader.class, "reader").addParameter(String.class, "namespace").addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody("super(reader, namespace);");
        List<Class> elementRefs = Arrays.asList(this.processorDefinitionClass, this.expressionDefinitionClass, this.dataFormatDefinitionClass);
        for (Class<?> clazz : model) {
            Object elements;
            Object attributes;
            Object qname;
            if (clazz.getAnnotation(XmlEnum.class) != null || clazz.isInterface()) continue;
            String name = clazz.getSimpleName();
            if (clazz.getDeclaringClass() != null) {
                parser.addImport(clazz.getDeclaringClass());
                qname = clazz.getDeclaringClass().getSimpleName() + "." + name;
            } else {
                parser.addImport(clazz);
                qname = name;
            }
            boolean hasDerived = model.stream().anyMatch(cl -> cl.getSuperclass() == clazz);
            List<Member> members = this.getMembers(clazz);
            List attributeMembers = members.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlAttribute.class) != null).collect(Collectors.toList());
            Object baseAttributeHandler = null;
            for (Class<?> parent = clazz.getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                if (!this.getMembers(parent).stream().anyMatch(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlAttribute.class) != null)) continue;
                baseAttributeHandler = this.lowercase(parent.getSimpleName()) + "AttributeHandler()";
                break;
            }
            if (attributeMembers.isEmpty()) {
                attributes = "\n    " + (String)(baseAttributeHandler != null ? baseAttributeHandler : "noAttributeHandler()");
            } else {
                Object defaultCase;
                TreeMap<String, String> cases = new TreeMap<String, String>();
                for (Member member2 : attributeMembers) {
                    Type pt = member2 instanceof Method ? ((Method)member2).getGenericParameterTypes()[0] : ((Field)member2).getGenericType();
                    GenericType type = new GenericType(pt);
                    String mn = member2.getName();
                    String an = ((AccessibleObject)((Object)member2)).getAnnotation(XmlAttribute.class).name();
                    if ("##default".equals(an)) {
                        an = member2 instanceof Method ? this.propname(mn) : mn;
                    }
                    String sn = member2 instanceof Method ? mn : "set" + this.uppercase(mn);
                    cases.put(an, "def." + sn + "(" + this.conversion(parser, type, "val", clazz.getName()) + ");");
                }
                Object object = defaultCase = baseAttributeHandler != null ? (String)baseAttributeHandler + ".accept(def, key, val)" : "false";
                if (attributeMembers.size() == 1) {
                    Map.Entry entry = cases.entrySet().iterator().next();
                    attributes = " (def, key, val) -> {\n    if (\"" + (String)entry.getKey() + "\".equals(key)) {\n        " + (String)entry.getValue() + "\n        return true;\n    }\n    return " + (String)defaultCase + ";\n}";
                } else {
                    attributes = this.generateCases(cases, (String)defaultCase);
                }
            }
            members.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlAnyAttribute.class) != null).forEach(member -> {
                if (!"otherAttributes".equals(member.getName())) {
                    throw new UnsupportedOperationException("Class " + clazz.getName() + " / member " + member + ": unsupported @XmlAnyAttribute");
                }
            });
            List elementMembers = members.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlAttribute.class) == null).filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlAnyAttribute.class) == null).filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlValue.class) == null).collect(Collectors.toList());
            List multiElements = members.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlElementRef.class) != null || ((AccessibleObject)((Object)member)).getAnnotation(XmlElements.class) != null || clazz == this.outputDefinitionClass && "setOutputs".equals(member.getName())).collect(Collectors.toList());
            LinkedHashMap expressionHandlersDefs = new LinkedHashMap();
            LinkedHashMap cases = new LinkedHashMap();
            elementMembers.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlElementRef.class) != null || clazz == this.outputDefinitionClass && "setOutputs".equals(member.getName())).forEach(member -> {
                Class root;
                Type pt = member instanceof Method ? ((Method)member).getGenericParameterTypes()[0] : ((Field)member).getGenericType();
                GenericType type = new GenericType(pt);
                boolean list = type.getRawClass() == List.class;
                String fn = member.getName();
                String sn = member instanceof Method ? fn : "set" + this.uppercase(fn);
                String gn = member instanceof Method ? "g" + sn.substring(1) : "get" + this.uppercase(fn);
                Class clazz = root = list ? type.getActualTypeArgument(0).getRawClass() : type.getRawClass();
                if (elementRefs.contains(root)) {
                    expressionHandlersDefs.put(this.lowercase(sn.substring(3)), "    " + root.getSimpleName() + " v = doParse" + root.getSimpleName() + "Ref(key);\n    if (v != null) { \n        " + (list ? "doAdd(v, def." + gn + "(), def::" + sn + ");" : "def." + sn + "(v);") + "\n        return true;\n    }\n");
                } else {
                    model.stream().filter(root::isAssignableFrom).filter(cl -> cl.getAnnotation(XmlRootElement.class) != null).forEach(cl -> {
                        String en = cl.getAnnotation(XmlRootElement.class).name();
                        if ("##default".equals(en)) {
                            en = this.lowercase(cl.getSimpleName());
                        }
                        String tn = cl.getSimpleName();
                        cases.put(en, list ? "doAdd(doParse" + tn + "(), def." + gn + "(), def::" + sn + ");" : "def." + sn + "(doParse" + tn + "());");
                    });
                }
            });
            elementMembers.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlElements.class) != null).forEach(member -> {
                Class root;
                Type pt = member instanceof Method ? ((Method)member).getGenericParameterTypes()[0] : ((Field)member).getGenericType();
                GenericType type = new GenericType(pt);
                boolean list = type.getRawClass() == List.class;
                String fn = member.getName();
                String sn = member instanceof Method ? fn : "set" + this.uppercase(fn);
                String gn = member instanceof Method ? "g" + sn.substring(1) : "get" + this.uppercase(fn);
                Class clazz = root = list ? type.getActualTypeArgument(0).getRawClass() : type.getRawClass();
                if (elementRefs.contains(root)) {
                    expressionHandlersDefs.put(this.lowercase(sn.substring(3)), "    " + root.getSimpleName() + " v = doParse" + root.getSimpleName() + "Ref(key);\n    if (v != null) { \n        " + (list ? "doAdd(v, def." + gn + "(), def::" + sn + ");" : "def." + sn + "(v);") + "\n        return true;\n    }\n");
                } else {
                    Stream.of(((AccessibleObject)((Object)member)).getAnnotation(XmlElements.class).value()).forEach(xe -> {
                        String en = xe.name();
                        String tn = xe.type().getSimpleName();
                        cases.put(en, list ? "doAdd(doParse" + tn + "(), def." + gn + "(), def::" + sn + ");" : "def." + sn + "(doParse" + tn + "());");
                    });
                }
            });
            elementMembers.stream().filter(member -> !multiElements.contains(member)).forEach(member -> {
                Object pc;
                Class<?> root;
                boolean list;
                Type pt = member instanceof Method ? ((Method)member).getGenericParameterTypes()[0] : ((Field)member).getGenericType();
                GenericType type = new GenericType(pt);
                if (type.getRawClass() == List.class) {
                    list = true;
                    root = type.getActualTypeArgument(0).getRawClass();
                } else if (type.getRawClass().isArray()) {
                    list = true;
                    root = type.getRawClass().getComponentType();
                } else {
                    list = false;
                    root = type.getRawClass();
                }
                String fn = member.getName();
                String en = "##default";
                if (((AccessibleObject)((Object)member)).getAnnotation(XmlElement.class) != null && "value".equals(en = ((AccessibleObject)((Object)member)).getAnnotation(XmlElement.class).name()) && ((AccessibleObject)((Object)member)).getAnnotation(XmlElementWrapper.class) != null) {
                    en = ((AccessibleObject)((Object)member)).getAnnotation(XmlElementWrapper.class).name();
                }
                if ("##default".equals(en)) {
                    en = member instanceof Method ? this.propname(fn) : fn;
                }
                String sn = member instanceof Method ? fn : "set" + this.uppercase(fn);
                String gn = member instanceof Method ? "g" + sn.substring(1) : "get" + this.uppercase(fn);
                String tn = root.getSimpleName();
                if (((AccessibleObject)((Object)member)).getAnnotation(XmlJavaTypeAdapter.class) != null) {
                    String n;
                    Class adapter;
                    Class cl = adapter = ((AccessibleObject)((Object)member)).getAnnotation(XmlJavaTypeAdapter.class).value();
                    while (cl.getSuperclass() != XmlAdapter.class) {
                        cl = cl.getSuperclass();
                    }
                    Type t = ((ParameterizedType)cl.getGenericSuperclass()).getActualTypeArguments()[0];
                    Class c = new GenericType(t).getRawClass();
                    String string = n = adapter.getDeclaringClass() != null ? adapter.getDeclaringClass().getSimpleName() + "." + adapter.getSimpleName() : adapter.getSimpleName();
                    if (c == String.class) {
                        pc = "unmarshal(new " + n + "(), doParseText())";
                    } else if (model.contains(c)) {
                        pc = "unmarshal(new " + n + "(), doParse" + c.getSimpleName() + "())";
                    } else {
                        throw new UnsupportedOperationException("Class " + clazz.getName() + " / member " + member + ": unsupported @XmlJavaTypeAdapter");
                    }
                    if (list && type.equals((Object)new GenericType(((ParameterizedType)cl.getGenericSuperclass()).getActualTypeArguments()[1]))) {
                        list = false;
                    }
                } else if (model.contains(root)) {
                    pc = "doParse" + tn + "()";
                } else if (root == String.class) {
                    pc = "doParseText()";
                } else {
                    String n = root.getName();
                    if (n.startsWith("java.lang.")) {
                        n = tn;
                    }
                    pc = n + ".valueOf(doParseText())";
                }
                if ("allowableValues".equals(en)) {
                    cases.put(en, list ? "doAddValues(" + (String)pc + ", def." + gn + "(), def::" + sn + ");" : "def." + sn + "(" + (String)pc + ");");
                } else {
                    cases.put(en, list ? "doAdd(" + (String)pc + ", def." + gn + "(), def::" + sn + ");" : "def." + sn + "(" + (String)pc + ");");
                }
            });
            String expressionHandler = null;
            for (Class<?> parent = clazz.getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                if (!this.getMembers(parent).stream().anyMatch(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlAttribute.class) == null && ((AccessibleObject)((Object)member)).getAnnotation(XmlAnyAttribute.class) == null && ((AccessibleObject)((Object)member)).getAnnotation(XmlValue.class) == null)) continue;
                expressionHandler = this.lowercase(parent.getSimpleName()) + "ElementHandler()";
                break;
            }
            if (expressionHandlersDefs.size() > 1) {
                throw new IllegalStateException();
            }
            if (cases.isEmpty()) {
                elements = expressionHandlersDefs.isEmpty() ? (expressionHandler == null ? " noElementHandler()" : " " + expressionHandler) : " (def, key) -> {\n" + (String)expressionHandlersDefs.values().iterator().next() + "    return " + (String)(expressionHandler == null ? "false" : expressionHandler + ".accept(def, key)") + ";\n}";
            } else {
                String returnClause = (String)(expressionHandlersDefs.isEmpty() ? "" : (String)expressionHandlersDefs.values().iterator().next() + "    ") + (String)(expressionHandler == null ? "return false;" : "return " + expressionHandler + ".accept(def, key);");
                if (cases.size() == 1) {
                    Map.Entry entry = cases.entrySet().iterator().next();
                    elements = " (def, key) -> {\n    if (\"" + (String)entry.getKey() + "\".equals(key)) {\n        " + (String)entry.getValue() + "\n        return true;\n    }\n    " + returnClause + "\n}";
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(" (def, key) -> {\n    switch (key) {\n");
                    for (Map.Entry entry : cases.entrySet()) {
                        sb.append("        case \"").append((String)entry.getKey()).append("\": ").append((String)entry.getValue()).append(" break;\n");
                    }
                    sb.append("        default: ");
                    if (expressionHandlersDefs.isEmpty()) {
                        sb.append(returnClause);
                    } else {
                        Stream.of(returnClause.split("\n")).forEach(s -> sb.append("\n        ").append((String)s));
                    }
                    sb.append("\n");
                    sb.append("    }\n").append("    return true;\n").append("}");
                    elements = sb.toString();
                }
            }
            String value = members.stream().filter(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlValue.class) != null).findFirst().map(member -> {
                String sn;
                String fn = member.getName();
                String string = sn = member instanceof Method ? fn : "set" + this.uppercase(fn);
                if (this.expressionDefinitionClass.isAssignableFrom(member.getDeclaringClass())) {
                    return " expressionDefinitionValueHandler()";
                }
                return " (def, val) -> def." + sn + "(val)";
            }).orElseGet(() -> {
                for (Class parent = clazz.getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                    if (!this.getMembers(parent).stream().anyMatch(member -> ((AccessibleObject)((Object)member)).getAnnotation(XmlValue.class) != null)) continue;
                    return " " + this.lowercase(parent.getSimpleName()) + "ValueHandler()";
                }
                return " noValueHandler()";
            });
            if (clazz == this.routesDefinitionClass || clazz == this.routeTemplatesDefinitionClass || clazz == this.templatedRoutesDefinitionClass || clazz == this.restsDefinitionClass || clazz == this.routeConfigurationsDefinitionClass) {
                String element = clazz.getAnnotation(XmlRootElement.class).name();
                String capitalElement = Character.toUpperCase(element.charAt(0)) + element.substring(1);
                String singleElement = element.endsWith("s") ? element.substring(0, element.length() - 1) : element;
                String singleName = name.replace("sDefinition", "Definition");
                parser.addMethod().setPublic().setReturnType(new GenericType(Optional.class, new GenericType[]{new GenericType(clazz)})).setName("parse" + name).addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody(new String[]{String.format("String tag = getNextTag(\"%s\", \"%s\");", element, singleElement), "if (tag != null) {", "    switch (tag) {", String.format("        case \"%s\" : return Optional.of(doParse%s());", element, name), String.format("        case \"%s\" : return parseSingle%s();", singleElement, name), "    }", "}", "return Optional.empty();"});
                parser.addMethod().setPrivate().setReturnType(new GenericType(Optional.class, new GenericType[]{new GenericType(clazz)})).setName("parseSingle" + name).addThrows(IOException.class).addThrows(XML_PULL_PARSER_EXCEPTION).setBody(new String[]{String.format("Optional<%s> single = Optional.of(doParse%s());", singleName, singleName), "if (single.isPresent()) {", String.format("    List<%s> list = new ArrayList<>();", singleName), "    list.add(single.get());", String.format("    %s def = new %s();", name, name), String.format("    def.set%s(list);", capitalElement), "    return Optional.of(def);", "}", "return Optional.empty();"});
            }
            if (hasDerived) {
                if (!attributeMembers.isEmpty()) {
                    parser.addMethod().setSignature("protected <T extends " + (String)qname + "> AttributeHandler<T> " + this.lowercase(name) + "AttributeHandler()").setBody("return" + (String)attributes + ";");
                }
                if (!elementMembers.isEmpty()) {
                    parser.addMethod().setSignature("protected <T extends " + (String)qname + "> ElementHandler<T> " + this.lowercase(name) + "ElementHandler()").setBody("return" + (String)elements + ";");
                }
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                parser.addMethod().setSignature("protected " + (String)qname + " doParse" + name + "() throws IOException, XmlPullParserException").setBody("return doParse(new " + (String)qname + "(), " + (String)(attributeMembers.isEmpty() ? attributes : this.lowercase(name) + "AttributeHandler()") + ", " + (String)(elementMembers.isEmpty() ? elements : this.lowercase(name) + "ElementHandler()") + "," + value + ");\n");
                continue;
            }
            if ("ValueDefinition".equals(name)) {
                parser.addMethod().setSignature("protected List<" + (String)qname + "> doParse" + name + "() throws IOException, XmlPullParserException").setBody("return doParseValue(() -> new " + (String)qname + "()," + value + ");\n");
                continue;
            }
            parser.addMethod().setSignature("protected " + (String)qname + " doParse" + name + "() throws IOException, XmlPullParserException").setBody("return doParse(new " + (String)qname + "()," + (String)attributes + "," + (String)elements + "," + value + ");\n");
        }
        for (Class<?> clazz : elementRefs) {
            parser.addMethod().setSignature("protected " + clazz.getSimpleName() + " doParse" + clazz.getSimpleName() + "Ref(String key) throws IOException, XmlPullParserException").setBody("switch (key) {\n" + model.stream().filter(clazz::isAssignableFrom).filter(cl -> cl.getAnnotation(XmlRootElement.class) != null).map(cl -> {
                String en = cl.getAnnotation(XmlRootElement.class).name();
                if ("##default".equals(en)) {
                    en = this.lowercase(cl.getSimpleName());
                }
                String tn = cl.getSimpleName();
                return "    case \"" + en + "\": return doParse" + tn + "();\n";
            }).collect(Collectors.joining()) + "    default: return null;\n}");
        }
        return parser;
    }

    private String generateCases(SortedMap<String, String> cases, String defaultCase) {
        StringBuilder sb = new StringBuilder();
        sb.append(" (def, key, val) -> {\n").append("    switch (key) {\n");
        for (Map.Entry<String, String> entry : cases.entrySet()) {
            sb.append("        case \"").append(entry.getKey()).append("\": ").append(entry.getValue()).append(" break;\n");
        }
        sb.append("        default: return ").append(defaultCase).append(";\n    }\n").append("    return true;\n").append("}");
        String attributes = sb.toString();
        return attributes;
    }

    private String conversion(JavaClass parser, GenericType type, String val, String clazzName) {
        Class rawClass = type.getRawClass();
        if (rawClass == String.class) {
            return val;
        }
        if (rawClass.isEnum() || rawClass == Integer.class || rawClass == Long.class || rawClass == Boolean.class || rawClass == Float.class) {
            parser.addImport(rawClass);
            return rawClass.getSimpleName() + ".valueOf(" + val + ")";
        }
        if (rawClass == List.class && type.getActualTypeArgument(0).getRawClass() == String.class) {
            return "asStringList(" + val + ")";
        }
        if (rawClass == Set.class && type.getActualTypeArgument(0).getRawClass() == String.class) {
            return "asStringSet(" + val + ")";
        }
        if (rawClass == Class.class) {
            return "asClass(" + val + ")";
        }
        if (rawClass == Class[].class) {
            return "asClassArray(" + val + ")";
        }
        if (rawClass == byte[].class) {
            return "asByteArray(" + val + ")";
        }
        throw new UnsupportedOperationException("Unsupported type " + rawClass.getSimpleName() + " in class " + clazzName);
    }

    private List<Member> getMembers(Class<?> clazz) {
        List<Member> members = Stream.concat(this.findFieldsForClass(clazz), this.findMethodsForClass(clazz)).filter(m -> ((AnnotatedElement)((Object)m)).getAnnotation(XmlTransient.class) == null).sorted(Comparator.comparing(member -> member instanceof Method ? this.propname(member.getName()) : member.getName())).collect(Collectors.toList());
        if (clazz != this.outputDefinitionClass && this.outputDefinitionClass.isAssignableFrom(clazz)) {
            members.removeIf(m -> "setOutputs".equals(m.getName()));
        }
        return members;
    }

    private Stream<? extends Member> findMethodsForClass(Class<?> c) {
        XmlAccessType accessType = c.getAnnotation(XmlAccessorType.class) != null && c != this.outputDefinitionClass ? c.getAnnotation(XmlAccessorType.class).value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType == XmlAccessType.FIELD || accessType == XmlAccessType.NONE) {
            return Stream.of(c.getDeclaredMethods()).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).filter(m -> m.getAnnotation(XmlAttribute.class) != null || m.getAnnotation(XmlElement.class) != null || m.getAnnotation(XmlElementRef.class) != null || m.getAnnotation(XmlValue.class) != null).sorted(Comparator.comparing(Method::getName));
        }
        return Stream.of(c.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) || accessType == XmlAccessType.PROPERTY).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).filter(m -> m.getAnnotation(XmlTransient.class) == null).sorted(Comparator.comparing(Method::getName));
    }

    private Stream<? extends Member> findFieldsForClass(Class<?> c) {
        XmlAccessType accessType = c.getAnnotation(XmlAccessorType.class) != null ? c.getAnnotation(XmlAccessorType.class).value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType == XmlAccessType.PROPERTY || accessType == XmlAccessType.NONE) {
            return Stream.of(c.getDeclaredFields()).filter(f -> f.getAnnotation(XmlAttribute.class) != null || f.getAnnotation(XmlElement.class) != null || f.getAnnotation(XmlElementRef.class) != null || f.getAnnotation(XmlValue.class) != null).sorted(Comparator.comparing(Field::getName));
        }
        return Stream.of(c.getDeclaredFields()).filter(f -> !Modifier.isTransient(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isPublic(f.getModifiers()) || accessType == XmlAccessType.FIELD).filter(f -> f.getAnnotation(XmlTransient.class) == null).sorted(Comparator.comparing(Field::getName));
    }

    private String lowercase(String fn) {
        return fn.substring(0, 1).toLowerCase() + fn.substring(1);
    }

    private String uppercase(String fn) {
        return fn.substring(0, 1).toUpperCase() + fn.substring(1);
    }

    private String propname(String name) {
        return this.lowercase(name.substring(3));
    }
}

