/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.maven.packaging.PropertyConfigurerGenerator;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.util.ReflectionHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public abstract class AbstractGenerateConfigurerMojo
extends AbstractGeneratorMojo {
    public static final DotName CONFIGURER = DotName.createSimple((String)"org.apache.camel.spi.Configurer");
    @Parameter(defaultValue="true")
    protected boolean discoverClasses = true;
    @Parameter(defaultValue="false")
    protected boolean allowBuilderPattern;
    @Parameter(defaultValue="false")
    protected boolean skipDeprecated;
    @Component
    private ArtifactFactory artifactFactory;
    private DynamicClassLoader projectClassLoader;

    protected void doExecute(File sourcesOutputDir, File resourcesOutputDir, List<String> classes, boolean testClasspathOnly) throws MojoExecutionException {
        Index index;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (sourcesOutputDir == null) {
            sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (resourcesOutputDir == null) {
            resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        this.addRelevantProjectDependenciesToClasspath(urls, testClasspathOnly);
        this.projectClassLoader = DynamicClassLoader.createDynamicClassLoaderFromUrls(urls);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedHashSet<String> extendedSet = new LinkedHashSet<String>();
        LinkedHashSet<String> bootstrapSet = new LinkedHashSet<String>();
        LinkedHashSet<String> bootstrapAndExtendedSet = new LinkedHashSet<String>();
        if (this.discoverClasses && (index = PackagePluginUtils.readJandexIndexIgnoreMissing(this.project, this.getLog())) != null) {
            List annotations = index.getAnnotations(CONFIGURER);
            annotations.stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(annotation -> AbstractGenerateConfigurerMojo.asBooleanDefaultTrue(annotation, "generateConfigurer")).forEach(annotation -> {
                String currentClass = annotation.target().asClass().name().toString();
                this.addToSets((AnnotationInstance)annotation, (Set<String>)bootstrapAndExtendedSet, currentClass, (Set<String>)bootstrapSet, (Set<String>)extendedSet, (Set<String>)set);
            });
        }
        if (classes != null && !classes.isEmpty()) {
            index = PackagePluginUtils.readJandexIndex(this.project);
            for (String clazz : classes) {
                AnnotationInstance ai;
                ClassInfo ci = index.getClassByName(DotName.createSimple((String)clazz));
                AnnotationInstance annotationInstance = ai = ci != null ? ci.classAnnotation(CONFIGURER) : null;
                if (ai != null) {
                    this.addToSets(ai, bootstrapAndExtendedSet, clazz, bootstrapSet, extendedSet, set);
                    continue;
                }
                set.add(clazz);
            }
        }
        for (String fqn : set) {
            this.processClass(fqn, sourcesOutputDir, false, false, resourcesOutputDir);
        }
        for (String fqn : bootstrapSet) {
            this.processClass(fqn, sourcesOutputDir, false, true, resourcesOutputDir);
        }
        for (String fqn : extendedSet) {
            this.processClass(fqn, sourcesOutputDir, true, false, resourcesOutputDir);
        }
        for (String fqn : bootstrapAndExtendedSet) {
            this.processClass(fqn, sourcesOutputDir, true, true, resourcesOutputDir);
        }
    }

    private void addToSets(AnnotationInstance annotation, Set<String> bootstrapAndExtendedSet, String currentClass, Set<String> bootstrapSet, Set<String> extendedSet, Set<String> set) {
        boolean bootstrap = AbstractGenerateConfigurerMojo.asBooleanDefaultFalse(annotation, "bootstrap");
        boolean extended = AbstractGenerateConfigurerMojo.asBooleanDefaultFalse(annotation, "extended");
        if (bootstrap && extended) {
            bootstrapAndExtendedSet.add(currentClass);
        } else if (bootstrap) {
            bootstrapSet.add(currentClass);
        } else if (extended) {
            extendedSet.add(currentClass);
        } else {
            set.add(currentClass);
        }
    }

    private void processClass(String fqn, File sourcesOutputDir, boolean extended, boolean bootstrap, File resourcesOutputDir) throws MojoExecutionException {
        try {
            String targetFqn = fqn;
            int pos = fqn.indexOf(61);
            if (pos != -1) {
                targetFqn = fqn.substring(pos + 1);
                fqn = fqn.substring(0, pos);
            }
            List<ConfigurerOption> options = this.processClass(fqn);
            this.generateConfigurer(fqn, targetFqn, options, sourcesOutputDir, extended, bootstrap);
            this.generateMetaInfConfigurer(fqn, targetFqn, resourcesOutputDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing class: " + fqn, e);
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List<URL> path, boolean testClasspathOnly) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            if (testClasspathOnly) {
                URL testClasses = new File(this.project.getBuild().getTestOutputDirectory()).toURI().toURL();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath : " + testClasses));
                }
                path.add(testClasses);
            } else {
                URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
                }
                path.add(mainClasses);
            }
            Set dependencies = this.project.getArtifacts();
            dependencies.addAll(this.getAllNonTestScopedDependencies());
            for (Artifact classPathElement : dependencies) {
                File file;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                }
                if ((file = classPathElement.getFile()) == null) continue;
                path.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private Collection<Artifact> getAllNonTestScopedDependencies() throws MojoExecutionException {
        ArrayList<Artifact> answer = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllDependencies()) {
            if (artifact.getScope().equals("test")) continue;
            answer.add(artifact);
        }
        return answer;
    }

    private Collection<Artifact> getAllDependencies() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Dependency dependency : this.project.getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("unable to parse version", (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            if (this.artifactFactory == null) continue;
            Artifact art = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<CallSite> exclusions = new ArrayList<CallSite>();
            for (Exclusion exclusion : dependency.getExclusions()) {
                exclusions.add((CallSite)((Object)(exclusion.getGroupId() + ":" + exclusion.getArtifactId())));
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }

    private List<ConfigurerOption> processClass(String fqn) throws ClassNotFoundException {
        ArrayList<ConfigurerOption> answer = new ArrayList<ConfigurerOption>();
        HashSet names = new HashSet();
        Class<?> clazz = this.projectClassLoader.loadClass(fqn);
        ReflectionHelper.doWithMethods(clazz, m -> {
            boolean deprecated = m.isAnnotationPresent(Deprecated.class);
            if (this.skipDeprecated && deprecated) {
                return;
            }
            boolean setter = m.getName().length() >= 4 && m.getName().startsWith("set") && Character.isUpperCase(m.getName().charAt(3));
            setter &= Modifier.isPublic(m.getModifiers()) && m.getParameterCount() == 1;
            setter &= this.filterSetter(m);
            boolean builder = this.allowBuilderPattern && m.getName().length() >= 5 && m.getName().startsWith("with") && Character.isUpperCase(m.getName().charAt(4));
            builder &= Modifier.isPublic(m.getModifiers()) && m.getParameterCount() == 1;
            if (setter || (builder &= this.filterSetter(m))) {
                String t;
                String getter = "get" + (builder ? Character.toUpperCase(m.getName().charAt(4)) + m.getName().substring(5) : Character.toUpperCase(m.getName().charAt(3)) + m.getName().substring(4));
                Class<?> type = m.getParameterTypes()[0];
                if (Boolean.TYPE == type || Boolean.class == type) {
                    try {
                        String isGetter = "is" + getter.substring(3);
                        clazz.getMethod(isGetter, null);
                        getter = isGetter;
                    }
                    catch (Exception isGetter) {
                        // empty catch block
                    }
                }
                ConfigurerOption option = null;
                String string = t = builder ? Character.toUpperCase(m.getName().charAt(4)) + m.getName().substring(5) : Character.toUpperCase(m.getName().charAt(3)) + m.getName().substring(4);
                if (names.add(t)) {
                    option = new ConfigurerOption(t, type, getter, builder);
                    answer.add(option);
                } else {
                    boolean replace = false;
                    Field field = ReflectionHelper.findField((Class)clazz, (String)(Character.toLowerCase(t.charAt(0)) + t.substring(1)));
                    if (field != null && field.getType().equals(type)) {
                        replace = true;
                    }
                    if (replace) {
                        answer.removeIf(o -> o.getName().equals(t));
                        option = new ConfigurerOption(t, type, getter, builder);
                        answer.add(option);
                    }
                }
                if (option != null) {
                    String desc;
                    String string2 = desc = type.isArray() ? type.getComponentType().getName() : m.toGenericString();
                    if (desc.contains("<") && desc.contains(">")) {
                        int pos = (desc = Strings.between((String)desc, (String)"<", (String)">")).indexOf(60);
                        if (pos != -1) {
                            desc = desc.substring(0, pos);
                        }
                        if ((pos = desc.indexOf(44)) != -1) {
                            desc = desc.substring(pos + 1);
                        }
                        desc = desc.replace('$', '.');
                        if ((desc = desc.trim()).length() > 1 && desc.indexOf(63) == -1 && !desc.contains(" extends ")) {
                            option.setNestedType(desc);
                        }
                    }
                }
            }
        });
        return answer;
    }

    private boolean filterSetter(Method setter) {
        if ("setBindingMode".equals(setter.getName()) || "setHostNameResolver".equals(setter.getName())) {
            return setter.getParameterTypes()[0] == String.class;
        }
        Metadata meta = setter.getAnnotation(Metadata.class);
        return meta == null || !meta.skip();
    }

    private void generateConfigurer(String fqn, String targetFqn, List<ConfigurerOption> options, File outputDir, boolean extended, boolean bootstrap) {
        int pos = targetFqn.lastIndexOf(46);
        String pn = targetFqn.substring(0, pos);
        String cn = targetFqn.substring(pos + 1) + "Configurer";
        String en = fqn;
        String pfqn = fqn;
        String psn = "org.apache.camel.support.component.PropertyConfigurerSupport";
        String source = PropertyConfigurerGenerator.generatePropertyConfigurer(pn, cn, en, pfqn, psn, false, false, extended, bootstrap, options, null);
        String fileName = pn.replace('.', '/') + "/" + cn + ".java";
        outputDir.mkdirs();
        boolean updated = AbstractGenerateConfigurerMojo.updateResource(this.buildContext, outputDir.toPath().resolve(fileName), source);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + fileName));
        }
    }

    private void generateMetaInfConfigurer(String fqn, String targetFqn, File resourcesOutputDir) {
        int pos = targetFqn.lastIndexOf(46);
        String pn = targetFqn.substring(0, pos);
        String en = targetFqn.substring(pos + 1);
        try (StringWriter w = new StringWriter();){
            ((Writer)w).append("# Generated by camel build tools - do NOT edit this file!\n");
            ((Writer)w).append("class=").append(pn).append(".").append(en).append("Configurer").append("\n");
            String fileName = "META-INF/services/org/apache/camel/configurer/" + fqn;
            boolean updated = AbstractGenerateConfigurerMojo.updateResource(this.buildContext, resourcesOutputDir.toPath().resolve(fileName), ((Object)w).toString());
            if (updated) {
                this.getLog().info((CharSequence)("Updated " + fileName));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean asBooleanDefaultTrue(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av == null || av.asBoolean();
    }

    private static boolean asBooleanDefaultFalse(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null && av.asBoolean();
    }

    public static class ConfigurerOption
    extends BaseOptionModel {
        private boolean builderMethod;

        public ConfigurerOption(String name, Class type, String getter, boolean builderMethod) {
            this.setName(name);
            if (byte[].class == type) {
                this.setJavaType("byte[]");
            } else if (long[].class == type) {
                this.setJavaType("long[]");
            } else if (type.isArray()) {
                String arrType = Strings.between((String)type.getName(), (String)"[L", (String)";") + "[]";
                this.setJavaType(arrType);
            } else {
                this.setJavaType(type.getName());
            }
            this.setGetterMethod(getter);
            this.builderMethod = builderMethod;
        }

        public boolean isBuilderMethod() {
            return this.builderMethod;
        }
    }
}

