/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import java.util.Collection;
import java.util.Optional;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.commons.lang3.StringUtils;

public final class ComponentDslInnerImplBuilderGenerator {
    private static final String BUILDER_IMPL_SUFFIX = "Impl";
    private final JavaClass javaClass;
    private final ComponentModel componentModel;
    private final String classBuilderName;

    private ComponentDslInnerImplBuilderGenerator(JavaClass javaClass, ComponentModel componentModel, String interfaceBuilderName) {
        this.javaClass = javaClass;
        this.componentModel = componentModel;
        this.classBuilderName = interfaceBuilderName;
        this.generateJavaClass();
    }

    public static ComponentDslInnerImplBuilderGenerator generateClass(JavaClass javaClass, ComponentModel componentModel, String classBuilderName) {
        return new ComponentDslInnerImplBuilderGenerator(javaClass, componentModel, classBuilderName);
    }

    public String getGeneratedClassName() {
        return this.classBuilderName + BUILDER_IMPL_SUFFIX;
    }

    private void generateJavaClass() {
        this.setClassNameAndType();
        this.setMethods();
    }

    private void setClassNameAndType() {
        this.javaClass.setName(this.getGeneratedClassName()).setPackagePrivate().setStatic(false).extendSuperType(String.format("AbstractComponentBuilder<%s>", this.componentModel.getShortJavaType())).implementInterface(this.classBuilderName);
    }

    private void setMethods() {
        this.javaClass.addMethod().setProtected().setReturnType(this.componentModel.getShortJavaType()).setName("buildConcreteComponent").setBody(String.format("return new %s();", this.componentModel.getShortJavaType())).addAnnotation(Override.class);
        Optional<ComponentModel.ComponentOptionModel> configurationOption = ComponentDslInnerImplBuilderGenerator.findConfiguration(this.componentModel.getComponentOptions());
        if (configurationOption.isPresent()) {
            ComponentModel.ComponentOptionModel config = configurationOption.get();
            this.javaClass.addMethod().setPrivate().setReturnType(config.getConfigurationClass()).setName("getOrCreateConfiguration").addParameter(this.componentModel.getJavaType(), "component").setBody(ComponentDslInnerImplBuilderGenerator.createGetOrCreateConfigurationBody(config.getConfigurationClass(), config.getConfigurationField()));
        }
        this.javaClass.addMethod().setProtected().setReturnType("boolean").setName("setPropertyOnComponent").addParameter("Component", "component").addParameter(String.class, "name").addParameter(Object.class, "value").setBody(this.generatePropertiesSetters(this.componentModel)).addAnnotation(Override.class);
    }

    private String generatePropertiesSetters(ComponentModel componentModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("switch (name) {\n");
        componentModel.getComponentOptions().forEach(componentOptionModel -> {
            String prefix = componentOptionModel.getConfigurationField() != null ? "getOrCreateConfiguration" : "";
            String type = componentOptionModel.getJavaType();
            if (type.indexOf(60) != -1) {
                type = type.substring(0, type.indexOf(60));
            }
            type = type.replace('$', '.');
            String setterAsString = String.format("case \"%s\": %s((%s) component).set%s((%s) value); return true;\n", componentOptionModel.getName(), prefix, componentModel.getShortJavaType(), StringUtils.capitalize((String)componentOptionModel.getName()), type);
            stringBuilder.append(setterAsString);
        });
        stringBuilder.append("default: return false;\n}");
        return stringBuilder.toString();
    }

    private static Optional<ComponentModel.ComponentOptionModel> findConfiguration(Collection<ComponentModel.ComponentOptionModel> options) {
        return options.stream().filter(o -> o.getConfigurationField() != null).findFirst();
    }

    private static String createGetOrCreateConfigurationBody(String configurationClass, String configurationField) {
        String getter = "get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        String setter = "set" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        StringBuilder sb = new StringBuilder();
        String line1 = String.format("if (component.%s() == null) {\n", getter);
        String line2 = String.format("    component.%s(new %s());\n", setter, configurationClass);
        String line3 = "}\n";
        String line4 = String.format("return component.%s();\n", getter);
        sb.append(line1).append(line2).append(line3).append(line4);
        return sb.toString();
    }
}

