/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.opentelemetry.GetCorrelationContextProcessor;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.opentelemetry.OpenTelemetryTracer;
import org.apache.camel.opentelemetry.SetCorrelationContextProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.SpanAdapter;

public class OpenTelemetryTracingStrategy
implements InterceptStrategy {
    private static final String UNNAMED = "unnamed";
    private final OpenTelemetryTracer tracer;
    private boolean propagateContext;

    public OpenTelemetryTracingStrategy(OpenTelemetryTracer tracer) {
        this.tracer = tracer;
    }

    public Processor wrapProcessorInInterceptors(CamelContext camelContext, NamedNode processorDefinition, Processor target, Processor nextTarget) throws Exception {
        if (this.shouldTrace(processorDefinition)) {
            return new PropagateContextAndCreateSpan(processorDefinition, target);
        }
        if (this.isPropagateContext()) {
            return new PropagateContext(target);
        }
        return new DelegateAsyncProcessor(target);
    }

    public boolean isPropagateContext() {
        return this.propagateContext;
    }

    public void setPropagateContext(boolean propagateContext) {
        this.propagateContext = propagateContext;
    }

    private static String getComponentName(NamedNode processorDefinition) {
        return "camel-" + processorDefinition.getShortName();
    }

    private static String getOperationName(NamedNode processorDefinition) {
        String name = processorDefinition.getId();
        return name == null ? UNNAMED : name;
    }

    private boolean shouldTrace(NamedNode definition) {
        if (this.tracer.getExcludePatterns() != null) {
            for (String pattern : this.tracer.getExcludePatterns().split(",")) {
                pattern = pattern.trim();
                if (!PatternHelper.matchPattern((String)definition.getId(), (String)pattern)) continue;
                return false;
            }
        }
        return true;
    }

    private class PropagateContextAndCreateSpan
    implements Processor {
        private final NamedNode processorDefinition;
        private final Processor target;

        public PropagateContextAndCreateSpan(NamedNode processorDefinition, Processor target) {
            this.processorDefinition = processorDefinition;
            this.target = target;
        }

        public void process(Exchange exchange) throws Exception {
            boolean activateExchange;
            Span span = null;
            OpenTelemetrySpanAdapter spanWrapper = (OpenTelemetrySpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            if (spanWrapper != null) {
                span = spanWrapper.getOpenTelemetrySpan();
            }
            if (span == null) {
                this.target.process(exchange);
                return;
            }
            Span processorSpan = OpenTelemetryTracingStrategy.this.tracer.getTracer().spanBuilder(OpenTelemetryTracingStrategy.getOperationName(this.processorDefinition)).setParent(Context.current().with((ImplicitContextKeyed)span)).setAttribute("component", OpenTelemetryTracingStrategy.getComponentName(this.processorDefinition)).startSpan();
            boolean bl = activateExchange = !(this.target instanceof GetCorrelationContextProcessor) && !(this.target instanceof SetCorrelationContextProcessor);
            if (activateExchange) {
                ActiveSpanManager.activate((Exchange)exchange, (SpanAdapter)new OpenTelemetrySpanAdapter(processorSpan));
            }
            try (Scope ignored = processorSpan.makeCurrent();){
                this.target.process(exchange);
            }
            catch (Exception ex) {
                span.setStatus(StatusCode.ERROR);
                span.recordException((Throwable)ex);
                throw ex;
            }
            finally {
                if (activateExchange) {
                    ActiveSpanManager.deactivate((Exchange)exchange);
                }
                processorSpan.end();
            }
        }
    }

    private static class PropagateContext
    implements Processor {
        private final Processor target;

        public PropagateContext(Processor target) {
            this.target = target;
        }

        public void process(Exchange exchange) throws Exception {
            boolean activateExchange;
            Span span = null;
            OpenTelemetrySpanAdapter spanWrapper = (OpenTelemetrySpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            if (spanWrapper != null) {
                span = spanWrapper.getOpenTelemetrySpan();
            }
            if (span == null) {
                this.target.process(exchange);
                return;
            }
            boolean bl = activateExchange = !(this.target instanceof GetCorrelationContextProcessor) && !(this.target instanceof SetCorrelationContextProcessor);
            if (activateExchange) {
                ActiveSpanManager.activate((Exchange)exchange, (SpanAdapter)new OpenTelemetrySpanAdapter(span));
            }
            try {
                this.target.process(exchange);
            }
            catch (Exception ex) {
                span.setStatus(StatusCode.ERROR);
                span.recordException((Throwable)ex);
                throw ex;
            }
            finally {
                if (activateExchange) {
                    ActiveSpanManager.deactivate((Exchange)exchange);
                }
            }
        }
    }
}

