/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.opentelemetry.GetCorrelationContextProcessor;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.opentelemetry.OpenTelemetryTracer;
import org.apache.camel.opentelemetry.SetCorrelationContextProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.SpanAdapter;

public class OpenTelemetryTracingStrategy
implements InterceptStrategy {
    private static final String UNNAMED = "unnamed";
    private final OpenTelemetryTracer tracer;

    public OpenTelemetryTracingStrategy(OpenTelemetryTracer tracer) {
        this.tracer = tracer;
    }

    public Processor wrapProcessorInInterceptors(CamelContext camelContext, NamedNode processorDefinition, Processor target, Processor nextTarget) throws Exception {
        if (!this.shouldTrace(processorDefinition)) {
            return new DelegateAsyncProcessor(target);
        }
        return new DelegateAsyncProcessor(exchange -> {
            boolean activateExchange;
            Span span = null;
            OpenTelemetrySpanAdapter spanWrapper = (OpenTelemetrySpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            if (spanWrapper != null) {
                span = spanWrapper.getOpenTelemetrySpan();
            }
            if (span == null) {
                target.process(exchange);
                return;
            }
            Span processorSpan = this.tracer.getTracer().spanBuilder(OpenTelemetryTracingStrategy.getOperationName(processorDefinition)).setParent(Context.current().with((ImplicitContextKeyed)span)).setAttribute("component", OpenTelemetryTracingStrategy.getComponentName(processorDefinition)).startSpan();
            boolean bl = activateExchange = !(target instanceof GetCorrelationContextProcessor) && !(target instanceof SetCorrelationContextProcessor);
            if (activateExchange) {
                ActiveSpanManager.activate((Exchange)exchange, (SpanAdapter)new OpenTelemetrySpanAdapter(processorSpan));
            }
            try (Scope ignored = processorSpan.makeCurrent();){
                target.process(exchange);
            }
            catch (Exception ex) {
                span.setStatus(StatusCode.ERROR);
                span.recordException((Throwable)ex);
                throw ex;
            }
            finally {
                if (activateExchange) {
                    ActiveSpanManager.deactivate((Exchange)exchange);
                }
                processorSpan.end();
            }
        });
    }

    private static String getComponentName(NamedNode processorDefinition) {
        return "camel-" + processorDefinition.getShortName();
    }

    private static String getOperationName(NamedNode processorDefinition) {
        String name = processorDefinition.getId();
        return name == null ? UNNAMED : name;
    }

    private boolean shouldTrace(NamedNode definition) {
        for (String pattern : this.tracer.getExcludePatterns()) {
            if (!PatternHelper.matchPattern((String)definition.getId(), (String)pattern)) continue;
            return false;
        }
        return true;
    }
}

