/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.keystone.KeystoneEndpoint;
import org.apache.camel.component.openstack.keystone.producer.AbstractKeystoneProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Group;
import org.openstack4j.model.identity.v3.builder.GroupBuilder;

public class GroupProducer
extends AbstractKeystoneProducer {
    public GroupProducer(KeystoneEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "addUserToGroup": {
                this.doAddUser(exchange);
                break;
            }
            case "checkUserGroup": {
                this.doCheckUserGroup(exchange);
                break;
            }
            case "removeUserFromGroup": {
                this.doRemoveUserFromGroup(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Group in = this.messageToGroup(exchange.getIn());
        Group out = this.osV3Client.identity().groups().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("groupId", String.class), String.class);
        StringHelper.notEmpty((String)id, (String)"Group ID");
        Group result = this.osV3Client.identity().groups().get(id);
        msg.setBody((Object)result);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.osV3Client.identity().groups().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Group group = this.messageToGroup(msg);
        Group updatedGroup = this.osV3Client.identity().groups().update(group);
        msg.setBody((Object)updatedGroup);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("groupId", String.class), String.class);
        StringHelper.notEmpty((String)id, (String)"Group ID");
        ActionResponse response = this.osV3Client.identity().groups().delete(id);
        this.checkFailure(response, msg, "Delete group with ID " + id);
    }

    private void doAddUser(Exchange exchange) {
        Message msg = exchange.getIn();
        String userId = (String)msg.getHeader("userId", String.class);
        String groupId = (String)msg.getHeader("groupId", String.class);
        StringHelper.notEmpty((String)userId, (String)"User ID");
        StringHelper.notEmpty((String)groupId, (String)"Group ID");
        ActionResponse response = this.osV3Client.identity().groups().addUserToGroup(groupId, userId);
        this.checkFailure(response, msg, String.format("Add user %s to group %s", userId, groupId));
    }

    private void doCheckUserGroup(Exchange exchange) {
        Message msg = exchange.getIn();
        String userId = (String)msg.getHeader("userId", String.class);
        String groupId = (String)msg.getHeader("groupId", String.class);
        StringHelper.notEmpty((String)userId, (String)"User ID");
        StringHelper.notEmpty((String)groupId, (String)"Group ID");
        ActionResponse response = this.osV3Client.identity().groups().checkGroupUser(groupId, userId);
        msg.setBody((Object)response.isSuccess());
    }

    private void doRemoveUserFromGroup(Exchange exchange) {
        Message msg = exchange.getIn();
        String userId = (String)msg.getHeader("userId", String.class);
        String groupId = (String)msg.getHeader("groupId", String.class);
        StringHelper.notEmpty((String)userId, (String)"User ID");
        StringHelper.notEmpty((String)groupId, (String)"Group ID");
        ActionResponse response = this.osV3Client.identity().groups().removeUserFromGroup(groupId, userId);
        this.checkFailure(response, msg, String.format("Delete user %s from group %s", userId, groupId));
    }

    private Group messageToGroup(Message message) {
        Group group = (Group)message.getBody(Group.class);
        if (group == null) {
            Map headers = message.getHeaders();
            GroupBuilder builder = Builders.group();
            StringHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            if (headers.containsKey("domainId")) {
                builder.domainId((String)message.getHeader("domainId", String.class));
            }
            if (headers.containsKey("description")) {
                builder.description((String)message.getHeader("description", String.class));
            }
            group = (Group)builder.build();
        }
        return group;
    }
}

