/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.opensearch.OpensearchConfiguration;
import org.apache.camel.component.opensearch.OpensearchEndpoint;
import org.apache.camel.component.opensearch.OpensearchOperation;
import org.apache.camel.component.opensearch.OpensearchScrollRequestIterator;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch._types.WriteResponseBase;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.MgetRequest;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.MsearchRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.opensearch.client.opensearch.core.msearch.MultiSearchResult;
import org.opensearch.client.opensearch.core.search.SearchResult;
import org.opensearch.client.opensearch.indices.DeleteIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.sniff.Sniffer;
import org.opensearch.client.sniff.SnifferBuilder;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpensearchProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchProducer.class);
    protected final OpensearchConfiguration configuration;
    private final Object mutex = new Object();
    private volatile RestClient client;
    private Sniffer sniffer;

    public OpensearchProducer(OpensearchEndpoint endpoint, OpensearchConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.client = endpoint.getClient();
    }

    private OpensearchOperation resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request != null) {
            LOG.debug("Operation request body: {}", request);
        }
        if (request instanceof IndexRequest) {
            return OpensearchOperation.Index;
        }
        if (request instanceof GetRequest) {
            return OpensearchOperation.GetById;
        }
        if (request instanceof MgetRequest) {
            return OpensearchOperation.MultiGet;
        }
        if (request instanceof UpdateRequest) {
            return OpensearchOperation.Update;
        }
        if (request instanceof BulkRequest) {
            return OpensearchOperation.Bulk;
        }
        if (request instanceof DeleteRequest) {
            return OpensearchOperation.Delete;
        }
        if (request instanceof SearchRequest) {
            return OpensearchOperation.Search;
        }
        if (request instanceof MsearchRequest) {
            return OpensearchOperation.MultiSearch;
        }
        if (request instanceof DeleteIndexRequest) {
            return OpensearchOperation.DeleteIndex;
        }
        OpensearchOperation operationConfig = (OpensearchOperation)((Object)exchange.getIn().getHeader("operation", OpensearchOperation.class));
        LOG.debug("Operation obtained from header {}: {}", (Object)"operation", (Object)operationConfig);
        if (operationConfig == null) {
            operationConfig = this.configuration.getOperation();
        }
        LOG.debug("Operation obtained from config: {}", (Object)operationConfig);
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value is mandatory");
        }
        return operationConfig;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Class<?> documentClass;
            Integer from;
            Integer size;
            if (this.configuration.isDisconnect() && this.client == null) {
                this.startClient();
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            RestClientTransport transport = new RestClientTransport(this.client, (JsonpMapper)new JacksonJsonpMapper(mapper));
            Message message = exchange.getIn();
            OpensearchOperation operation = this.resolveOperation(exchange);
            boolean configIndexName = false;
            String indexName = (String)message.getHeader("indexName", String.class);
            if (indexName == null) {
                message.setHeader("indexName", (Object)this.configuration.getIndexName());
                configIndexName = true;
            }
            if ((size = (Integer)message.getHeader("size", Integer.class)) == null) {
                message.setHeader("size", (Object)this.configuration.getSize());
            }
            if ((from = (Integer)message.getHeader("from", Integer.class)) == null) {
                message.setHeader("from", (Object)this.configuration.getFrom());
            }
            boolean configWaitForActiveShards = false;
            Integer waitForActiveShards = (Integer)message.getHeader("waitForActiveShards", Integer.class);
            if (waitForActiveShards == null) {
                message.setHeader("waitForActiveShards", (Object)this.configuration.getWaitForActiveShards());
                configWaitForActiveShards = true;
            }
            if ((documentClass = (Class<?>)message.getHeader("documentClass", Class.class)) == null) {
                documentClass = this.configuration.getDocumentClass();
            }
            ActionContext ctx = new ActionContext(exchange, callback, (OpenSearchTransport)transport, configIndexName, configWaitForActiveShards);
            switch (operation) {
                case Index: {
                    this.processIndexAsync(ctx);
                    break;
                }
                case Update: {
                    this.processUpdateAsync(ctx, documentClass);
                    break;
                }
                case GetById: {
                    this.processGetByIdAsync(ctx, documentClass);
                    break;
                }
                case Bulk: {
                    this.processBulkAsync(ctx);
                    break;
                }
                case Delete: {
                    this.processDeleteAsync(ctx);
                    break;
                }
                case DeleteIndex: {
                    this.processDeleteIndexAsync(ctx);
                    break;
                }
                case Exists: {
                    this.processExistsAsync(ctx);
                    break;
                }
                case Search: {
                    SearchRequest.Builder searchRequestBuilder = (SearchRequest.Builder)message.getBody(SearchRequest.Builder.class);
                    if (searchRequestBuilder == null) {
                        throw new IllegalArgumentException("Wrong body type. Only Map, String or SearchRequest.Builder is allowed as a type");
                    }
                    boolean useScroll = (Boolean)message.getHeader("useScroll", (Object)this.configuration.isUseScroll(), Boolean.class);
                    if (useScroll) {
                        int scrollKeepAliveMs = (Integer)message.getHeader("scrollKeepAliveMs", (Object)this.configuration.getScrollKeepAliveMs(), Integer.class);
                        OpensearchScrollRequestIterator scrollRequestIterator = new OpensearchScrollRequestIterator(searchRequestBuilder, new OpenSearchClient((OpenSearchTransport)transport), scrollKeepAliveMs, exchange, documentClass);
                        exchange.getIn().setBody(scrollRequestIterator);
                        this.cleanup(ctx);
                        callback.done(true);
                        return true;
                    }
                    this.onComplete((CompletableFuture)ctx.getClient().search(searchRequestBuilder.build(), documentClass).thenApply(SearchResult::hits), ctx);
                    break;
                }
                case MultiSearch: {
                    this.processMultiSearchAsync(ctx, documentClass);
                    break;
                }
                case MultiGet: {
                    this.processMultiGetAsync(ctx, documentClass);
                    break;
                }
                case Ping: {
                    this.processPingAsync(ctx);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("operation value '" + String.valueOf((Object)operation) + "' is not supported");
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    private void processPingAsync(ActionContext ctx) throws IOException {
        this.onComplete((CompletableFuture)ctx.getClient().ping().thenApply(BooleanResponse::value), ctx);
    }

    private void processMultiGetAsync(ActionContext ctx, Class<?> documentClass) throws IOException {
        MgetRequest.Builder mgetRequestBuilder = (MgetRequest.Builder)ctx.getMessage().getBody(MgetRequest.Builder.class);
        if (mgetRequestBuilder == null) {
            throw new IllegalArgumentException("Wrong body type. Only MgetRequest.Builder is allowed as a type");
        }
        this.onComplete((CompletableFuture)ctx.getClient().mget(mgetRequestBuilder.build(), documentClass).thenApply(MgetResponse::docs), ctx);
    }

    private void processMultiSearchAsync(ActionContext ctx, Class<?> documentClass) throws IOException {
        MsearchRequest.Builder msearchRequestBuilder = (MsearchRequest.Builder)ctx.getMessage().getBody(MsearchRequest.Builder.class);
        if (msearchRequestBuilder == null) {
            throw new IllegalArgumentException("Wrong body type. Only MsearchRequest.Builder is allowed as a type");
        }
        this.onComplete((CompletableFuture)ctx.getClient().msearch(msearchRequestBuilder.build(), documentClass).thenApply(MultiSearchResult::responses), ctx);
    }

    private void processExistsAsync(ActionContext ctx) throws IOException {
        ExistsRequest.Builder builder = new ExistsRequest.Builder();
        builder.index((String)ctx.getMessage().getHeader("indexName", String.class), new String[0]);
        this.onComplete((CompletableFuture)ctx.getClient().indices().exists(builder.build()).thenApply(BooleanResponse::value), ctx);
    }

    private void processDeleteIndexAsync(ActionContext ctx) throws IOException {
        DeleteIndexRequest.Builder deleteIndexRequestBuilder = (DeleteIndexRequest.Builder)ctx.getMessage().getBody(DeleteIndexRequest.Builder.class);
        if (deleteIndexRequestBuilder == null) {
            throw new IllegalArgumentException("Wrong body type. Only String or DeleteIndexRequest.Builder is allowed as a type");
        }
        this.onComplete((CompletableFuture)ctx.getClient().indices().delete(deleteIndexRequestBuilder.build()).thenApply(AcknowledgedResponseBase::acknowledged), ctx);
    }

    private void processDeleteAsync(ActionContext ctx) throws IOException {
        DeleteRequest.Builder deleteRequestBuilder = (DeleteRequest.Builder)ctx.getMessage().getBody(DeleteRequest.Builder.class);
        if (deleteRequestBuilder == null) {
            throw new IllegalArgumentException("Wrong body type. Only String or DeleteRequest.Builder is allowed as a type");
        }
        this.onComplete((CompletableFuture)ctx.getClient().delete(deleteRequestBuilder.build()).thenApply(WriteResponseBase::result), ctx);
    }

    private void processBulkAsync(ActionContext ctx) throws IOException {
        BulkRequest.Builder bulkRequestBuilder = (BulkRequest.Builder)ctx.getMessage().getBody(BulkRequest.Builder.class);
        if (bulkRequestBuilder == null) {
            throw new IllegalArgumentException("Wrong body type. Only Iterable or BulkRequest.Builder is allowed as a type");
        }
        this.onComplete((CompletableFuture)ctx.getClient().bulk(bulkRequestBuilder.build()).thenApply(BulkResponse::items), ctx);
    }

    private void processGetByIdAsync(ActionContext ctx, Class<?> documentClass) throws IOException {
        GetRequest.Builder getRequestBuilder = (GetRequest.Builder)ctx.getMessage().getBody(GetRequest.Builder.class);
        if (getRequestBuilder == null) {
            throw new IllegalArgumentException("Wrong body type. Only String or GetRequest.Builder is allowed as a type");
        }
        this.onComplete(ctx.getClient().get(getRequestBuilder.build(), documentClass), ctx);
    }

    private void processUpdateAsync(ActionContext ctx, Class<?> documentClass) throws IOException {
        UpdateRequest.Builder updateRequestBuilder = (UpdateRequest.Builder)ctx.getMessage().getBody(UpdateRequest.Builder.class);
        this.onComplete((CompletableFuture)ctx.getClient().update(updateRequestBuilder.build(), documentClass).thenApply(r -> ((UpdateResponse)r).id()), ctx);
    }

    private void processIndexAsync(ActionContext ctx) throws IOException {
        IndexRequest.Builder indexRequestBuilder = (IndexRequest.Builder)ctx.getMessage().getBody(IndexRequest.Builder.class);
        this.onComplete((CompletableFuture)ctx.getClient().index(indexRequestBuilder.build()).thenApply(WriteResponseBase::id), ctx);
    }

    private <T> void onComplete(CompletableFuture<T> future, ActionContext ctx) {
        Exchange exchange = ctx.exchange();
        ((CompletableFuture)((CompletableFuture)future.thenAccept(r -> exchange.getIn().setBody(r))).thenAccept(r -> this.cleanup(ctx))).whenComplete((r, e) -> {
            try {
                if (e != null) {
                    exchange.setException((Throwable)new CamelExchangeException("An error occurred while executing the action", exchange, e));
                }
            }
            finally {
                ctx.callback().done(false);
            }
        });
    }

    private void cleanup(ActionContext ctx) {
        try {
            Message message = ctx.getMessage();
            if (ctx.configIndexName()) {
                message.removeHeader("indexName");
            }
            if (ctx.configWaitForActiveShards()) {
                message.removeHeader("waitForActiveShards");
            }
            if (this.configuration.isDisconnect()) {
                IOHelper.close((Closeable)ctx.transport());
                if (this.configuration.isEnableSniffer()) {
                    IOHelper.close((Closeable)this.sniffer);
                    this.sniffer = null;
                }
                IOHelper.close((Closeable)this.client);
                this.client = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Could not execute the cleanup task", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.configuration.isDisconnect()) {
            this.startClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startClient() {
        if (this.client == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.client == null) {
                    LOG.info("Connecting to the OpenSearch cluster: {}", (Object)this.configuration.getClusterName());
                    if (this.configuration.getHostAddressesList() != null && !this.configuration.getHostAddressesList().isEmpty()) {
                        this.client = this.createClient();
                    } else {
                        LOG.warn("Incorrect ip address and port parameters settings for OpenSearch cluster");
                    }
                }
            }
        }
    }

    private RestClient createClient() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.configuration.getHostAddressesList().toArray(new HttpHost[0]));
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.configuration.getConnectionTimeout()).setSocketTimeout(this.configuration.getSocketTimeout()));
        if (this.configuration.getUser() != null && this.configuration.getPassword() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.getUser(), this.configuration.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> this.lambda$createClient$5((CredentialsProvider)credentialsProvider, arg_0));
        }
        RestClient restClient = builder.build();
        if (this.configuration.isEnableSniffer()) {
            SnifferBuilder snifferBuilder = Sniffer.builder((RestClient)restClient);
            snifferBuilder.setSniffIntervalMillis(this.configuration.getSnifferInterval());
            snifferBuilder.setSniffAfterFailureDelayMillis(this.configuration.getSniffAfterFailureDelay());
            this.sniffer = snifferBuilder.build();
        }
        return restClient;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            LOG.info("Disconnecting from OpenSearch cluster: {}", (Object)this.configuration.getClusterName());
            this.client.close();
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        super.doStop();
    }

    public RestClient getClient() {
        return this.client;
    }

    private SSLContext createSslContextFromCa() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getEndpoint().getCamelContext(), (String)this.configuration.getCertificatePath());
            Certificate trustedCa = factory.generateCertificate(resolveMandatoryResourceAsInputStream);
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$createClient$5(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.configuration.getCertificatePath() != null) {
            httpClientBuilder.setSSLContext(this.createSslContextFromCa());
        }
        return httpClientBuilder;
    }

    private record ActionContext(Exchange exchange, AsyncCallback callback, OpenSearchTransport transport, boolean configIndexName, boolean configWaitForActiveShards) {
        OpenSearchAsyncClient getClient() {
            return new OpenSearchAsyncClient(this.transport);
        }

        Message getMessage() {
            return this.exchange.getIn();
        }
    }
}

