/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.opensearch.aggregation;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;

public class BulkRequestAggregationStrategy
implements AggregationStrategy {
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Object objBody = newExchange.getIn().getBody();
        if (!(objBody instanceof BulkOperation[])) {
            throw new InvalidPayloadRuntimeException(newExchange, BulkOperation[].class);
        }
        BulkOperation[] newBody = (BulkOperation[])objBody;
        BulkRequest.Builder builder = new BulkRequest.Builder();
        builder.operations(List.of(newBody));
        if (oldExchange != null) {
            BulkRequest request = (BulkRequest)oldExchange.getIn().getBody(BulkRequest.class);
            builder.operations(request.operations());
        }
        newExchange.getIn().setBody((Object)builder.build());
        return oldExchange;
    }
}

