/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Server;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Server;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Filer;
import org.apache.camel.generator.openapi.AppendableGenerator;
import org.apache.camel.generator.openapi.DefaultDestinationGenerator;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.FilerGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.PathGenerator;
import org.apache.camel.generator.openapi.RestDslDefinitionGenerator;
import org.apache.camel.generator.openapi.RestDslSourceCodeGenerator;
import org.apache.camel.generator.openapi.RestDslXmlGenerator;
import org.apache.camel.generator.openapi.RestDslYamlGenerator;
import org.apache.camel.util.ObjectHelper;

public abstract class RestDslGenerator<G> {
    String apiContextPath;
    DestinationGenerator destinationGenerator;
    String destinationToSyntax;
    final OpenApiDocument document;
    OperationFilter filter = new OperationFilter();
    String restComponent;
    String restContextPath;
    boolean clientRequestValidation;
    boolean springBootProject;
    boolean springComponent;
    String basePath;
    String dtoPackageName;

    RestDslGenerator(OpenApiDocument document) {
        this.document = (OpenApiDocument)ObjectHelper.notNull((Object)document, (String)"document");
    }

    public G asSpringBootProject() {
        this.springBootProject = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G asSpringComponent() {
        this.springComponent = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withApiContextPath(String contextPath) {
        this.apiContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withClientRequestValidation() {
        this.clientRequestValidation = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withBasePath(String basePath) {
        this.basePath = basePath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withDestinationGenerator(DestinationGenerator destinationGenerator) {
        this.destinationGenerator = destinationGenerator;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withDestinationToSyntax(String destinationToSyntax) {
        this.destinationToSyntax = destinationToSyntax;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withOperationFilter(OperationFilter filter) {
        this.filter = filter;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withOperationFilter(String include) {
        this.filter.setIncludes(include);
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestComponent(String restComponent) {
        this.restComponent = restComponent;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestContextPath(String contextPath) {
        this.restContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withDtoPackageName(String dtoPackageName) {
        this.dtoPackageName = dtoPackageName;
        RestDslGenerator that = this;
        return (G)that;
    }

    DestinationGenerator destinationGenerator() {
        if (this.destinationGenerator == null) {
            this.destinationGenerator = this.destinationToSyntax != null ? new DefaultDestinationGenerator(this.destinationToSyntax) : new DefaultDestinationGenerator();
        }
        return this.destinationGenerator;
    }

    public static String determineBasePathFrom(String parameter, OpenApiDocument document) {
        return parameter != null ? RestDslGenerator.determineBasePathFrom(parameter) : RestDslGenerator.determineBasePathFrom(document);
    }

    public static String determineBasePathFrom(String parameter) {
        Objects.requireNonNull(parameter, "parameter");
        return RestDslGenerator.prepareBasePath(parameter.trim());
    }

    public static String determineBasePathFrom(OpenApiDocument document) {
        Objects.requireNonNull(document, "document");
        if (document instanceof OpenApi20Document) {
            return ((OpenApi20Document)document).getBasePath();
        }
        if (document instanceof OpenApi30Document) {
            OpenApi30Document oas30Document = (OpenApi30Document)document;
            List servers = oas30Document.getServers();
            if (servers == null || servers.get(0) == null) {
                return "";
            }
            OpenApi30Server firstServer = (OpenApi30Server)servers.get(0);
            URI serverUrl = URI.create(RestDslGenerator.resolveVariablesIn(firstServer.getUrl(), firstServer));
            return RestDslGenerator.prepareBasePath(serverUrl.getPath());
        }
        if (document instanceof OpenApi31Document) {
            OpenApi31Document oas31Document = (OpenApi31Document)document;
            List servers = oas31Document.getServers();
            if (servers == null || servers.get(0) == null) {
                return "";
            }
            OpenApi31Server firstServer = (OpenApi31Server)servers.get(0);
            URI serverUrl = URI.create(RestDslGenerator.resolveVariablesIn(firstServer.getUrl(), firstServer));
            return RestDslGenerator.prepareBasePath(serverUrl.getPath());
        }
        throw new IllegalArgumentException("Unsupported document type: " + document.getClass().getName());
    }

    private static String prepareBasePath(String basePath) {
        if (basePath == null || ((String)basePath).isEmpty()) {
            return "";
        }
        if (((String)basePath).charAt(0) != '/') {
            basePath = "/" + (String)basePath;
        }
        if (((String)basePath).indexOf("//") == 0) {
            basePath = ((String)basePath).substring(1);
        }
        if ("/".equals(basePath)) {
            basePath = "";
        }
        return basePath;
    }

    public static String determineHostFrom(OpenApiDocument document) {
        if (document instanceof OpenApi20Document) {
            return ((OpenApi20Document)document).getHost();
        }
        if (document instanceof OpenApi30Document) {
            OpenApi30Document oas30Document = (OpenApi30Document)document;
            List servers = oas30Document.getServers();
            if (servers == null || servers.get(0) == null) {
                return "";
            }
            OpenApi30Server firstServer = (OpenApi30Server)servers.get(0);
            URI serverUrl = URI.create(RestDslGenerator.resolveVariablesIn(firstServer.getUrl(), firstServer));
            return serverUrl.getHost();
        }
        throw new IllegalArgumentException("Unsupported document type: " + document.getClass().getName());
    }

    public static String resolveVariablesIn(String url, OpenApi30Server server) {
        Map variables = Objects.requireNonNull(server, "server").getVariables();
        String withoutPlaceholders = url;
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                String name = "{" + (String)entry.getKey() + "}";
                withoutPlaceholders = withoutPlaceholders.replace(name, ((ServerVariable)entry.getValue()).getDefault());
            }
        }
        return withoutPlaceholders;
    }

    public static String resolveVariablesIn(String url, OpenApi31Server server) {
        Map variables = Objects.requireNonNull(server, "server").getVariables();
        String withoutPlaceholders = url;
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                String name = "{" + (String)entry.getKey() + "}";
                withoutPlaceholders = withoutPlaceholders.replace(name, ((ServerVariable)entry.getValue()).getDefault());
            }
        }
        return withoutPlaceholders;
    }

    public static RestDslSourceCodeGenerator<Appendable> toAppendable(OpenApiDocument document) {
        return new AppendableGenerator(document);
    }

    public static RestDslDefinitionGenerator toDefinition(OpenApiDocument document) {
        return new RestDslDefinitionGenerator(document);
    }

    public static RestDslSourceCodeGenerator<Filer> toFiler(OpenApiDocument document) {
        return new FilerGenerator(document);
    }

    public static RestDslSourceCodeGenerator<Path> toPath(OpenApiDocument document) {
        return new PathGenerator(document);
    }

    public static RestDslXmlGenerator toXml(OpenApiDocument document) {
        return new RestDslXmlGenerator(document);
    }

    public static RestDslYamlGenerator toYaml(OpenApiDocument document) {
        return new RestDslYamlGenerator(document);
    }
}

