/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.generator.openapi.DestinationGenerator;

public class DefaultDestinationGenerator
implements DestinationGenerator {
    private final AtomicInteger counter = new AtomicInteger();
    private final String syntax;

    public DefaultDestinationGenerator() {
        this("direct:${operationId}");
    }

    public DefaultDestinationGenerator(String syntax) {
        this.syntax = syntax;
    }

    @Override
    public String generateDestinationFor(OpenApiOperation operation) {
        String answer = this.syntax;
        if (answer.contains("${operationId")) {
            String id = Optional.ofNullable(operation.getOperationId()).orElseGet(this::generateDirectName);
            answer = answer.replace("${operationId}", id);
        }
        return answer;
    }

    String generateDirectName() {
        return "rest" + this.counter.incrementAndGet();
    }
}

