/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.swagger.v3.core.filter.AbstractSpecFilter;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.ApiKeyDefinition;
import org.apache.camel.model.rest.BasicAuthDefinition;
import org.apache.camel.model.rest.BearerTokenDefinition;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.MutualTLSDefinition;
import org.apache.camel.model.rest.OAuth2Definition;
import org.apache.camel.model.rest.OpenIdConnectDefinition;
import org.apache.camel.model.rest.ParamDefinition;
import org.apache.camel.model.rest.ResponseHeaderDefinition;
import org.apache.camel.model.rest.ResponseMessageDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.OpenAPI3to2;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestModelConverters;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiReader {
    public static final String OAS20_SCHEMA_DEFINITION_PREFIX = "#/definitions/";
    public static final String OAS30_SCHEMA_DEFINITION_PREFIX = "#/components/schemas/";
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiReader.class);
    private static final Set<String> NO_REFERENCE_TYPE_NAMES = new HashSet<String>(Arrays.asList("byte", "char", "short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "string", "java.lang.String", "boolean", "java.lang.Boolean", "file", "java.io.File"));

    private static String getValue(CamelContext camelContext, String text) {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    private static List<String> getValue(CamelContext camelContext, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> answer = new ArrayList<String>();
        for (String line : list) {
            answer.add(camelContext.resolvePropertyPlaceholders(line));
        }
        return answer;
    }

    public OpenAPI read(CamelContext camelContext, List<RestDefinition> rests, BeanConfig config, String camelContextId, ClassResolver classResolver) throws ClassNotFoundException {
        OpenAPI openApi;
        OpenAPI openAPI = openApi = config.isOpenApi31() ? new OpenAPI(SpecVersion.V31) : new OpenAPI();
        if (config.getVersion() != null) {
            openApi.setOpenapi(config.getVersion());
        }
        for (RestDefinition rest : rests) {
            Boolean disabled = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)rest.getDisabled());
            if (disabled != null && disabled.booleanValue()) continue;
            this.parse(camelContext, openApi, rest, camelContextId, classResolver, config);
        }
        if ((openApi = this.shortenClassNames(openApi)).getPaths() == null) {
            openApi.setPaths(new Paths());
        }
        if (openApi.getTags() != null) {
            openApi.setTags(new ArrayList(openApi.getTags().stream().collect(Collectors.toMap(Tag::getName, Function.identity(), (prev, current) -> prev, LinkedHashMap::new)).values()));
        }
        openApi = config.configure(openApi);
        this.checkCompatOpenApi2(openApi, config);
        return openApi;
    }

    private void checkCompatOpenApi2(OpenAPI openApi, BeanConfig config) {
        if (config.isOpenApi2()) {
            OpenAPI3to2 converter = new OpenAPI3to2();
            converter.convertOpenAPI3to2(openApi);
        }
    }

    private void parse(CamelContext camelContext, OpenAPI openApi, RestDefinition rest, String camelContextId, ClassResolver classResolver, BeanConfig config) throws ClassNotFoundException {
        String[] stringArray;
        ArrayList<VerbDefinition> filter = new ArrayList<VerbDefinition>();
        for (VerbDefinition verb : rest.getVerbs()) {
            Boolean disabled = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)verb.getDisabled());
            if (disabled != null && disabled.booleanValue()) continue;
            filter.add(verb);
        }
        ArrayList<VerbDefinition> verbs = new ArrayList<VerbDefinition>(filter);
        verbs.sort(new VerbOrdering(camelContext));
        if (null != rest.getTag()) {
            stringArray = RestOpenApiReader.getValue(camelContext, rest.getTag()).split(",");
        } else if (null != rest.getPath()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = RestOpenApiReader.getValue(camelContext, rest.getPath());
        } else {
            stringArray = new String[]{};
        }
        String[] pathAsTags = stringArray;
        this.parseOas30(openApi, rest, pathAsTags);
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (VerbDefinition verb : verbs) {
            String apiDocs = verb.getApiDocs() != null ? verb.getApiDocs() : rest.getApiDocs();
            if (apiDocs != null && !Boolean.parseBoolean(apiDocs)) continue;
            String type = verb.getType();
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)type)) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)(type = verb.getOutType()))) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
            if (verb.getResponseMsgs() == null) continue;
            for (ResponseMessageDefinition def : verb.getResponseMsgs()) {
                type = def.getResponseModel();
                if (!org.apache.camel.util.ObjectHelper.isNotEmpty((String)type)) continue;
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                types.add(type);
            }
        }
        for (String type : types) {
            Class clazz = classResolver.resolveMandatoryClass(type);
            this.appendModels(clazz, openApi, config.isOpenApi31());
        }
        this.doParseVerbs(camelContext, openApi, rest, camelContextId, verbs, pathAsTags, config);
        List securityRequirements = rest.getSecurityRequirements();
        securityRequirements.forEach(requirement -> {
            SecurityRequirement oasRequirement = new SecurityRequirement();
            List<Object> scopes = requirement.getScopes() == null || requirement.getScopes().isBlank() ? Collections.emptyList() : Arrays.asList(requirement.getScopes().trim().split("\\s*,\\s*"));
            oasRequirement.addList(requirement.getKey(), scopes);
            openApi.addSecurityItem(oasRequirement);
        });
    }

    private void parseOas30(OpenAPI openApi, RestDefinition rest, String[] pathAsTags) {
        String summary = rest.getDescriptionText();
        for (String tag : pathAsTags) {
            openApi.addTagsItem(new Tag().name(tag).description(summary));
        }
        RestSecuritiesDefinition sd = rest.getSecurityDefinitions();
        if (sd != null && !sd.getSecurityDefinitions().isEmpty() && openApi.getComponents() == null) {
            openApi.setComponents(new Components());
        }
        if (sd != null) {
            for (RestSecurityDefinition def : sd.getSecurityDefinitions()) {
                SecurityScheme auth;
                ApiKeyDefinition rs;
                SecurityScheme auth2;
                if (def instanceof BasicAuthDefinition) {
                    auth2 = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic").description(def.getDescription());
                    openApi.getComponents().addSecuritySchemes(def.getKey(), auth2);
                    continue;
                }
                if (def instanceof BearerTokenDefinition) {
                    auth2 = new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").description(def.getDescription()).bearerFormat(((BearerTokenDefinition)def).getFormat());
                    openApi.getComponents().addSecuritySchemes(def.getKey(), auth2);
                    continue;
                }
                if (def instanceof ApiKeyDefinition) {
                    rs = (ApiKeyDefinition)def;
                    auth = new SecurityScheme().type(SecurityScheme.Type.APIKEY).name(rs.getName()).description(def.getDescription());
                    if (rs.getInHeader() != null && Boolean.parseBoolean(rs.getInHeader())) {
                        auth.setIn(SecurityScheme.In.HEADER);
                    } else if (rs.getInQuery() != null && Boolean.parseBoolean(rs.getInQuery())) {
                        auth.setIn(SecurityScheme.In.QUERY);
                    } else if (rs.getInCookie() != null && Boolean.parseBoolean(rs.getInCookie())) {
                        auth.setIn(SecurityScheme.In.COOKIE);
                    } else {
                        throw new IllegalStateException("No API Key location specified.");
                    }
                    openApi.getComponents().addSecuritySchemes(def.getKey(), auth);
                    continue;
                }
                if (def instanceof OAuth2Definition) {
                    rs = (OAuth2Definition)def;
                    auth = new SecurityScheme().type(SecurityScheme.Type.OAUTH2).description(def.getDescription());
                    String flow = rs.getFlow();
                    if (flow == null) {
                        flow = this.inferOauthFlow((OAuth2Definition)rs);
                    }
                    OAuthFlows oauthFlows = new OAuthFlows();
                    auth.setFlows(oauthFlows);
                    OAuthFlow oauthFlow = new OAuthFlow();
                    switch (flow) {
                        case "authorizationCode": 
                        case "accessCode": {
                            oauthFlows.setAuthorizationCode(oauthFlow);
                            break;
                        }
                        case "implicit": {
                            oauthFlows.setImplicit(oauthFlow);
                            break;
                        }
                        case "clientCredentials": 
                        case "application": {
                            oauthFlows.setClientCredentials(oauthFlow);
                            break;
                        }
                        case "password": {
                            oauthFlows.setPassword(oauthFlow);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid OAuth flow '" + flow + "' specified");
                        }
                    }
                    oauthFlow.setAuthorizationUrl(rs.getAuthorizationUrl());
                    oauthFlow.setTokenUrl(rs.getTokenUrl());
                    oauthFlow.setRefreshUrl(rs.getRefreshUrl());
                    if (!rs.getScopes().isEmpty()) {
                        oauthFlow.setScopes(new Scopes());
                        for (RestPropertyDefinition scope : rs.getScopes()) {
                            oauthFlow.getScopes().addString(scope.getKey(), scope.getValue());
                        }
                    }
                    openApi.getComponents().addSecuritySchemes(def.getKey(), auth);
                    continue;
                }
                if (def instanceof MutualTLSDefinition) {
                    auth2 = new SecurityScheme().type(SecurityScheme.Type.MUTUALTLS).description(def.getDescription());
                    openApi.getComponents().addSecuritySchemes(def.getKey(), auth2);
                    continue;
                }
                if (!(def instanceof OpenIdConnectDefinition)) continue;
                auth2 = new SecurityScheme().type(SecurityScheme.Type.OPENIDCONNECT).description(def.getDescription());
                auth2.setOpenIdConnectUrl(((OpenIdConnectDefinition)def).getUrl());
                openApi.getComponents().addSecuritySchemes(def.getKey(), auth2);
            }
        }
    }

    private String buildBasePath(CamelContext camelContext, RestDefinition rest) {
        Object basePath = FileUtil.stripLeadingSeparator((String)RestOpenApiReader.getValue(camelContext, rest.getPath()));
        if (basePath != null && !((String)basePath).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        return basePath;
    }

    private void doParseVerbs(CamelContext camelContext, OpenAPI openApi, RestDefinition rest, String camelContextId, List<VerbDefinition> verbs, String[] pathAsTags, BeanConfig config) {
        String basePath = this.buildBasePath(camelContext, rest);
        for (VerbDefinition verb : verbs) {
            String produces;
            String operationId;
            PathItem path;
            String apiDocs = verb.getApiDocs() != null ? RestOpenApiReader.getValue(camelContext, verb.getApiDocs()) : RestOpenApiReader.getValue(camelContext, rest.getApiDocs());
            if (apiDocs != null && !Boolean.parseBoolean(apiDocs)) continue;
            String method = verb.asVerb().toLowerCase(Locale.US);
            String opPath = OpenApiHelper.buildUrl(basePath, RestOpenApiReader.getValue(camelContext, verb.getPath()));
            if (openApi.getPaths() == null) {
                openApi.paths(new Paths());
            }
            if ((path = (PathItem)openApi.getPaths().get((Object)opPath)) == null) {
                path = new PathItem();
            }
            Operation op = new Operation();
            for (String tag : pathAsTags) {
                op.addTagsItem(tag);
            }
            if (verb.getId() != null) {
                operationId = RestOpenApiReader.getValue(camelContext, verb.getId());
            } else if (rest.getId() != null) {
                operationId = RestOpenApiReader.getValue(camelContext, rest.getId());
            } else {
                verb.idOrCreate((NodeIdFactory)camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
                operationId = verb.getId();
            }
            op.setOperationId(operationId);
            op.addExtension("x-camelContextId", (Object)camelContextId);
            path.operation(PathItem.HttpMethod.valueOf((String)method.toUpperCase()), op);
            String consumes = RestOpenApiReader.getValue(camelContext, verb.getConsumes() != null ? verb.getConsumes() : rest.getConsumes());
            if (consumes == null) {
                consumes = config.defaultConsumes;
            }
            if ((produces = RestOpenApiReader.getValue(camelContext, verb.getProduces() != null ? verb.getProduces() : rest.getProduces())) == null) {
                produces = config.defaultProduces;
            }
            this.doParseVerb(camelContext, openApi, verb, op, consumes, produces);
            this.doParseResponseMessages(camelContext, openApi, verb, op, produces);
            openApi.getPaths().addPathItem(opPath, path);
        }
    }

    private void doParseVerb(CamelContext camelContext, OpenAPI openApi, VerbDefinition verb, Operation op, String consumes, String produces) {
        if (verb.getDescriptionText() != null) {
            op.setSummary(RestOpenApiReader.getValue(camelContext, verb.getDescriptionText()));
        }
        if ("true".equals(verb.getDeprecated())) {
            op.setDeprecated(Boolean.TRUE);
        }
        for (SecurityDefinition sd : verb.getSecurity()) {
            ArrayList<String> scopes = new ArrayList<String>();
            if (sd.getScopes() != null) {
                for (String scope : ObjectHelper.createIterable((String)RestOpenApiReader.getValue(camelContext, sd.getScopes()))) {
                    scopes.add(scope);
                }
            }
            SecurityRequirement securityRequirement = new SecurityRequirement();
            securityRequirement.addList(RestOpenApiReader.getValue(camelContext, sd.getKey()), scopes);
            op.addSecurityItem(securityRequirement);
        }
        for (ParamDefinition param : verb.getParams()) {
            String[] parts;
            Parameter parameter = new Parameter().in(param.getType().name());
            if (parameter == null) continue;
            parameter.setName(RestOpenApiReader.getValue(camelContext, param.getName()));
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)param.getDescription())) {
                parameter.setDescription(RestOpenApiReader.getValue(camelContext, param.getDescription()));
            }
            parameter.setRequired(param.getRequired());
            if (!"body".equals(parameter.getIn())) {
                boolean hasAllowableValues;
                Schema schema = new Schema();
                boolean isArray = RestOpenApiReader.getValue(camelContext, param.getDataType()).equalsIgnoreCase("array");
                List<String> allowableValues = RestOpenApiReader.getValue(camelContext, param.getAllowableValuesAsStringList());
                boolean bl = hasAllowableValues = allowableValues != null && !allowableValues.isEmpty();
                if (param.getDataType() != null) {
                    String arrayType;
                    parameter.setSchema(schema);
                    String[] type = RestOpenApiReader.getValue(camelContext, param.getDataType());
                    schema.setType((String)type);
                    if (openApi.getSpecVersion().equals((Object)SpecVersion.V31)) {
                        schema.addType((String)type);
                    }
                    if (param.getDataFormat() != null) {
                        schema.setFormat(RestOpenApiReader.getValue(camelContext, param.getDataFormat()));
                    }
                    if (isArray && (arrayType = RestOpenApiReader.getValue(camelContext, param.getArrayType())) != null) {
                        if (arrayType.equalsIgnoreCase("string")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, String.class);
                        }
                        if (arrayType.equalsIgnoreCase("int") || arrayType.equalsIgnoreCase("integer")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, Integer.class);
                        }
                        if (arrayType.equalsIgnoreCase("long")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, Long.class);
                        }
                        if (arrayType.equalsIgnoreCase("float")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, Float.class);
                        }
                        if (arrayType.equalsIgnoreCase("double")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, Double.class);
                        }
                        if (arrayType.equalsIgnoreCase("boolean")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, Boolean.class);
                        }
                        if (arrayType.equalsIgnoreCase("byte")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, ByteArraySchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("binary")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, BinarySchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("date")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, DateSchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("date-time")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, DateTimeSchema.class);
                        }
                        if (arrayType.equalsIgnoreCase("password")) {
                            RestOpenApiReader.defineSchemas(parameter, allowableValues, PasswordSchema.class);
                        }
                    }
                }
                if (param.getCollectionFormat() != null) {
                    parameter.setStyle(this.convertToOpenApiStyle(RestOpenApiReader.getValue(camelContext, param.getCollectionFormat().name())));
                }
                if (hasAllowableValues && !isArray) {
                    schema.setEnum(allowableValues);
                }
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)param.getDefaultValue())) {
                    schema.setDefault((Object)RestOpenApiReader.getValue(camelContext, param.getDefaultValue()));
                }
                if (param.getExamples() != null && !param.getExamples().isEmpty()) {
                    for (RestPropertyDefinition example : param.getExamples()) {
                        if (example.getKey().isEmpty()) {
                            if (parameter.getExample() != null) {
                                LOG.warn("The parameter already has an example with no key!");
                            }
                            parameter.setExample((Object)example.getValue());
                            continue;
                        }
                        parameter.addExample(example.getKey(), new Example().value((Object)example.getValue()));
                    }
                }
                op.addParametersItem(parameter);
            }
            if (!parameter.getIn().equals("body")) continue;
            RequestBody reqBody = new RequestBody().content(new Content());
            reqBody.setRequired(param.getRequired());
            reqBody.setDescription(RestOpenApiReader.getValue(camelContext, param.getDescription()));
            op.setRequestBody(reqBody);
            String type = RestOpenApiReader.getValue(camelContext, param.getDataType() != null ? param.getDataType() : verb.getType());
            Schema bodySchema = null;
            if (type != null) {
                if (type.endsWith("[]")) {
                    type = type.substring(0, type.length() - 2);
                    bodySchema = this.modelTypeAsProperty(type, openApi);
                } else {
                    String ref = this.modelTypeAsRef(type, openApi);
                    bodySchema = ref != null ? new Schema().$ref(OAS30_SCHEMA_DEFINITION_PREFIX + ref) : this.modelTypeAsProperty(type, openApi);
                }
            }
            if (consumes == null) continue;
            for (String part : parts = consumes.split(",")) {
                MediaType mediaType = new MediaType().schema(bodySchema);
                if (param.getExamples() != null) {
                    for (RestPropertyDefinition example : param.getExamples()) {
                        if (!part.equals(example.getKey())) continue;
                        mediaType.setExample((Object)example.getValue());
                    }
                }
                reqBody.getContent().addMediaType(part, mediaType);
            }
        }
        if (op.getParameters() != null && op.getParameters().isEmpty()) {
            op.setParameters(null);
        }
        if (verb.getOutType() != null) {
            if (op.getResponses() == null) {
                op.setResponses(new ApiResponses());
            }
            if (produces != null) {
                String[] parts;
                for (String produce : parts = produces.split(",")) {
                    ApiResponse response = new ApiResponse().description("Output type");
                    Content responseContent = new Content();
                    MediaType contentType = new MediaType();
                    responseContent.addMediaType(produce, contentType);
                    Schema<?> model = this.modelTypeAsProperty(RestOpenApiReader.getValue(camelContext, verb.getOutType()), openApi);
                    contentType.setSchema(model);
                    response.setContent(responseContent);
                    op.getResponses().addApiResponse("200", response);
                }
            }
        }
    }

    private Parameter.StyleEnum convertToOpenApiStyle(String value) {
        switch (CollectionFormat.valueOf((String)value)) {
            case csv: {
                return Parameter.StyleEnum.FORM;
            }
            case ssv: 
            case tsv: {
                return Parameter.StyleEnum.SPACEDELIMITED;
            }
            case pipes: {
                return Parameter.StyleEnum.PIPEDELIMITED;
            }
            case multi: {
                return Parameter.StyleEnum.DEEPOBJECT;
            }
        }
        return null;
    }

    private static void defineSchemas(Parameter serializableParameter, List<String> allowableValues, Class<?> type) {
        Schema parameterSchema = serializableParameter.getSchema();
        if (allowableValues != null && !allowableValues.isEmpty()) {
            if (String.class.equals(type)) {
                parameterSchema.setEnum(allowableValues);
            } else {
                RestOpenApiReader.convertAndSetItemsEnum(parameterSchema, allowableValues, type);
            }
        }
        if (Objects.equals(parameterSchema.getType(), "array")) {
            Object itemsSchema = Integer.class.equals(type) ? new IntegerSchema() : (Long.class.equals(type) ? new IntegerSchema().format("int64") : (Float.class.equals(type) ? new NumberSchema().format("float") : (Double.class.equals(type) ? new NumberSchema().format("double") : (Boolean.class.equals(type) ? new BooleanSchema() : (ByteArraySchema.class.equals(type) ? new ByteArraySchema() : (BinarySchema.class.equals(type) ? new BinarySchema() : (DateSchema.class.equals(type) ? new DateSchema() : (DateTimeSchema.class.equals(type) ? new DateTimeSchema() : (PasswordSchema.class.equals(type) ? new PasswordSchema() : new StringSchema())))))))));
            parameterSchema.setItems((Schema)itemsSchema);
        }
    }

    private static void convertAndSetItemsEnum(Schema items, List<String> allowableValues, Class<?> type) {
        try {
            Method castSchema;
            MethodHandle valueOf = ClassUtils.isPrimitiveWrapper(type) ? MethodHandles.publicLookup().findStatic(type, "valueOf", MethodType.methodType(type, String.class)) : null;
            MethodHandle setEnum = MethodHandles.publicLookup().bind(items, "setEnum", MethodType.methodType(Void.TYPE, List.class));
            Method method = castSchema = type.getSuperclass().equals(Schema.class) ? type.getDeclaredMethod("cast", Object.class) : null;
            if (castSchema != null) {
                castSchema.setAccessible(true);
            }
            Object schema = castSchema != null ? type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
            List values = allowableValues.stream().map(v -> {
                try {
                    if (valueOf != null) {
                        return valueOf.invoke((String)v);
                    }
                    if (castSchema != null) {
                        return castSchema.invoke(schema, v);
                    }
                    throw new RuntimeException("Can not convert allowable value " + v);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            setEnum.invoke(values);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    private void doParseResponseMessages(CamelContext camelContext, OpenAPI openApi, VerbDefinition verb, Operation op, String produces) {
        if (op.getResponses() == null) {
            op.setResponses(new ApiResponses());
        }
        for (ResponseMessageDefinition msg : verb.getResponseMsgs()) {
            this.doParseResponse(camelContext, openApi, op, produces, msg);
        }
        if (op.getResponses().isEmpty()) {
            op.getResponses().addApiResponse("default", new ApiResponse());
        }
    }

    private void doParseResponse(CamelContext camelContext, OpenAPI openApi, Operation op, String produces, ResponseMessageDefinition msg) {
        ApiResponse response = null;
        String code = RestOpenApiReader.getValue(camelContext, msg.getCode());
        response = (ApiResponse)op.getResponses().get((Object)code);
        if (response == null) {
            response = new ApiResponse();
            op.getResponses().addApiResponse(code, response);
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)msg.getResponseModel()) && produces != null) {
            Content respContent = new Content();
            String[] parts = produces.split(",");
            for (String produce : parts) {
                Schema<?> model = this.modelTypeAsProperty(RestOpenApiReader.getValue(camelContext, msg.getResponseModel()), openApi);
                respContent.addMediaType(produce, new MediaType().schema(model));
            }
            response.setContent(respContent);
        }
        if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)msg.getMessage())) {
            response.setDescription(RestOpenApiReader.getValue(camelContext, msg.getMessage()));
        }
        if (msg.getHeaders() != null) {
            for (ResponseHeaderDefinition header : msg.getHeaders()) {
                String name = RestOpenApiReader.getValue(camelContext, header.getName());
                String type = RestOpenApiReader.getValue(camelContext, header.getDataType());
                String format = RestOpenApiReader.getValue(camelContext, header.getDataFormat());
                if ("string".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "boolean".equals(type)) {
                    this.setResponseHeader(camelContext, response, header, name, format, type);
                    continue;
                }
                if ("int".equals(type) || "integer".equals(type)) {
                    this.setResponseHeader(camelContext, response, header, name, format, "integer");
                    continue;
                }
                if (!"array".equals(type)) continue;
                Header ap = new Header();
                response.addHeaderObject(name, ap);
                if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)header.getDescription())) {
                    ap.setDescription(RestOpenApiReader.getValue(camelContext, header.getDescription()));
                }
                if (header.getArrayType() != null) {
                    String arrayType = RestOpenApiReader.getValue(camelContext, header.getArrayType());
                    if (arrayType.equalsIgnoreCase("string") || arrayType.equalsIgnoreCase("long") || arrayType.equalsIgnoreCase("float") || arrayType.equalsIgnoreCase("double") || arrayType.equalsIgnoreCase("boolean")) {
                        this.setHeaderSchemaOas30(ap, arrayType);
                    } else if (arrayType.equalsIgnoreCase("int") || arrayType.equalsIgnoreCase("integer")) {
                        this.setHeaderSchemaOas30(ap, "integer");
                    }
                }
                if (header.getExample() == null) continue;
                ap.addExample("", new Example().value((Object)RestOpenApiReader.getValue(camelContext, header.getExample())));
            }
        }
        if (msg.getExamples() != null && response.getContent() != null) {
            for (MediaType mediaType : response.getContent().values()) {
                for (RestPropertyDefinition prop : msg.getExamples()) {
                    mediaType.addExamples(RestOpenApiReader.getValue(camelContext, prop.getKey()), new Example().value((Object)RestOpenApiReader.getValue(camelContext, prop.getValue())));
                }
            }
        }
    }

    private void setHeaderSchemaOas30(Header ap, String arrayType) {
        Schema items = new Schema().type(arrayType);
        ap.setSchema(items);
    }

    private void setResponseHeader(CamelContext camelContext, ApiResponse response, ResponseHeaderDefinition header, String name, String format, String type) {
        Header ip = new Header();
        response.addHeaderObject(name, ip);
        Schema schema = new Schema().type(type);
        ip.setSchema(schema);
        if (format != null) {
            schema.setFormat(format);
        }
        ip.setDescription(RestOpenApiReader.getValue(camelContext, header.getDescription()));
        if (header.getAllowableValues() != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (String text : header.getAllowableValuesAsStringList()) {
                values.add(RestOpenApiReader.getValue(camelContext, text));
            }
            schema.setEnum(values);
        }
        if (header.getExample() != null) {
            ip.addExample("", new Example().value((Object)RestOpenApiReader.getValue(camelContext, header.getExample())));
        }
    }

    private String modelTypeAsRef(String typeName, OpenAPI openApi) {
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if (NO_REFERENCE_TYPE_NAMES.contains(typeName)) {
            return null;
        }
        if (openApi.getComponents() != null && openApi.getComponents().getSchemas() != null) {
            for (Schema model : openApi.getComponents().getSchemas().values()) {
                if (!typeName.equals(this.getClassNameExtension(model))) continue;
                return model.getName();
            }
        }
        return null;
    }

    private Object getClassNameExtension(Schema model) {
        Object value;
        Object className = null;
        if (model.getExtensions() != null && (value = model.getExtensions().get("x-className")) instanceof Map) {
            className = ((Map)value).get("format");
        }
        return className;
    }

    private Schema<?> modelTypeAsProperty(String typeName, OpenAPI openApi) {
        String ref;
        Object prop = null;
        boolean array = typeName.endsWith("[]");
        if (array) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((ref = this.modelTypeAsRef(typeName, openApi)) == null) {
            if (array && ("byte".equals(typeName) || "java.lang.Byte".equals(typeName))) {
                prop = new Schema().type("number").format("byte");
                array = false;
            } else {
                prop = "string".equalsIgnoreCase(typeName) || "java.lang.String".equals(typeName) ? new StringSchema() : ("int".equals(typeName) || "java.lang.Integer".equals(typeName) ? new IntegerSchema() : ("long".equals(typeName) || "java.lang.Long".equals(typeName) ? new IntegerSchema().format("int64") : ("float".equals(typeName) || "java.lang.Float".equals(typeName) ? new NumberSchema().format("float") : ("double".equals(typeName) || "java.lang.Double".equals(typeName) ? new NumberSchema().format("double") : ("boolean".equals(typeName) || "java.lang.Boolean".equals(typeName) ? new NumberSchema().format("boolean") : ("file".equals(typeName) || "java.io.File".equals(typeName) ? new FileSchema() : new StringSchema()))))));
            }
        }
        if (array) {
            Schema items = new Schema();
            if (ref != null) {
                items.set$ref(OAS30_SCHEMA_DEFINITION_PREFIX + ref);
            }
            prop = new ArraySchema().items(items);
        } else if (prop == null) {
            prop = new Schema().$ref(OAS30_SCHEMA_DEFINITION_PREFIX + ref);
        }
        return prop;
    }

    private void appendModels(Class<?> clazz, OpenAPI openApi, boolean openapi31) {
        RestModelConverters converters = new RestModelConverters(openapi31);
        List<Schema<?>> models = converters.readClass(openApi, clazz);
        if (models == null) {
            return;
        }
        if (openApi.getComponents() == null) {
            openApi.setComponents(new Components());
        }
        for (Schema<?> newSchema : models) {
            Schema existing;
            boolean addSchema = true;
            if (openApi.getComponents().getSchemas() != null && (existing = (Schema)openApi.getComponents().getSchemas().get(newSchema.getName())) != null) {
                Object oldClassName = this.getClassNameExtension(existing);
                Object newClassName = this.getClassNameExtension(newSchema);
                if (oldClassName != null) {
                    addSchema = false;
                    LOG.info("Duplicate schema found for with name {}; classname1={}, classname2={}", new Object[]{newSchema.getName(), oldClassName, newClassName != null ? newClassName : "none"});
                }
            }
            if (!addSchema) continue;
            openApi.getComponents().addSchemas(newSchema.getName(), newSchema);
        }
    }

    private OpenAPI shortenClassNames(OpenAPI document) {
        if (document.getComponents() == null || document.getComponents().getSchemas() == null) {
            return document;
        }
        HashMap<String, String> names = new HashMap<String, String>();
        Stream schemaStream = document.getComponents().getSchemas().keySet().stream();
        schemaStream.forEach(key -> {
            String s = key.replaceAll("[^a-zA-Z0-9.-_]", "_");
            String shortName = s.substring(s.lastIndexOf(46) + 1);
            names.put((String)key, names.containsValue(shortName) ? s : shortName);
        });
        for (Map.Entry namePair : names.entrySet()) {
            Schema schema = (Schema)document.getComponents().getSchemas().get(namePair.getKey());
            if (schema == null) continue;
            document.getComponents().getSchemas().remove(namePair.getKey());
            document.getComponents().addSchemas((String)namePair.getValue(), schema);
        }
        SchemaFilter filter = new SchemaFilter(names);
        return new SpecFilter().filter(document, (OpenAPISpecFilter)filter, null, null, null);
    }

    private String inferOauthFlow(OAuth2Definition rs) {
        String flow;
        if (rs.getAuthorizationUrl() != null && rs.getTokenUrl() != null) {
            flow = "authorizationCode";
        } else if (rs.getTokenUrl() == null && rs.getAuthorizationUrl() != null) {
            flow = "implicit";
        } else {
            throw new IllegalStateException("Error inferring OAuth flow");
        }
        return flow;
    }

    private static class VerbOrdering
    implements Comparator<VerbDefinition> {
        private final CamelContext camelContext;

        public VerbOrdering(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        @Override
        public int compare(VerbDefinition a, VerbDefinition b) {
            int num;
            String u1 = "";
            if (a.getPath() != null) {
                u1 = RestOpenApiReader.getValue(this.camelContext, a.getPath()).replace("{", "_");
            }
            String u2 = "";
            if (b.getPath() != null) {
                u2 = RestOpenApiReader.getValue(this.camelContext, b.getPath()).replace("{", "_");
            }
            if ((num = u1.compareTo(u2)) == 0) {
                num = a.asVerb().compareTo(b.asVerb());
            }
            return num;
        }
    }

    private static class SchemaFilter
    extends AbstractSpecFilter {
        private final Map<String, String> names;

        SchemaFilter(Map<String, String> names) {
            this.names = names;
        }

        public Optional<Parameter> filterParameter(Parameter parameter, Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
            if (parameter.getContent() != null) {
                this.processRefsInContent(parameter.getContent(), params, cookies, headers);
            }
            return Optional.of(parameter);
        }

        public Optional<RequestBody> filterRequestBody(RequestBody requestBody, Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
            if (requestBody.getContent() != null) {
                this.processRefsInContent(requestBody.getContent(), params, cookies, headers);
            }
            return Optional.of(requestBody);
        }

        public Optional<ApiResponse> filterResponse(ApiResponse response, Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
            if (response.getContent() != null) {
                this.processRefsInContent(response.getContent(), params, cookies, headers);
            }
            return Optional.of(response);
        }

        public Optional<Schema> filterSchema(Schema schema, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
            if (schema.getName() != null) {
                schema.setName(this.fixSchemaReference(schema.getName(), RestOpenApiReader.OAS30_SCHEMA_DEFINITION_PREFIX));
            }
            if (schema.get$ref() != null) {
                schema.set$ref(this.fixSchemaReference(schema.get$ref(), RestOpenApiReader.OAS30_SCHEMA_DEFINITION_PREFIX));
            }
            if (schema.getItems() != null) {
                this.filterSchema(schema.getItems(), params, cookies, headers);
            }
            if (schema.getProperties() != null) {
                for (Schema propSchema : schema.getProperties().values()) {
                    this.filterSchema(propSchema, params, cookies, headers);
                }
            }
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                this.filterSchema((Schema)schema.getAdditionalProperties(), params, cookies, headers);
            }
            if (schema.getAnyOf() != null) {
                List any = schema.getAnyOf();
                for (Schema child : any) {
                    this.filterSchema(child, params, cookies, headers);
                }
            }
            if (schema.getAllOf() != null) {
                List all = schema.getAllOf();
                for (Schema child : all) {
                    this.filterSchema(child, params, cookies, headers);
                }
            }
            if (schema.getOneOf() != null) {
                List oneOf = schema.getOneOf();
                for (Schema child : oneOf) {
                    this.filterSchema(child, params, cookies, headers);
                }
            }
            return Optional.of(schema);
        }

        private void processRefsInContent(Content content, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
            for (MediaType media : content.values()) {
                if (media.getSchema() == null) continue;
                this.filterSchema(media.getSchema(), params, cookies, headers);
            }
        }

        private String fixSchemaReference(String ref, String prefix) {
            String name;
            if (ref.startsWith(prefix)) {
                ref = ref.substring(prefix.length());
            }
            return (name = this.names.get(ref)) == null ? ref : name;
        }
    }
}

