/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.models.ArrayModel;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.PasswordProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPI3to2 {
    private Swagger openApi2;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void convertOpenAPI3to2(OpenAPI openApi3) {
        this.openApi2 = new Swagger().info(this.convertInfo(openApi3.getInfo())).tags(this.getTags(openApi3.getTags())).paths(this.getPaths(openApi3.getPaths()));
        this.setServerInfo(this.openApi2, openApi3.getServers());
        if (openApi3.getComponents() != null && openApi3.getComponents().getSchemas() != null) {
            for (Map.Entry entry : openApi3.getComponents().getSchemas().entrySet()) {
                this.openApi2.addDefinition((String)entry.getKey(), this.convertSchema((Schema)entry.getValue()));
            }
        }
        if (openApi3.getComponents() != null && openApi3.getComponents().getSecuritySchemes() != null) {
            this.convertSecurityDefinitions(openApi3.getComponents().getSecuritySchemes());
        }
        if (openApi3.getSecurity() != null) {
            for (SecurityRequirement sr : openApi3.getSecurity()) {
                this.openApi2.addSecurity(this.convertSecurityRequirement(sr));
            }
        }
    }

    private io.swagger.models.SecurityRequirement convertSecurityRequirement(SecurityRequirement sr) {
        io.swagger.models.SecurityRequirement sreq = new io.swagger.models.SecurityRequirement();
        for (Map.Entry reqMap : sr.entrySet()) {
            sreq.requirement((String)reqMap.getKey(), (List)reqMap.getValue());
        }
        return sreq;
    }

    private void convertSecurityDefinitions(Map<String, SecurityScheme> securitySchemes) {
        for (Map.Entry<String, SecurityScheme> entry : securitySchemes.entrySet()) {
            this.openApi2.addSecurityDefinition(entry.getKey(), this.convertSecurityScheme(entry.getValue()));
        }
    }

    private SecuritySchemeDefinition convertSecurityScheme(SecurityScheme securityScheme) {
        BasicAuthDefinition swaggerScheme = null;
        switch (securityScheme.getType()) {
            case HTTP: {
                if ("basic".equals(securityScheme.getScheme())) {
                    swaggerScheme = new BasicAuthDefinition();
                    break;
                }
                throw new IllegalStateException("OpenAPI 2.0 does not support bearer token security schemes.");
            }
            case APIKEY: {
                if (securityScheme.getIn() == SecurityScheme.In.COOKIE) {
                    throw new IllegalStateException("Invalid 'in' value for API Key security scheme");
                }
                swaggerScheme = new ApiKeyAuthDefinition(securityScheme.getName(), In.forValue((String)securityScheme.getIn().name()));
                break;
            }
            case OAUTH2: {
                OAuth2Definition oauth2 = new OAuth2Definition();
                OAuthFlows flows = securityScheme.getFlows();
                Scopes scopes = null;
                if (flows.getImplicit() != null) {
                    oauth2.implicit(flows.getImplicit().getAuthorizationUrl());
                    scopes = flows.getImplicit().getScopes();
                } else if (flows.getPassword() != null) {
                    oauth2.password(flows.getPassword().getTokenUrl());
                    scopes = flows.getPassword().getScopes();
                } else if (flows.getClientCredentials() != null) {
                    oauth2.application(flows.getClientCredentials().getTokenUrl());
                    scopes = flows.getClientCredentials().getScopes();
                } else if (flows.getAuthorizationCode() != null) {
                    oauth2.accessCode(flows.getAuthorizationCode().getAuthorizationUrl(), flows.getAuthorizationCode().getTokenUrl());
                    scopes = flows.getAuthorizationCode().getScopes();
                }
                if (scopes != null) {
                    for (Map.Entry entry : scopes.entrySet()) {
                        oauth2.addScope((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                swaggerScheme = oauth2;
                break;
            }
            default: {
                throw new IllegalStateException("Security scheme " + securityScheme.getType().toString() + "is not supported in OpenAPI 2");
            }
        }
        if (swaggerScheme != null && securityScheme.getDescription() != null) {
            swaggerScheme.setDescription(securityScheme.getDescription());
        }
        return swaggerScheme;
    }

    private void setServerInfo(Swagger openApi2, List<Server> servers) {
        for (Server server : servers) {
            String serverUrl = server.getUrl();
            if (serverUrl == null || serverUrl.isEmpty()) continue;
            try {
                URL url = new URL(serverUrl);
                openApi2.setHost(url.getHost() + ":" + url.getPort());
                openApi2.setBasePath(url.getPath());
                Scheme scheme = Scheme.forValue((String)url.getProtocol());
                if (scheme == null) continue;
                openApi2.addScheme(scheme);
            }
            catch (MalformedURLException e) {
                this.log.warn("Malformed URL in configuration: {}", (Object)serverUrl);
                int basePathIndex = serverUrl.lastIndexOf(47);
                if (basePathIndex > 0) {
                    openApi2.setBasePath(serverUrl.substring(basePathIndex));
                } else {
                    basePathIndex = serverUrl.length() - 1;
                }
                int protIndex = serverUrl.indexOf("://");
                if (protIndex > 0) {
                    String protocol = serverUrl.substring(0, protIndex);
                    Scheme scheme = Scheme.forValue((String)protocol);
                    if (scheme != null) {
                        openApi2.addScheme(scheme);
                    }
                    openApi2.setHost(serverUrl.substring(protIndex + 3, basePathIndex));
                    continue;
                }
                openApi2.setHost(serverUrl.substring(0, basePathIndex));
            }
        }
    }

    public byte[] getSwaggerAsJson() {
        ObjectMapper mapper = Json.mapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return mapper.writeValueAsBytes((Object)this.openApi2);
        }
        catch (JsonProcessingException e) {
            return new byte[0];
        }
    }

    public byte[] getSwaggerAsYaml() {
        ObjectMapper mapper = Json.mapper();
        try {
            JsonNode node = mapper.readTree(this.getSwaggerAsJson());
            return Yaml.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)node);
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    private Map<String, Path> getPaths(Paths paths) {
        HashMap<String, Path> swaggerPaths = new HashMap<String, Path>();
        for (Map.Entry pathItem : paths.entrySet()) {
            swaggerPaths.put((String)pathItem.getKey(), this.convertPathItem((PathItem)pathItem.getValue()));
        }
        return swaggerPaths;
    }

    private Path convertPathItem(PathItem pathItem) {
        Path path = new Path();
        for (Map.Entry op : pathItem.readOperationsMap().entrySet()) {
            path.set(((PathItem.HttpMethod)op.getKey()).name().toLowerCase(), this.convertOperation((io.swagger.v3.oas.models.Operation)op.getValue()));
        }
        return path;
    }

    private Operation convertOperation(io.swagger.v3.oas.models.Operation openApiOp) {
        Operation swaggerOp = new Operation().operationId(openApiOp.getOperationId());
        if (openApiOp.getTags() != null) {
            swaggerOp.setTags(openApiOp.getTags());
        }
        if (openApiOp.getExtensions() != null) {
            swaggerOp.setVendorExtensions(openApiOp.getExtensions());
        }
        swaggerOp.setSummary(openApiOp.getSummary());
        swaggerOp.setDeprecated(openApiOp.getDeprecated());
        if (openApiOp.getSecurity() != null) {
            for (SecurityRequirement srs : openApiOp.getSecurity()) {
                for (Map.Entry sr : srs.entrySet()) {
                    swaggerOp.addSecurity((String)sr.getKey(), (List)sr.getValue());
                }
            }
        }
        if (openApiOp.getParameters() != null) {
            for (io.swagger.v3.oas.models.parameters.Parameter param : openApiOp.getParameters()) {
                swaggerOp.addParameter(this.convertParameter(param));
            }
        }
        if (openApiOp.getRequestBody() != null) {
            swaggerOp.addParameter(this.convertRequestBodyToParameter(openApiOp.getRequestBody()));
            swaggerOp.setConsumes(this.getConsumers(openApiOp.getRequestBody()));
        }
        if (openApiOp.getResponses() != null) {
            for (Map.Entry resp : openApiOp.getResponses().entrySet()) {
                swaggerOp.addResponse((String)resp.getKey(), this.convertResponse((ApiResponse)resp.getValue()));
            }
            swaggerOp.setProduces(this.getProducers(openApiOp.getResponses().values()));
        }
        return swaggerOp;
    }

    private List<String> getProducers(Collection<ApiResponse> apiResponses) {
        ArrayList<String> producers = new ArrayList<String>();
        for (ApiResponse response : apiResponses) {
            if (response.getContent() == null) continue;
            producers.addAll(response.getContent().keySet());
        }
        return producers;
    }

    private Response convertResponse(ApiResponse apiResponse) {
        Response response = new Response().description(apiResponse.getDescription());
        HashMap<String, Object> examples = new HashMap<String, Object>();
        if (apiResponse.getContent() != null) {
            for (MediaType mediaType : apiResponse.getContent().values()) {
                if (mediaType.getSchema() == null) continue;
                response.setResponseSchema(this.convertSchema(mediaType.getSchema()));
                if (mediaType.getExamples() == null) break;
                for (Map.Entry ex : mediaType.getExamples().entrySet()) {
                    examples.put((String)ex.getKey(), ((Example)ex.getValue()).getValue());
                }
            }
        }
        if (!examples.isEmpty()) {
            response.setExamples(examples);
        }
        if (apiResponse.getHeaders() != null) {
            for (Map.Entry entry : apiResponse.getHeaders().entrySet()) {
                Property headerProp = this.convertHeaderToProperty((Header)entry.getValue());
                if (headerProp == null) continue;
                response.addHeader((String)entry.getKey(), headerProp);
            }
        }
        return response;
    }

    private Property convertHeaderToProperty(Header header) {
        if (header.getSchema() != null) {
            Property headerProp = this.convertSchemaToProperty(header.getSchema());
            if (header.getDescription() != null) {
                headerProp.setDescription(header.getDescription());
            }
            return headerProp;
        }
        this.log.warn("Missing schema for Header {}", (Object)header);
        return null;
    }

    private List<String> getConsumers(RequestBody requestBody) {
        if (requestBody.getContent() != null) {
            return new ArrayList<String>(requestBody.getContent().keySet());
        }
        return Collections.emptyList();
    }

    private Parameter convertRequestBodyToParameter(RequestBody requestBody) {
        BodyParameter bodyParam = new BodyParameter().name("body");
        if (requestBody.getRequired().booleanValue()) {
            bodyParam.setRequired(requestBody.getRequired().booleanValue());
        }
        if (requestBody.getDescription() != null && !requestBody.getDescription().isEmpty()) {
            bodyParam.setDescription(requestBody.getDescription());
        }
        if (requestBody.getContent() != null) {
            for (Object contentType : requestBody.getContent().values()) {
                if (contentType.getSchema() == null) continue;
                bodyParam.setSchema(this.convertSchema(contentType.getSchema()));
                break;
            }
            for (Object contentType : requestBody.getContent().entrySet()) {
                if (((MediaType)contentType.getValue()).getExample() == null) continue;
                bodyParam.addExample((String)contentType.getKey(), ((MediaType)contentType.getValue()).getExample().toString());
            }
        }
        return bodyParam;
    }

    private Model convertSchema(Schema schema) {
        Object model = null;
        if (schema instanceof FileSchema) {
            return new ModelImpl().type("file");
        }
        if (schema.get$ref() != null) {
            return new RefModel(this.convertRef(schema.get$ref()));
        }
        model = schema.getItems() != null ? new ArrayModel().items(this.convertSchemaToProperty(schema.getItems())) : new ModelImpl().type(schema.getType()).format(schema.getFormat());
        if (schema.getProperties() != null) {
            model.setProperties(this.convertPropertiesMap(schema.getProperties()));
        }
        if (schema.getRequired() != null && model instanceof ModelImpl) {
            for (Object req : schema.getRequired()) {
                ((ModelImpl)model).addRequired(req.toString());
            }
        }
        if (schema.getDescription() != null && !schema.getDescription().isEmpty()) {
            model.setDescription(schema.getDescription());
        }
        if (schema.getExtensions() != null) {
            ((ModelImpl)model).setVendorExtensions(schema.getExtensions());
        }
        return model;
    }

    private Map<String, Property> convertPropertiesMap(Map properties) {
        HashMap<String, Property> swaggerProps = new HashMap<String, Property>(properties.size());
        for (Map.Entry propEntry : properties.entrySet()) {
            swaggerProps.put((String)propEntry.getKey(), this.convertSchemaToProperty((Schema)propEntry.getValue()));
        }
        return swaggerProps;
    }

    private String convertRef(String schemaRef) {
        return schemaRef.replace("#/components/schemas", "#/definitions");
    }

    private Parameter convertParameter(io.swagger.v3.oas.models.parameters.Parameter param) {
        switch (param.getIn()) {
            case "path": {
                return this.initParam((AbstractSerializableParameter)new PathParameter(), param);
            }
            case "query": {
                return this.initParam((AbstractSerializableParameter)new QueryParameter(), param);
            }
            case "cookie": {
                return this.initParam((AbstractSerializableParameter)new CookieParameter(), param);
            }
            case "header": {
                return this.initParam((AbstractSerializableParameter)new HeaderParameter(), param);
            }
        }
        return null;
    }

    private Parameter initParam(AbstractSerializableParameter swaggerParam, io.swagger.v3.oas.models.parameters.Parameter param) {
        swaggerParam.name(param.getName()).required(param.getRequired().booleanValue());
        if (param.getDescription() != null) {
            swaggerParam.setDescription(param.getDescription());
        }
        if (param.getStyle() != null) {
            swaggerParam.setCollectionFormat(this.convertStyleToCollectionFormat(param.getStyle()));
        }
        if (param.getSchema() != null) {
            swaggerParam.setType(param.getSchema().getType());
            swaggerParam.setFormat(param.getSchema().getFormat());
            if (param.getSchema().getDefault() != null) {
                swaggerParam.setDefault(param.getSchema().getDefault());
            }
            if (param.getSchema().getItems() != null) {
                swaggerParam.setItems(this.convertSchemaToProperty(param.getSchema().getItems()));
            }
            if (param.getSchema().getEnum() != null) {
                List enums = param.getSchema().getEnum().stream().map(v -> {
                    if (v instanceof byte[]) {
                        return new String(Base64.getEncoder().encode((byte[])v));
                    }
                    if (v instanceof Date) {
                        return RestOpenApiSupport.DEFAULT_DATE_FORMAT.format(v);
                    }
                    return v.toString();
                }).collect(Collectors.toList());
                swaggerParam.setEnum(enums);
            }
        }
        if (param.getExample() != null) {
            swaggerParam.setExample(param.getExample().toString());
        } else if (param.getExamples() != null && !param.getExamples().isEmpty()) {
            swaggerParam.setExample(((Example)param.getExamples().values().iterator().next()).getValue().toString());
        }
        return swaggerParam;
    }

    private String convertStyleToCollectionFormat(Parameter.StyleEnum style) {
        switch (style) {
            case FORM: {
                return "csv";
            }
            case SPACEDELIMITED: {
                return "ssv";
            }
            case PIPEDELIMITED: {
                return "pipes";
            }
            case DEEPOBJECT: {
                return "multi";
            }
        }
        return "csv";
    }

    private Property convertSchemaToProperty(Schema schema) {
        if (schema.get$ref() != null) {
            return new RefProperty(this.convertRef(schema.get$ref()));
        }
        if (schema instanceof IntegerSchema) {
            IntegerProperty prop = new IntegerProperty();
            prop.setFormat(schema.getFormat());
            return prop;
        }
        if (schema instanceof NumberSchema) {
            if ("float".equals(schema.getFormat())) {
                return new FloatProperty();
            }
            if ("double".equals(schema.getFormat())) {
                return new DoubleProperty();
            }
            if ("int64".equals(schema.getFormat())) {
                return new LongProperty();
            }
            return new BaseIntegerProperty(schema.getFormat());
        }
        if (schema instanceof ByteArraySchema) {
            return new ByteArrayProperty();
        }
        if (schema instanceof BinarySchema) {
            return new BinaryProperty();
        }
        if (schema instanceof DateSchema) {
            return new DateProperty();
        }
        if (schema instanceof DateTimeSchema) {
            return new DateTimeProperty();
        }
        if (schema instanceof PasswordSchema) {
            return new PasswordProperty();
        }
        if (schema instanceof FileSchema) {
            return new FileProperty();
        }
        if (schema instanceof StringSchema) {
            StringProperty prop = new StringProperty(schema.getFormat());
            if (schema.getEnum() != null) {
                prop.setEnum(schema.getEnum());
            }
            return prop;
        }
        if (schema instanceof ArraySchema) {
            return new ArrayProperty(this.convertSchemaToProperty(schema.getItems()));
        }
        if (schema instanceof MapSchema) {
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                return new MapProperty(this.convertSchemaToProperty((Schema)schema.getAdditionalProperties()));
            }
            if (schema.getAdditionalItems() != null) {
                return new MapProperty(this.convertSchemaToProperty(schema.getAdditionalItems()));
            }
            return new MapProperty();
        }
        return PropertyBuilder.build((String)schema.getType(), (String)schema.getFormat(), null);
    }

    private List<io.swagger.models.Tag> getTags(List<Tag> tags) {
        if (tags != null) {
            ArrayList<io.swagger.models.Tag> swaggerTags = new ArrayList<io.swagger.models.Tag>(tags.size());
            for (Tag tag : tags) {
                swaggerTags.add(new io.swagger.models.Tag().name(tag.getName()).description(tag.getDescription()));
            }
            return swaggerTags;
        }
        return null;
    }

    private Info convertInfo(io.swagger.v3.oas.models.info.Info info) {
        if (info != null) {
            return new Info().description(info.getDescription()).title(info.getTitle()).termsOfService(info.getTermsOfService()).version(info.getVersion()).contact(this.convertContact(info.getContact())).license(this.convertLicense(info.getLicense()));
        }
        return null;
    }

    private io.swagger.models.License convertLicense(License license) {
        if (license != null) {
            return new io.swagger.models.License().name(license.getName()).url(license.getUrl());
        }
        return null;
    }

    private Contact convertContact(io.swagger.v3.oas.models.info.Contact contact) {
        if (contact != null) {
            return new Contact().name(contact.getName()).email(contact.getEmail()).url(contact.getUrl());
        }
        return null;
    }
}

