/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Discriminator;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestModelConverters {
    private static final Logger LOG = LoggerFactory.getLogger(RestModelConverters.class);
    private static final ModelConverters MODEL30_CONVERTERS = ModelConverters.getInstance();
    private static final ModelConverters MODEL20_CONVERTERS;

    public List<? extends OasSchema> readClass(OasDocument oasDocument, Class<?> clazz) {
        if (clazz.equals(File.class)) {
            return null;
        }
        if (oasDocument instanceof Oas20Document) {
            return this.readClassOas20((Oas20Document)oasDocument, clazz);
        }
        if (oasDocument instanceof Oas30Document) {
            return this.readClassOas30((Oas30Document)oasDocument, clazz);
        }
        return null;
    }

    private List<? extends OasSchema> readClassOas30(Oas30Document oasDocument, Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        if (oasDocument.components == null) {
            oasDocument.components = oasDocument.createComponents();
        }
        Map swaggerModel = MODEL30_CONVERTERS.readAll(clazz);
        swaggerModel.forEach((key, schema) -> {
            Oas30SchemaDefinition model = oasDocument.components.createSchemaDefinition(key);
            oasDocument.components.addSchemaDefinition(key, model);
            this.processSchema((OasSchema)model, (io.swagger.v3.oas.models.media.Schema)schema);
        });
        return oasDocument.components.getSchemaDefinitions();
    }

    private List<? extends OasSchema> readClassOas20(Oas20Document oasDocument, Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        if (oasDocument.definitions == null) {
            oasDocument.definitions = oasDocument.createDefinitions();
        }
        Map swaggerModel = MODEL20_CONVERTERS.readAll(clazz);
        swaggerModel.forEach((key, schema) -> {
            Oas20SchemaDefinition model = oasDocument.definitions.createSchemaDefinition(key);
            oasDocument.definitions.addDefinition(key, model);
            this.processSchema((OasSchema)model, (io.swagger.v3.oas.models.media.Schema)schema);
        });
        return oasDocument.definitions.getDefinitions();
    }

    private void processSchema(OasSchema model, io.swagger.v3.oas.models.media.Schema schema) {
        Object example;
        String description;
        String type;
        model.type = type = schema.getType();
        model.format = schema.getFormat();
        String ref = schema.get$ref();
        if (ref != null) {
            model.$ref = model instanceof Oas20Schema ? "#/definitions/" + ref.substring("#/components/schemas/".length()) : ref;
        }
        if (model instanceof Oas30SchemaDefinition && schema instanceof ComposedSchema) {
            String composedSchema = (ComposedSchema)schema;
            Oas30SchemaDefinition modelDefinition = (Oas30SchemaDefinition)model;
            boolean xOf = false;
            if (null != composedSchema.getOneOf()) {
                xOf = true;
                for (io.swagger.v3.oas.models.media.Schema oneOfSchema : composedSchema.getOneOf()) {
                    if (null == oneOfSchema.get$ref()) continue;
                    Oas30Schema.Oas30OneOfSchema oneOfModel = modelDefinition.createOneOfSchema();
                    oneOfModel.setReference(oneOfSchema.get$ref());
                    modelDefinition.addOneOfSchema(oneOfModel);
                    type = null;
                    model.type = null;
                }
            }
            if (null != composedSchema.getAllOf()) {
                xOf = true;
                for (io.swagger.v3.oas.models.media.Schema allOfSchema : composedSchema.getAllOf()) {
                    if (null == allOfSchema.get$ref()) continue;
                    OasSchema allOfModel = modelDefinition.createAllOfSchema();
                    allOfModel.setReference(allOfSchema.get$ref());
                    modelDefinition.addAllOfSchema(allOfModel);
                    type = null;
                    model.type = null;
                }
            }
            if (null != composedSchema.getAnyOf()) {
                xOf = true;
                for (io.swagger.v3.oas.models.media.Schema anyOfSchema : composedSchema.getAnyOf()) {
                    if (null == anyOfSchema.get$ref()) continue;
                    Oas30Schema.Oas30AnyOfSchema anyOfModel = modelDefinition.createAnyOfSchema();
                    anyOfModel.setReference(anyOfSchema.get$ref());
                    modelDefinition.addAnyOfSchema(anyOfModel);
                    type = null;
                    model.type = null;
                }
            }
            if (xOf && null != composedSchema.getDiscriminator()) {
                Discriminator discriminator = schema.getDiscriminator();
                Oas30Discriminator modelDiscriminator = modelDefinition.createDiscriminator();
                modelDiscriminator.propertyName = discriminator.getPropertyName();
                if (null != discriminator.getMapping()) {
                    discriminator.getMapping().entrySet().stream().forEach(e -> modelDiscriminator.addMapping((String)e.getKey(), (String)e.getValue()));
                }
                modelDefinition.discriminator = modelDiscriminator;
            }
        }
        if (type != null) {
            switch (type) {
                case "object": {
                    if (schema.getProperties() == null) break;
                    schema.getProperties().forEach((p, v) -> {
                        OasSchema property = (OasSchema)model.createPropertySchema((String)p);
                        model.addProperty((String)p, (Schema)property);
                        this.processSchema(property, (io.swagger.v3.oas.models.media.Schema)v);
                    });
                    break;
                }
                case "array": {
                    io.swagger.v3.oas.models.media.Schema items = ((ArraySchema)schema).getItems();
                    OasSchema modelItems = model.createItemsSchema();
                    model.items = modelItems;
                    this.processSchema(modelItems, items);
                    break;
                }
                case "string": {
                    if (schema.getEnum() == null) break;
                    model.enum_ = new ArrayList(schema.getEnum());
                    break;
                }
                case "boolean": 
                case "number": 
                case "integer": {
                    break;
                }
                default: {
                    LOG.warn("Encountered unexpected type {} in processing schema.", (Object)type);
                }
            }
        }
        if (schema.getRequired() != null) {
            model.required = new ArrayList(schema.getRequired());
        }
        if ((description = schema.getDescription()) != null) {
            model.description = description;
        }
        if ((example = schema.getExample()) != null) {
            model.example = example;
        }
        if (schema.getAdditionalProperties() instanceof io.swagger.v3.oas.models.media.Schema) {
            OasSchema additionalProperties = model.createAdditionalPropertiesSchema();
            model.additionalProperties = additionalProperties;
            this.processSchema(additionalProperties, (io.swagger.v3.oas.models.media.Schema)schema.getAdditionalProperties());
        }
        if (schema.getExtensions() != null) {
            schema.getExtensions().forEach((key, value) -> {
                Extension extension = model.createExtension();
                extension.name = (String)key;
                extension.value = value;
                model.addExtension((String)key, extension);
            });
        }
    }

    static {
        MODEL30_CONVERTERS.addConverter((ModelConverter)new ClassNameExtensionModelResolver(new FqnModelResolver()));
        MODEL20_CONVERTERS = ModelConverters.getInstance();
        MODEL20_CONVERTERS.addConverter((ModelConverter)new ClassNameExtensionModelResolver());
    }

    private static class ClassNameExtensionModelResolver
    extends ModelResolver {
        private final ModelResolver delegate;

        public ClassNameExtensionModelResolver() {
            this(new ModelResolver(new ObjectMapper()));
        }

        public ClassNameExtensionModelResolver(ModelResolver delegate) {
            super(delegate.objectMapper());
            this.delegate = delegate;
        }

        public io.swagger.v3.oas.models.media.Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> next) {
            JavaType type;
            io.swagger.v3.oas.models.media.Schema result = this.delegate.resolve(annotatedType, context, next);
            if (result != null && Objects.equals("object", result.getType()) && !(type = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType())).isContainerType()) {
                HashMap<String, String> value = new HashMap<String, String>();
                value.put("type", "string");
                value.put("format", type.getRawClass().getName());
                result.addExtension("x-className", value);
            }
            return result;
        }
    }

    private static class FqnModelResolver
    extends ModelResolver {
        public FqnModelResolver() {
            this(new ObjectMapper());
        }

        public FqnModelResolver(ObjectMapper mapper) {
            super(mapper);
            this._typeNameResolver.setUseFqn(true);
        }
    }
}

