/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2.api.impl;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.camel.component.olingo2.api.Olingo2App;
import org.apache.camel.component.olingo2.api.Olingo2ResponseHandler;
import org.apache.camel.component.olingo2.api.batch.Olingo2BatchChangeRequest;
import org.apache.camel.component.olingo2.api.batch.Olingo2BatchQueryRequest;
import org.apache.camel.component.olingo2.api.batch.Olingo2BatchRequest;
import org.apache.camel.component.olingo2.api.batch.Olingo2BatchResponse;
import org.apache.camel.component.olingo2.api.batch.Operation;
import org.apache.camel.component.olingo2.api.impl.AbstractFutureCallback;
import org.apache.camel.component.olingo2.api.impl.HttpMerge;
import org.apache.camel.component.olingo2.api.impl.ODataPathSegmentImpl;
import org.apache.camel.component.olingo2.api.impl.UriInfoWithType;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSet;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.api.client.batch.BatchPart;
import org.apache.olingo.odata2.api.client.batch.BatchQueryPart;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.EntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.UriParser;

public final class Olingo2AppImpl
implements Olingo2App {
    public static final String METADATA = "$metadata";
    private static final String SEPARATOR = "/";
    private static final String BOUNDARY_PREFIX = "batch_";
    private static final String BOUNDARY_PARAMETER = "; boundary=";
    private static final ContentType METADATA_CONTENT_TYPE = ContentType.create((String)"application/xml", (Charset)Consts.UTF_8);
    private static final ContentType SERVICE_DOCUMENT_CONTENT_TYPE = ContentType.create((String)"application/atomsvc+xml", (Charset)Consts.UTF_8);
    private static final String BATCH_CONTENT_TYPE = ContentType.create((String)"multipart/mixed").toString();
    private static final String BATCH = "$batch";
    private static final String MAX_DATA_SERVICE_VERSION = "MaxDataServiceVersion";
    private static final String MULTIPART_MIME_TYPE = "multipart/";
    private static final ContentType TEXT_PLAIN_WITH_CS_UTF_8 = ContentType.TEXT_PLAIN.withCharset(Consts.UTF_8);
    private final Closeable client;
    private String serviceUri;
    private ContentType contentType;
    private Map<String, String> httpHeaders;
    private EntityProviderReadProperties entityProviderReadProperties;
    private EntityProviderWriteProperties entityProviderWriteProperties;

    public Olingo2AppImpl(String serviceUri) {
        this(serviceUri, (HttpAsyncClientBuilder)null);
    }

    public Olingo2AppImpl(String serviceUri, HttpAsyncClientBuilder builder) {
        this.setServiceUri(serviceUri);
        CloseableHttpAsyncClient asyncClient = builder == null ? HttpAsyncClients.createDefault() : builder.build();
        asyncClient.start();
        this.client = asyncClient;
        this.contentType = ContentType.create((String)"application/json", (Charset)Consts.UTF_8);
    }

    public Olingo2AppImpl(String serviceUri, HttpClientBuilder builder) {
        this.setServiceUri(serviceUri);
        this.client = builder == null ? HttpClients.createDefault() : builder.build();
        this.contentType = ContentType.create((String)"application/json", (Charset)Consts.UTF_8);
    }

    @Override
    public void setServiceUri(String serviceUri) {
        if (serviceUri == null || serviceUri.isEmpty()) {
            throw new IllegalArgumentException("serviceUri is not set");
        }
        this.serviceUri = serviceUri.endsWith(SEPARATOR) ? serviceUri.substring(0, serviceUri.length() - 1) : serviceUri;
    }

    @Override
    public String getServiceUri() {
        return this.serviceUri;
    }

    @Override
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Override
    public void setEntityProviderReadProperties(EntityProviderReadProperties entityProviderReadProperties) {
        this.entityProviderReadProperties = entityProviderReadProperties;
    }

    @Override
    public EntityProviderReadProperties getEntityProviderReadProperties() {
        if (this.entityProviderReadProperties == null) {
            this.entityProviderReadProperties = EntityProviderReadProperties.init().build();
        }
        return this.entityProviderReadProperties;
    }

    @Override
    public void setEntityProviderWriteProperties(EntityProviderWriteProperties entityProviderWriteProperties) {
        this.entityProviderWriteProperties = entityProviderWriteProperties;
    }

    @Override
    public EntityProviderWriteProperties getEntityProviderWriteProperties() {
        if (this.entityProviderWriteProperties == null) {
            this.entityProviderWriteProperties = EntityProviderWriteProperties.serviceRoot(null).build();
        }
        return this.entityProviderWriteProperties;
    }

    @Override
    public String getContentType() {
        return this.contentType.toString();
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = ContentType.parse((String)contentType);
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> void read(Edm edm, String resourcePath, Map<String, String> queryParams, Map<String, String> endpointHttpHeaders, final Olingo2ResponseHandler<T> responseHandler) {
        final UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, queryParams);
        this.execute((HttpUriRequest)new HttpGet(this.createUri(resourcePath, this.encodeQueryParams(queryParams))), this.getResourceContentType(uriInfo), endpointHttpHeaders, new AbstractFutureCallback<T>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) throws IOException {
                Olingo2AppImpl.this.readContent(uriInfo, Olingo2AppImpl.headersToMap(result.getAllHeaders()), result.getEntity() != null ? result.getEntity().getContent() : null, responseHandler);
            }
        });
    }

    @Override
    public void uread(Edm edm, String resourcePath, Map<String, String> queryParams, Map<String, String> endpointHttpHeaders, final Olingo2ResponseHandler<InputStream> responseHandler) {
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, queryParams);
        this.execute((HttpUriRequest)new HttpGet(this.createUri(resourcePath, this.encodeQueryParams(queryParams))), this.getResourceContentType(uriInfo), endpointHttpHeaders, new AbstractFutureCallback<InputStream>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) throws IOException {
                responseHandler.onResponse(result.getEntity() != null ? result.getEntity().getContent() : null, Olingo2AppImpl.headersToMap(result.getAllHeaders()));
            }
        });
    }

    private Map<String, String> encodeQueryParams(Map<String, String> queryParams) {
        Map<String, String> encodedQueryParams = queryParams;
        if (queryParams != null) {
            encodedQueryParams = new HashMap<String, String>(queryParams.size());
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                encodedQueryParams.put(entry.getKey(), URLEncoder.encode(entry.getValue()));
            }
        }
        return encodedQueryParams;
    }

    private ContentType getResourceContentType(UriInfoWithType uriInfo) {
        ContentType resourceContentType;
        switch (uriInfo.getUriType()) {
            case URI0: {
                resourceContentType = SERVICE_DOCUMENT_CONTENT_TYPE;
                break;
            }
            case URI8: {
                resourceContentType = METADATA_CONTENT_TYPE;
                break;
            }
            case URI4: 
            case URI5: {
                if (uriInfo.isValue()) {
                    resourceContentType = TEXT_PLAIN_WITH_CS_UTF_8;
                    break;
                }
                resourceContentType = this.contentType;
                break;
            }
            case URI15: 
            case URI16: 
            case URI50A: 
            case URI50B: {
                resourceContentType = TEXT_PLAIN_WITH_CS_UTF_8;
                break;
            }
            default: {
                resourceContentType = this.contentType;
            }
        }
        return resourceContentType;
    }

    @Override
    public <T> void create(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo2ResponseHandler<T> responseHandler) {
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpPost(this.createUri(resourcePath, null)), uriInfo, endpointHttpHeaders, data, responseHandler, this.getEntityProviderWriteProperties());
    }

    @Override
    public <T> void update(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo2ResponseHandler<T> responseHandler) {
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, null);
        this.augmentWithETag(edm, resourcePath, endpointHttpHeaders, (HttpRequestBase)new HttpPut(this.createUri(resourcePath, null)), request -> this.writeContent(edm, (HttpEntityEnclosingRequestBase)((HttpPut)request), uriInfo, endpointHttpHeaders, data, responseHandler, this.getEntityProviderWriteProperties()), responseHandler);
    }

    @Override
    public <T> void patch(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo2ResponseHandler<T> responseHandler) {
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, null);
        this.augmentWithETag(edm, resourcePath, endpointHttpHeaders, (HttpRequestBase)new HttpPatch(this.createUri(resourcePath, null)), request -> this.writeContent(edm, (HttpEntityEnclosingRequestBase)((HttpPatch)request), uriInfo, endpointHttpHeaders, data, responseHandler, this.getEntityProviderWriteProperties()), responseHandler);
    }

    @Override
    public <T> void merge(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo2ResponseHandler<T> responseHandler) {
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, null);
        EntityProviderWriteProperties entityProviderWriteProperties = EntityProviderWriteProperties.fromProperties((EntityProviderWriteProperties)this.getEntityProviderWriteProperties()).isDataBasedPropertySerialization(true).build();
        this.augmentWithETag(edm, resourcePath, endpointHttpHeaders, (HttpRequestBase)new HttpMerge(this.createUri(resourcePath, null)), request -> this.writeContent(edm, (HttpMerge)((Object)request), uriInfo, endpointHttpHeaders, data, responseHandler, entityProviderWriteProperties), responseHandler);
    }

    @Override
    public void batch(Edm edm, Map<String, String> endpointHttpHeaders, Object data, Olingo2ResponseHandler<List<Olingo2BatchResponse>> responseHandler) {
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, BATCH, null);
        this.writeContent(edm, (HttpEntityEnclosingRequestBase)new HttpPost(this.createUri(BATCH, null)), uriInfo, endpointHttpHeaders, data, responseHandler, this.getEntityProviderWriteProperties());
    }

    @Override
    public void delete(String resourcePath, Map<String, String> endpointHttpHeaders, final Olingo2ResponseHandler<HttpStatusCodes> responseHandler) {
        HttpDelete deleteRequest = new HttpDelete(this.createUri(resourcePath));
        Consumer<HttpRequestBase> deleteFunction = request -> this.execute((HttpUriRequest)request, this.contentType, endpointHttpHeaders, new AbstractFutureCallback<HttpStatusCodes>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) {
                StatusLine statusLine = result.getStatusLine();
                responseHandler.onResponse(HttpStatusCodes.fromStatusCode((int)statusLine.getStatusCode()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
            }
        });
        this.augmentWithETag(null, resourcePath, endpointHttpHeaders, (HttpRequestBase)deleteRequest, deleteFunction, responseHandler);
    }

    private <T> void augmentWithETag(Edm edm, final String resourcePath, final Map<String, String> endpointHttpHeaders, final HttpRequestBase httpRequest, final Consumer<HttpRequestBase> delegateRequestFn, final Olingo2ResponseHandler<T> delegateResponseHandler) {
        if (edm == null) {
            Olingo2ResponseHandler<Edm> edmResponseHandler = new Olingo2ResponseHandler<Edm>(){

                @Override
                public void onResponse(Edm response, Map<String, String> responseHeaders) {
                    Olingo2AppImpl.this.augmentWithETag(response, resourcePath, endpointHttpHeaders, httpRequest, delegateRequestFn, delegateResponseHandler);
                }

                @Override
                public void onException(Exception ex) {
                    delegateResponseHandler.onException(ex);
                }

                @Override
                public void onCanceled() {
                    delegateResponseHandler.onCanceled();
                }
            };
            this.read(null, METADATA, null, null, edmResponseHandler);
        } else {
            Olingo2ResponseHandler eTagReadHandler = new Olingo2ResponseHandler<T>(){

                @Override
                public void onResponse(T response, Map<String, String> responseHeaders) {
                    if (response instanceof ODataEntry) {
                        ODataEntry e = (ODataEntry)response;
                        Optional.ofNullable(e.getMetadata()).map(EntryMetadata::getEtag).ifPresent(v -> httpRequest.addHeader("If-Match", v));
                    }
                    delegateRequestFn.accept(httpRequest);
                }

                @Override
                public void onException(Exception ex) {
                    delegateResponseHandler.onException(ex);
                }

                @Override
                public void onCanceled() {
                    delegateResponseHandler.onCanceled();
                }
            };
            this.read(edm, resourcePath, null, endpointHttpHeaders, eTagReadHandler);
        }
    }

    private <T> void readContent(UriInfoWithType uriInfo, Map<String, String> responseHeaders, InputStream content, Olingo2ResponseHandler<T> responseHandler) {
        try {
            responseHandler.onResponse(this.readContent(uriInfo, content), responseHeaders);
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
        catch (Error e) {
            responseHandler.onException((Exception)new ODataApplicationException("Runtime Error Occurred", Locale.ENGLISH, (Throwable)e));
        }
    }

    private <T> T readContent(UriInfoWithType uriInfo, InputStream content) throws EntityProviderException, ODataApplicationException {
        Object response;
        switch (uriInfo.getUriType()) {
            case URI0: {
                response = EntityProvider.readServiceDocument((InputStream)content, (String)SERVICE_DOCUMENT_CONTENT_TYPE.toString());
                break;
            }
            case URI8: {
                response = EntityProvider.readMetadata((InputStream)content, (boolean)false);
                break;
            }
            case URI7A: {
                response = EntityProvider.readLink((String)this.getContentType(), (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content);
                break;
            }
            case URI7B: {
                response = EntityProvider.readLinks((String)this.getContentType(), (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content);
                break;
            }
            case URI3: {
                List<EdmProperty> complexPropertyPath = uriInfo.getPropertyPath();
                EdmProperty complexProperty = complexPropertyPath.get(complexPropertyPath.size() - 1);
                response = EntityProvider.readProperty((String)this.getContentType(), (EdmProperty)complexProperty, (InputStream)content, (EntityProviderReadProperties)this.getEntityProviderReadProperties());
                break;
            }
            case URI4: 
            case URI5: {
                List<EdmProperty> simplePropertyPath = uriInfo.getPropertyPath();
                EdmProperty simpleProperty = simplePropertyPath.get(simplePropertyPath.size() - 1);
                if (uriInfo.isValue()) {
                    response = EntityProvider.readPropertyValue((EdmProperty)simpleProperty, (InputStream)content);
                    break;
                }
                response = EntityProvider.readProperty((String)this.getContentType(), (EdmProperty)simpleProperty, (InputStream)content, (EntityProviderReadProperties)this.getEntityProviderReadProperties());
                break;
            }
            case URI15: 
            case URI16: 
            case URI50A: 
            case URI50B: {
                String stringCount = new String(EntityProvider.readBinary((InputStream)content), Consts.UTF_8);
                response = Long.valueOf(stringCount);
                break;
            }
            case URI1: 
            case URI6B: {
                if (uriInfo.getCustomQueryOptions().containsKey("!deltatoken")) {
                    response = EntityProvider.readDeltaFeed((String)this.getContentType(), (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content, (EntityProviderReadProperties)this.getEntityProviderReadProperties());
                    break;
                }
                response = EntityProvider.readFeed((String)this.getContentType(), (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content, (EntityProviderReadProperties)this.getEntityProviderReadProperties());
                break;
            }
            case URI2: 
            case URI6A: {
                response = EntityProvider.readEntry((String)this.getContentType(), (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content, (EntityProviderReadProperties)this.getEntityProviderReadProperties());
                break;
            }
            case URI10: 
            case URI11: 
            case URI12: 
            case URI13: 
            case URI14: {
                response = EntityProvider.readFunctionImport((String)this.getContentType(), (EdmFunctionImport)uriInfo.getFunctionImport(), (InputStream)content, (EntityProviderReadProperties)this.getEntityProviderReadProperties());
                break;
            }
            default: {
                throw new ODataApplicationException("Unsupported resource type " + uriInfo.getTargetType(), Locale.ENGLISH);
            }
        }
        return (T)response;
    }

    private <T> void writeContent(final Edm edm, HttpEntityEnclosingRequestBase httpEntityRequest, final UriInfoWithType uriInfo, Map<String, String> endpointHttpHeaders, final Object content, final Olingo2ResponseHandler<T> responseHandler, EntityProviderWriteProperties entityProviderWriteProperties) {
        try {
            Header requestContentTypeHeader;
            final ODataResponse response = this.writeContent(edm, uriInfo, content, entityProviderWriteProperties);
            for (String header : response.getHeaderNames()) {
                httpEntityRequest.setHeader(header, response.getHeader(header));
            }
            if (response.getEntity() instanceof InputStream) {
                httpEntityRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)response.getEntity()));
            }
            ContentType requestContentType = (requestContentTypeHeader = httpEntityRequest.getFirstHeader("Content-Type")) != null ? ContentType.parse((String)requestContentTypeHeader.getValue()) : this.contentType;
            this.execute((HttpUriRequest)httpEntityRequest, requestContentType, endpointHttpHeaders, new AbstractFutureCallback<T>(responseHandler){

                @Override
                public void onCompleted(HttpResponse result) throws IOException, EntityProviderException, BatchException, ODataApplicationException {
                    boolean noEntity;
                    HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)result.getStatusLine().getStatusCode());
                    boolean bl = noEntity = result.getEntity() == null || result.getEntity().getContentLength() == 0L;
                    if (statusCode == HttpStatusCodes.NO_CONTENT || noEntity) {
                        responseHandler.onResponse(HttpStatusCodes.fromStatusCode((int)result.getStatusLine().getStatusCode()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                    } else {
                        switch (uriInfo.getUriType()) {
                            case URI9: {
                                String type = result.containsHeader("Content-Type") ? result.getFirstHeader("Content-Type").getValue() : null;
                                List singleResponses = EntityProvider.parseBatchResponse((InputStream)result.getEntity().getContent(), (String)type);
                                ArrayList<Olingo2BatchResponse> responses = new ArrayList<Olingo2BatchResponse>();
                                HashMap<String, String> contentIdLocationMap = new HashMap<String, String>();
                                List batchRequests = (List)content;
                                Iterator iterator = batchRequests.iterator();
                                for (BatchSingleResponse response2 : singleResponses) {
                                    Olingo2BatchRequest request = (Olingo2BatchRequest)iterator.next();
                                    if (request instanceof Olingo2BatchChangeRequest && ((Olingo2BatchChangeRequest)request).getContentId() != null) {
                                        contentIdLocationMap.put("$" + ((Olingo2BatchChangeRequest)request).getContentId(), response2.getHeader("Location"));
                                    }
                                    try {
                                        responses.add(Olingo2AppImpl.this.parseResponse(edm, contentIdLocationMap, request, response2));
                                    }
                                    catch (Exception e) {
                                        responses.add(new Olingo2BatchResponse(Integer.parseInt(response2.getStatusCode()), response2.getStatusInfo(), response2.getContentId(), response2.getHeaders(), new ODataApplicationException("Error parsing response for " + request + ": " + e.getMessage(), Locale.ENGLISH, (Throwable)e)));
                                    }
                                }
                                responseHandler.onResponse(responses, Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                            case URI4: 
                            case URI5: {
                                List<EdmProperty> simplePropertyPath = uriInfo.getPropertyPath();
                                EdmProperty simpleProperty = simplePropertyPath.get(simplePropertyPath.size() - 1);
                                if (uriInfo.isValue()) {
                                    responseHandler.onResponse(EntityProvider.readPropertyValue((EdmProperty)simpleProperty, (InputStream)result.getEntity().getContent()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                    break;
                                }
                                responseHandler.onResponse(EntityProvider.readProperty((String)Olingo2AppImpl.this.getContentType(), (EdmProperty)simpleProperty, (InputStream)result.getEntity().getContent(), (EntityProviderReadProperties)Olingo2AppImpl.this.getEntityProviderReadProperties()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                            case URI3: {
                                List<EdmProperty> complexPropertyPath = uriInfo.getPropertyPath();
                                EdmProperty complexProperty = complexPropertyPath.get(complexPropertyPath.size() - 1);
                                responseHandler.onResponse(EntityProvider.readProperty((String)Olingo2AppImpl.this.getContentType(), (EdmProperty)complexProperty, (InputStream)result.getEntity().getContent(), (EntityProviderReadProperties)Olingo2AppImpl.this.getEntityProviderReadProperties()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                            case URI7A: {
                                EdmEntitySet targetLinkEntitySet = uriInfo.getTargetEntitySet();
                                responseHandler.onResponse(EntityProvider.readLink((String)Olingo2AppImpl.this.getContentType(), (EdmEntitySet)targetLinkEntitySet, (InputStream)result.getEntity().getContent()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                            case URI7B: {
                                EdmEntitySet targetLinksEntitySet = uriInfo.getTargetEntitySet();
                                responseHandler.onResponse(EntityProvider.readLinks((String)Olingo2AppImpl.this.getContentType(), (EdmEntitySet)targetLinksEntitySet, (InputStream)result.getEntity().getContent()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                            case URI1: 
                            case URI6B: 
                            case URI2: 
                            case URI6A: {
                                responseHandler.onResponse(EntityProvider.readEntry((String)response.getContentHeader(), (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)result.getEntity().getContent(), (EntityProviderReadProperties)Olingo2AppImpl.this.getEntityProviderReadProperties()), Olingo2AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                            default: {
                                throw new ODataApplicationException("Unsupported resource type " + uriInfo.getTargetType(), Locale.ENGLISH);
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
        catch (Error e) {
            responseHandler.onException((Exception)new ODataApplicationException("Runtime Error Occurred", Locale.ENGLISH, (Throwable)e));
        }
    }

    private ODataResponse writeContent(Edm edm, UriInfoWithType uriInfo, Object content, EntityProviderWriteProperties entityProviderWriteProperties) throws ODataApplicationException, EdmException, EntityProviderException, URISyntaxException, IOException {
        ODataResponse response;
        String responseContentType = this.getContentType();
        switch (uriInfo.getUriType()) {
            case URI4: 
            case URI5: {
                List<EdmProperty> simplePropertyPath = uriInfo.getPropertyPath();
                EdmProperty simpleProperty = simplePropertyPath.get(simplePropertyPath.size() - 1);
                responseContentType = simpleProperty.getMimeType();
                if (uriInfo.isValue()) {
                    response = EntityProvider.writePropertyValue((EdmProperty)simpleProperty, (Object)content);
                    responseContentType = TEXT_PLAIN_WITH_CS_UTF_8.toString();
                    break;
                }
                response = EntityProvider.writeProperty((String)this.getContentType(), (EdmProperty)simpleProperty, (Object)content);
                break;
            }
            case URI3: {
                List<EdmProperty> complexPropertyPath = uriInfo.getPropertyPath();
                EdmProperty complexProperty = complexPropertyPath.get(complexPropertyPath.size() - 1);
                response = EntityProvider.writeProperty((String)responseContentType, (EdmProperty)complexProperty, (Object)content);
                break;
            }
            case URI7A: {
                EdmEntitySet targetLinkEntitySet = uriInfo.getTargetEntitySet();
                EntityProviderWriteProperties linkProperties = EntityProviderWriteProperties.fromProperties((EntityProviderWriteProperties)entityProviderWriteProperties).serviceRoot(new URI(this.serviceUri + SEPARATOR)).build();
                Map linkMap = (Map)content;
                response = EntityProvider.writeLink((String)responseContentType, (EdmEntitySet)targetLinkEntitySet, (Map)linkMap, (EntityProviderWriteProperties)linkProperties);
                break;
            }
            case URI7B: {
                EdmEntitySet targetLinksEntitySet = uriInfo.getTargetEntitySet();
                EntityProviderWriteProperties linksProperties = EntityProviderWriteProperties.fromProperties((EntityProviderWriteProperties)entityProviderWriteProperties).serviceRoot(new URI(this.serviceUri + SEPARATOR)).build();
                List linksMap = (List)content;
                response = EntityProvider.writeLinks((String)responseContentType, (EdmEntitySet)targetLinksEntitySet, (List)linksMap, (EntityProviderWriteProperties)linksProperties);
                break;
            }
            case URI1: 
            case URI6B: 
            case URI2: 
            case URI6A: {
                EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
                EntityProviderWriteProperties properties = EntityProviderWriteProperties.fromProperties((EntityProviderWriteProperties)entityProviderWriteProperties).serviceRoot(new URI(this.serviceUri + SEPARATOR)).build();
                Map objectMap = (Map)content;
                response = EntityProvider.writeEntry((String)responseContentType, (EdmEntitySet)targetEntitySet, (Map)objectMap, (EntityProviderWriteProperties)properties);
                break;
            }
            case URI9: {
                List batchParts = (List)content;
                response = this.parseBatchRequest(edm, batchParts);
                break;
            }
            default: {
                throw new ODataApplicationException("Unsupported resource type " + uriInfo.getTargetType(), Locale.ENGLISH);
            }
        }
        return response.getContentHeader() != null ? response : ODataResponse.fromResponse((ODataResponse)response).contentHeader(responseContentType).build();
    }

    private ODataResponse parseBatchRequest(Edm edm, List<Olingo2BatchRequest> batchParts) throws IOException, EntityProviderException, ODataApplicationException, EdmException, URISyntaxException {
        ArrayList<BatchPart> parts = new ArrayList<BatchPart>();
        ArrayList<BatchChangeSetPart> changeSetParts = new ArrayList<BatchChangeSetPart>();
        HashMap<String, String> contentIdMap = new HashMap<String, String>();
        for (Olingo2BatchRequest batchPart : batchParts) {
            if (batchPart instanceof Olingo2BatchQueryRequest) {
                if (!changeSetParts.isEmpty()) {
                    this.addChangeSetParts(parts, changeSetParts);
                    changeSetParts.clear();
                    contentIdMap.clear();
                }
                UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, batchPart.getResourcePath(), null);
                parts.add((BatchPart)this.createBatchQueryPart(uriInfo, (Olingo2BatchQueryRequest)batchPart));
                continue;
            }
            BatchChangeSetPart changeSetPart = this.createBatchChangeSetPart(edm, contentIdMap, (Olingo2BatchChangeRequest)batchPart);
            changeSetParts.add(changeSetPart);
        }
        if (!changeSetParts.isEmpty()) {
            this.addChangeSetParts(parts, changeSetParts);
        }
        String boundary = BOUNDARY_PREFIX + UUID.randomUUID();
        InputStream batchRequest = EntityProvider.writeBatchRequest(parts, (String)boundary);
        String contentHeader = BATCH_CONTENT_TYPE + BOUNDARY_PARAMETER + boundary;
        return ODataResponse.entity((Object)batchRequest).contentHeader(contentHeader).build();
    }

    private void addChangeSetParts(ArrayList<BatchPart> parts, ArrayList<BatchChangeSetPart> changeSetParts) {
        BatchChangeSet changeSet = BatchChangeSet.newBuilder().build();
        for (BatchChangeSetPart changeSetPart : changeSetParts) {
            changeSet.add(changeSetPart);
        }
        parts.add((BatchPart)changeSet);
    }

    private BatchChangeSetPart createBatchChangeSetPart(Edm edm, Map<String, String> contentIdMap, Olingo2BatchChangeRequest batchRequest) throws EdmException, URISyntaxException, EntityProviderException, IOException, ODataApplicationException {
        String resourcePath = batchRequest.getResourcePath();
        if (resourcePath.startsWith("$")) {
            resourcePath = Olingo2AppImpl.replaceContentId(edm, resourcePath, contentIdMap);
        }
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resourcePath, null);
        HashMap<String, String> headers = new HashMap<String, String>();
        byte[] body = null;
        if (batchRequest.getBody() != null && !Operation.DELETE.equals((Object)batchRequest.getOperation())) {
            ODataResponse response = this.writeContent(edm, uriInfo, batchRequest.getBody(), this.getEntityProviderWriteProperties());
            for (String header : response.getHeaderNames()) {
                headers.put(header, response.getHeader(header));
            }
            byte[] byArray = body = response.getEntity() instanceof InputStream ? EntityProvider.readBinary((InputStream)((InputStream)response.getEntity())) : null;
            if (body != null) {
                headers.put("Content-Length", String.valueOf(body.length));
            }
        }
        ContentType contentType = this.getResourceContentType(uriInfo);
        headers.put("Accept", contentType.withCharset("").toString().toLowerCase());
        Charset charset = contentType.getCharset();
        if (null != charset) {
            headers.put("Accept-Charset", charset.name().toLowerCase());
        }
        headers.computeIfAbsent("Content-Type", k -> this.getContentType());
        headers.putAll(batchRequest.getHeaders());
        String contentId = batchRequest.getContentId();
        if (contentId != null) {
            contentIdMap.put("$" + contentId, resourcePath);
        }
        return BatchChangeSetPart.uri((String)this.createBatchUri(batchRequest)).method(batchRequest.getOperation().getHttpMethod()).contentId(contentId).headers(headers).body(body == null ? null : new String(body, Consts.UTF_8)).build();
    }

    private BatchQueryPart createBatchQueryPart(UriInfoWithType uriInfo, Olingo2BatchQueryRequest batchRequest) {
        HashMap<String, String> headers = new HashMap<String, String>(batchRequest.getHeaders());
        ContentType contentType = this.getResourceContentType(uriInfo);
        Charset charset = contentType.getCharset();
        if (!headers.containsKey("Accept")) {
            headers.put("Accept", contentType.withCharset("").toString().toLowerCase());
        }
        if (!headers.containsKey("Accept-Charset") && null != charset) {
            headers.put("Accept-Charset", charset.name().toLowerCase());
        }
        return BatchQueryPart.method((String)"GET").uri(this.createBatchUri(batchRequest)).headers(headers).build();
    }

    private static String replaceContentId(Edm edm, String entityReference, Map<String, String> contentIdMap) throws EdmException {
        EdmEntitySet entitySet;
        List keyProperties;
        EdmEntityContainer entityContainer;
        int pathSeparator = entityReference.indexOf(47);
        StringBuilder referencedEntity = pathSeparator == -1 ? new StringBuilder(contentIdMap.get(entityReference)) : new StringBuilder(contentIdMap.get(entityReference.substring(0, pathSeparator)));
        String referencedEntityName = referencedEntity.toString();
        int containerSeparator = referencedEntityName.lastIndexOf(46);
        if (containerSeparator != -1) {
            String containerName = referencedEntityName.substring(0, containerSeparator);
            referencedEntityName = referencedEntityName.substring(containerSeparator + 1);
            entityContainer = edm.getEntityContainer(containerName);
            if (entityContainer == null) {
                throw new IllegalArgumentException("EDM does not have entity container " + containerName);
            }
        } else {
            entityContainer = edm.getDefaultEntityContainer();
            if (entityContainer == null) {
                throw new IllegalArgumentException("EDM does not have a default entity container, use a fully qualified entity set name");
            }
        }
        if ((keyProperties = (entitySet = entityContainer.getEntitySet(referencedEntityName)).getEntityType().getKeyProperties()).size() == 1) {
            referencedEntity.append("('dummy')");
        } else {
            referencedEntity.append("(");
            for (EdmProperty keyProperty : keyProperties) {
                referencedEntity.append(keyProperty.getName()).append('=').append("'dummy',");
            }
            referencedEntity.deleteCharAt(referencedEntity.length() - 1);
            referencedEntity.append(')');
        }
        return pathSeparator == -1 ? referencedEntityName : referencedEntity.append(entityReference, pathSeparator, entityReference.length()).toString();
    }

    private Olingo2BatchResponse parseResponse(Edm edm, Map<String, String> contentIdLocationMap, Olingo2BatchRequest request, BatchSingleResponse response) throws EntityProviderException, ODataApplicationException {
        String resourceLocation;
        int statusCode = Integer.parseInt(response.getStatusCode());
        String statusInfo = response.getStatusInfo();
        BasicHttpResponse httpResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusInfo));
        Map headers = response.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            httpResponse.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        ByteArrayInputStream content = null;
        try {
            if (response.getBody() != null) {
                String charset = Consts.UTF_8.toString();
                try {
                    ContentType partContentType = this.receiveWithCharsetParameter(ContentType.parse((String)((String)headers.get("Content-Type"))), Consts.UTF_8);
                    charset = partContentType.getCharset().toString();
                }
                catch (UnsupportedCharsetException | ParseException partContentType) {
                    // empty catch block
                }
                String body = response.getBody();
                content = body != null ? new ByteArrayInputStream(body.getBytes(charset)) : null;
                httpResponse.setEntity((HttpEntity)new StringEntity(body, charset));
            }
            AbstractFutureCallback.checkStatus((HttpResponse)httpResponse);
        }
        catch (UnsupportedEncodingException | ODataApplicationException e) {
            return new Olingo2BatchResponse(statusCode, statusInfo, response.getContentId(), response.getHeaders(), e);
        }
        String resourcePath = request.getResourcePath();
        String resolvedResourcePath = resourcePath.startsWith("$") && !METADATA.equals(resourcePath) && !BATCH.equals(resourcePath) ? this.findLocation(resourcePath, contentIdLocationMap) : ((resourceLocation = response.getHeader("Location")) != null ? resourceLocation.substring(this.serviceUri.length()) : resourcePath);
        Map<String, String> resolvedQueryParams = request instanceof Olingo2BatchQueryRequest ? ((Olingo2BatchQueryRequest)request).getQueryParams() : null;
        UriInfoWithType uriInfo = Olingo2AppImpl.parseUri(edm, resolvedResourcePath, resolvedQueryParams);
        Object resolvedContent = content != null ? this.readContent(uriInfo, content) : null;
        return new Olingo2BatchResponse(statusCode, statusInfo, response.getContentId(), response.getHeaders(), resolvedContent);
    }

    private ContentType receiveWithCharsetParameter(ContentType contentType, Charset charset) {
        if (contentType.getCharset() != null) {
            return contentType;
        }
        String mimeType = contentType.getMimeType();
        if (mimeType.equals(ContentType.TEXT_PLAIN.getMimeType()) || AbstractFutureCallback.ODATA_MIME_TYPE.matcher(mimeType).matches()) {
            return contentType.withCharset(charset);
        }
        return contentType;
    }

    private String findLocation(String resourcePath, Map<String, String> contentIdLocationMap) {
        int pathSeparator = resourcePath.indexOf(47);
        if (pathSeparator == -1) {
            return contentIdLocationMap.get(resourcePath);
        }
        return contentIdLocationMap.get(resourcePath.substring(0, pathSeparator)) + resourcePath.substring(pathSeparator);
    }

    private String createBatchUri(Olingo2BatchRequest part) {
        String result;
        if (part instanceof Olingo2BatchQueryRequest) {
            Olingo2BatchQueryRequest queryPart = (Olingo2BatchQueryRequest)part;
            result = this.createUri(queryPart.getResourcePath(), queryPart.getQueryParams());
        } else {
            result = this.createUri(part.getResourcePath());
        }
        return result.substring(this.serviceUri.length() + 1);
    }

    private String createUri(String resourcePath) {
        return this.createUri(resourcePath, null);
    }

    private String createUri(String resourcePath, Map<String, String> queryParams) {
        StringBuilder absolutUri = new StringBuilder(this.serviceUri).append(SEPARATOR).append(resourcePath);
        if (queryParams != null && !queryParams.isEmpty()) {
            absolutUri.append("?");
            int nParams = queryParams.size();
            int index = 0;
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                absolutUri.append(entry.getKey()).append('=').append(entry.getValue());
                if (++index >= nParams) continue;
                absolutUri.append('&');
            }
        }
        return absolutUri.toString();
    }

    private static UriInfoWithType parseUri(Edm edm, String resourcePath, Map<String, String> queryParams) {
        UriInfoWithType result;
        try {
            ArrayList<ODataPathSegmentImpl> pathSegments = new ArrayList<ODataPathSegmentImpl>();
            String[] segments = new URI(resourcePath).getPath().split(SEPARATOR);
            if (queryParams == null) {
                queryParams = Collections.emptyMap();
            }
            for (String segment : segments) {
                if (segment.indexOf(59) == -1) {
                    pathSegments.add(new ODataPathSegmentImpl(segment, null));
                    continue;
                }
                String[] splitSegment = segment.split(";");
                segment = splitSegment[0];
                HashMap<String, List<String>> matrixParams = new HashMap<String, List<String>>();
                for (int i = 1; i < splitSegment.length; ++i) {
                    String[] param = splitSegment[i].split("=");
                    ArrayList<String> values = (ArrayList<String>)matrixParams.get(param[0]);
                    if (values == null) {
                        values = new ArrayList<String>();
                        matrixParams.put(param[0], values);
                    }
                    if (param[1].indexOf(44) == -1) {
                        values.add(param[1]);
                        continue;
                    }
                    values.addAll(Arrays.asList(param[1].split(",")));
                }
                pathSegments.add(new ODataPathSegmentImpl(segment, matrixParams));
            }
            result = new UriInfoWithType(UriParser.parse((Edm)edm, pathSegments, queryParams), resourcePath);
        }
        catch (URISyntaxException | ODataException e) {
            throw new IllegalArgumentException("resourcePath: " + e.getMessage(), e);
        }
        return result;
    }

    private static Map<String, String> headersToMap(Header[] headers) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header header : headers) {
            responseHeaders.put(header.getName(), header.getValue());
        }
        return responseHeaders;
    }

    public void execute(HttpUriRequest httpUriRequest, ContentType contentType, Map<String, String> endpointHttpHeaders, FutureCallback<HttpResponse> callback) {
        if (!ContentType.APPLICATION_FORM_URLENCODED.getMimeType().equals(contentType.getMimeType()) && !contentType.getMimeType().startsWith(MULTIPART_MIME_TYPE)) {
            httpUriRequest.addHeader("Accept", contentType.withCharset("").toString().toLowerCase());
            Charset charset = contentType.getCharset();
            if (null != charset) {
                httpUriRequest.addHeader("Accept-Charset", charset.name().toLowerCase());
            }
        }
        if (httpUriRequest instanceof HttpEntityEnclosingRequestBase && httpUriRequest.getFirstHeader("Content-Type") == null) {
            httpUriRequest.addHeader("Content-Type", contentType.toString());
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            for (Map.Entry entry : this.httpHeaders.entrySet()) {
                httpUriRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (endpointHttpHeaders != null && !endpointHttpHeaders.isEmpty()) {
            for (Map.Entry entry : endpointHttpHeaders.entrySet()) {
                httpUriRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!httpUriRequest.containsHeader("DataServiceVersion")) {
            httpUriRequest.addHeader("DataServiceVersion", "2.0");
        }
        if (!httpUriRequest.containsHeader(MAX_DATA_SERVICE_VERSION)) {
            httpUriRequest.addHeader(MAX_DATA_SERVICE_VERSION, "3.0");
        }
        if (this.client instanceof CloseableHttpAsyncClient) {
            ((CloseableHttpAsyncClient)this.client).execute(httpUriRequest, callback);
        } else {
            try {
                CloseableHttpResponse result = ((CloseableHttpClient)this.client).execute(httpUriRequest);
                callback.completed((Object)result);
            }
            catch (IOException e) {
                callback.failed((Exception)e);
            }
        }
    }
}

