/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.observation;

import io.micrometer.observation.Observation;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Map;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.Tag;

public class MicrometerObservationSpanAdapter
implements SpanAdapter {
    private static final String DEFAULT_EVENT_NAME = "log";
    private final Observation observation;
    private final Tracer tracer;

    MicrometerObservationSpanAdapter(Observation observation, Tracer tracer) {
        this.observation = observation;
        this.tracer = tracer;
    }

    Observation getMicrometerObservation() {
        return this.observation;
    }

    public void setComponent(String component) {
        this.observation.lowCardinalityKeyValue("component", component);
    }

    public void setError(boolean error) {
        this.observation.lowCardinalityKeyValue("error", String.valueOf(error));
    }

    public void setTag(Tag key, String value) {
        this.observation.highCardinalityKeyValue(key.toString(), value);
        this.observation.highCardinalityKeyValue(key.getAttribute(), value);
    }

    public void setTag(Tag key, Number value) {
        this.setTag(key, value.toString());
    }

    public void setTag(String key, String value) {
        this.observation.highCardinalityKeyValue(key, value);
    }

    public void setTag(String key, Number value) {
        this.setTag(key, value.toString());
    }

    public void setTag(String key, Boolean value) {
        this.setTag(key, value.toString());
    }

    public void setLowCardinalityTag(Tag key, String value) {
        this.observation.lowCardinalityKeyValue(key.toString(), value);
        this.observation.lowCardinalityKeyValue(key.getAttribute(), value);
    }

    public void setLowCardinalityTag(Tag key, Number value) {
        this.observation.lowCardinalityKeyValue(key.toString(), value.toString());
        this.observation.lowCardinalityKeyValue(key.getAttribute(), value.toString());
    }

    public void setLowCardinalityTag(String key, String value) {
        this.observation.lowCardinalityKeyValue(key, value);
    }

    public void setLowCardinalityTag(String key, Number value) {
        this.observation.lowCardinalityKeyValue(key, value.toString());
    }

    public void setLowCardinalityTag(String key, Boolean value) {
        this.observation.lowCardinalityKeyValue(key, value.toString());
    }

    public void log(Map<String, String> fields) {
        String event = fields.get("event");
        if ("error".equalsIgnoreCase(event)) {
            if (fields.containsKey("message")) {
                this.observation.error((Throwable)new RuntimeException(fields.get("message")));
            } else {
                this.setError(true);
            }
        } else {
            this.observation.event(() -> this.getMessageNameFromFields(fields));
        }
    }

    public String traceId() {
        TracingObservationHandler.TracingContext tracingContext = this.getTracingContext();
        return tracingContext.getSpan() != null ? tracingContext.getSpan().context().traceId() : null;
    }

    private TracingObservationHandler.TracingContext getTracingContext() {
        return (TracingObservationHandler.TracingContext)this.observation.getContextView().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
    }

    public String spanId() {
        TracingObservationHandler.TracingContext tracingContext = this.getTracingContext();
        return tracingContext.getSpan() != null ? tracingContext.getSpan().context().spanId() : null;
    }

    public AutoCloseable makeCurrent() {
        return this.observation.openScope();
    }

    String getMessageNameFromFields(Map<String, ?> fields) {
        Object eventValue;
        Object object = eventValue = fields == null ? null : (Object)fields.get("message");
        if (eventValue != null) {
            return eventValue.toString();
        }
        return DEFAULT_EVENT_NAME;
    }

    public void setCorrelationContextItem(String key, String value) {
        Baggage baggage = this.tracer.createBaggage(key);
        Span span = this.getTracingContext().getSpan();
        if (span == null) {
            return;
        }
        baggage.set(span.context(), value);
    }

    public String getContextPropagationItem(String key) {
        Span span = this.getTracingContext().getSpan();
        if (span == null) {
            return null;
        }
        Baggage baggage = this.tracer.getBaggage(span.context(), key);
        if (baggage != null) {
            return baggage.get(span.context());
        }
        return null;
    }
}

