/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.observation;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.observation.MicrometerObservationSpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetCorrelationContextProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SetCorrelationContextProcessor.class);
    private String id;
    private String routeId;
    private final String baggageName;
    private final Expression expression;

    public SetCorrelationContextProcessor(String baggageName, Expression expression) {
        this.baggageName = (String)ObjectHelper.notNull((Object)baggageName, (String)"baggageName");
        this.expression = (Expression)ObjectHelper.notNull((Object)expression, (String)"expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            MicrometerObservationSpanAdapter camelSpan = (MicrometerObservationSpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            if (camelSpan != null) {
                String item = (String)this.expression.evaluate(exchange, String.class);
                camelSpan.setCorrelationContextItem(this.baggageName, item);
            } else {
                LOG.warn("OpenTelemetry: could not find managed span for exchange={}", (Object)exchange);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String getTraceLabel() {
        return "setCorrelationContext[" + this.baggageName + ", " + String.valueOf(this.expression) + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getBaggageName() {
        return this.baggageName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public String toString() {
        return this.id;
    }
}

