/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.component;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.oaipmh.component.OAIPMHComponent;
import org.apache.camel.oaipmh.component.OAIPMHConsumer;
import org.apache.camel.oaipmh.component.OAIPMHProducer;
import org.apache.camel.oaipmh.component.model.OAIPMHConstants;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.URISupport;
import org.joda.time.format.ISODateTimeFormat;

@UriEndpoint(firstVersion="3.5.0", scheme="oaipmh", title="OAI-PMH", syntax="oaipmh:baseUrl", lenientProperties=true, category={Category.ENDPOINT, Category.WEBSERVICE, Category.BATCH}, headersClass=OAIPMHConstants.class)
public class OAIPMHEndpoint
extends ScheduledPollEndpoint {
    private transient URI url;
    @UriPath(description="Base URL of the repository to which the request is made through the OAI-PMH protocol")
    @Metadata(required=true)
    private String baseUrl;
    @UriParam(description="Specifies a lower bound for datestamp-based selective harvesting. UTC DateTime value")
    private String from;
    @UriParam(description="Specifies an upper bound for datestamp-based selective harvesting. UTC DateTime value.")
    private String until;
    @UriParam(description="Specifies membership as a criteria for set-based selective harvesting")
    private String set;
    @UriParam(description="Request name supported by OAI-PMh protocol", defaultValue="ListRecords")
    private String verb = "ListRecords";
    @UriParam(description="Specifies the metadataPrefix of the format that should be included in the metadata part of the returned records.", defaultValue="oai_dc")
    private String metadataPrefix = "oai_dc";
    @UriParam(label="security", description="Causes the defined url to make an https request")
    private boolean ssl;
    @UriParam(label="security", description="Ignore SSL certificate warnings")
    private boolean ignoreSSLWarnings;
    @UriParam(description="Identifier of the requested resources. Applicable only with certain verbs")
    private String identifier;
    @UriParam(label="producer", description="Returns the response of a single request. Otherwise it will make requests until there is no more data to return.")
    private boolean onlyFirst;
    private Map<String, Object> queryParameters;

    public OAIPMHEndpoint(String uri, String remaining, OAIPMHComponent component) {
        super(uri, (Component)component);
        this.baseUrl = remaining;
    }

    public boolean isLenientProperties() {
        return true;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.validateParameters();
        String prefix = "";
        if (!this.baseUrl.startsWith("http:") && !this.baseUrl.startsWith("https:")) {
            prefix = this.isSsl() ? "https://" : "http://";
        }
        this.url = URI.create(prefix + this.baseUrl);
        if (this.queryParameters != null && !this.queryParameters.isEmpty()) {
            Map parameters = URISupport.parseParameters((URI)this.url);
            parameters.putAll(this.queryParameters);
            this.url = URISupport.createRemainingURI((URI)this.url, (Map)parameters);
        }
    }

    public Producer createProducer() throws Exception {
        return new OAIPMHProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        OAIPMHConsumer consumer = new OAIPMHConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    private void validateParameters() {
        if (this.from != null) {
            ISODateTimeFormat.dateTimeNoMillis().parseDateTime(this.from);
        }
        if (this.until != null) {
            ISODateTimeFormat.dateTimeNoMillis().parseDateTime(this.until);
        }
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Object> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public boolean isIgnoreSSLWarnings() {
        return this.ignoreSSLWarnings;
    }

    public void setIgnoreSSLWarnings(boolean ignoreSSLWarnings) {
        this.ignoreSSLWarnings = ignoreSSLWarnings;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public String getSet() {
        return this.set;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isOnlyFirst() {
        return this.onlyFirst;
    }

    public void setOnlyFirst(boolean onlyFist) {
        this.onlyFirst = onlyFist;
    }
}

