/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite;

import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nitrite.AbstractNitriteOperation;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.CollectionOperation;
import org.apache.camel.component.nitrite.operation.RepositoryOperation;
import org.apache.camel.component.nitrite.operation.common.UpsertOperation;
import org.apache.camel.support.DefaultProducer;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.objects.ObjectRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NitriteProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NitriteProducer.class);
    private NitriteEndpoint endpoint;
    private Consumer<AbstractNitriteOperation> operationValidator = noop -> {};

    public NitriteProducer(NitriteEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        if (endpoint.getNitriteCollection() instanceof ObjectRepository) {
            this.operationValidator = operation -> {
                if (!(operation instanceof RepositoryOperation)) {
                    throw new IllegalArgumentException(String.format("Attempted to run Collection-only operation %s on Repository %s", operation.getClass(), endpoint.getNitriteCollection()));
                }
            };
        }
        if (endpoint.getNitriteCollection() instanceof NitriteCollection) {
            this.operationValidator = operation -> {
                if (!(operation instanceof CollectionOperation)) {
                    throw new IllegalArgumentException(String.format("Attempted to run Repository-only operation %s on Collection %s", operation.getClass(), endpoint.getNitriteCollection()));
                }
            };
        }
    }

    public void process(Exchange exchange) throws Exception {
        AbstractNitriteOperation operation = (AbstractNitriteOperation)exchange.getMessage().getHeader("CamelNitriteOperation", AbstractNitriteOperation.class);
        if (operation == null) {
            operation = new UpsertOperation();
        }
        this.operationValidator.accept(operation);
        operation.execute(exchange, this.endpoint);
    }
}

