/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.codec;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DatagramPacketStringEncoder
extends MessageToMessageEncoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramPacketStringEncoder.class);
    private final Charset charset;

    public DatagramPacketStringEncoder() {
        this(Charset.defaultCharset());
    }

    public DatagramPacketStringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof CharSequence) {
            CharSequence payload = (CharSequence)msg.content();
            if (payload.length() == 0) {
                return;
            }
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope((Object)ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)CharBuffer.wrap(payload), (Charset)this.charset), (SocketAddress)((InetSocketAddress)msg.recipient()), (SocketAddress)((InetSocketAddress)msg.sender()));
            out.add(addressedEnvelop);
        } else {
            LOG.debug("Ignoring message content as it is not a java.lang.CharSequence instance.");
        }
    }
}

